/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.CustomInteractable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.ComponentLabel;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.lenses.LayoutHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.google.common.base.CaseFormat;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;

enum LensColour {
    WHITE(ItemComponent.create(Blocks.field_150325_L, 0).get()),
    ORANGE(ItemComponent.create(Blocks.field_150325_L, 1).get()),
    MAGENTA(ItemComponent.create(Blocks.field_150325_L, 2).get()),
    LIGHT_BLUE(ItemComponent.create(Blocks.field_150325_L, 3).get()),
    YELLOW(ItemComponent.create(Blocks.field_150325_L, 4).get()),
    LIME(ItemComponent.create(Blocks.field_150325_L, 5).get()),
    PINK(ItemComponent.create(Blocks.field_150325_L, 6).get()),
    GRAY(ItemComponent.create(Blocks.field_150325_L, 7).get()),
    LIGHT_GRAY(ItemComponent.create(Blocks.field_150325_L, 8).get()),
    CYAN(ItemComponent.create(Blocks.field_150325_L, 9).get()),
    PURPLE(ItemComponent.create(Blocks.field_150325_L, 10).get()),
    BLUE(ItemComponent.create(Blocks.field_150325_L, 11).get()),
    BROWN(ItemComponent.create(Blocks.field_150325_L, 12).get()),
    GREEN(ItemComponent.create(Blocks.field_150325_L, 13).get()),
    RED(ItemComponent.create(Blocks.field_150325_L, 14).get()),
    BLACK(ItemComponent.create(Blocks.field_150325_L, 15).get()),
    UNIQUE(ItemComponent.create(Items.field_151156_bN, 0));

    private final ItemComponent itemComponent;

    private LensColour(ItemComponent itemComponent) {
        this.itemComponent = itemComponent;
    }

    static LensColour get(String oreName) {
        String colour = oreName.substring("craftingLens".length());
        return LensColour.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, colour));
    }

    String translateColour() {
        return Lang.GREGTECH_5_LENSES.trans("colour." + this.name().toLowerCase().replace("_", ""));
    }

    CustomInteractable buildLabel() {
        return CustomInteractable.builder(ComponentLabel.create(this.itemComponent, LayoutHandler.LENS_COLOUR_POSITION)).setTooltip(Tooltip.create(Lang.GREGTECH_5_LENSES.transf("colourlenseslabel", this.translateColour()), Tooltip.INFO_FORMATTING)).build();
    }
}

