/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import yalter.mousetweaks.Constants;

public class Config {
    private String fileName;
    private Properties properties = new Properties();

    public Config(String fileName) {
        this.fileName = fileName;
    }

    public boolean readConfig() {
        this.properties.clear();
        try {
            FileReader configReader = new FileReader(this.fileName);
            this.properties.load(configReader);
            configReader.close();
            return this.properties.size() != 0;
        }
        catch (FileNotFoundException configReader) {
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to read the config file: " + this.fileName, (Throwable)e);
        }
        return false;
    }

    public boolean saveConfig() {
        try {
            File config = new File(this.fileName);
            File parentDir = config.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            FileWriter configWriter = new FileWriter(config);
            this.properties.store(configWriter, null);
            configWriter.close();
            return true;
        }
        catch (IOException e) {
            Constants.LOGGER.error("Failed to write the config file: " + this.fileName, (Throwable)e);
            return false;
        }
    }

    public String getOrCreateProperty(String name, String defaultValue) {
        if (this.properties.containsKey(name)) {
            return this.properties.getProperty(name);
        }
        this.properties.setProperty(name, defaultValue);
        return defaultValue;
    }

    public int getOrCreateIntProperty(String name, int defaultValue) {
        return Integer.parseInt(this.getOrCreateProperty(name, String.valueOf(defaultValue)));
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void setIntProperty(String name, int value) {
        this.setProperty(name, String.valueOf(value));
    }
}

