/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.api.recipes.ICarpenterManager;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.forestry.ForestryListAddition;
import modtweaker2.mods.forestry.ForestryListRemoval;
import modtweaker2.mods.forestry.recipes.CarpenterRecipe;
import modtweaker2.mods.forestry.recipes.DescriptiveRecipe;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Carpenter")
public class Carpenter {
    public static final String name = "Forestry Carpenter";

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[][] ingredients, int packagingTime, @Optional IItemStack box) {
        DescriptiveRecipe craftRecipe = new DescriptiveRecipe(3, 3, InputHelper.toShapedObjects(ingredients), InputHelper.toStack(output), false);
        MineTweakerAPI.apply((IUndoableAction)new Add(new CarpenterRecipe(packagingTime, null, InputHelper.toStack(box), craftRecipe)));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[][] ingredients, ILiquidStack fluidInput, int packagingTime, @Optional IItemStack box) {
        DescriptiveRecipe craftRecipe = new DescriptiveRecipe(3, 3, InputHelper.toShapedObjects(ingredients), InputHelper.toStack(output), false);
        MineTweakerAPI.apply((IUndoableAction)new Add(new CarpenterRecipe(packagingTime, InputHelper.toFluid(fluidInput), InputHelper.toStack(box), craftRecipe)));
    }

    @Deprecated
    @ZenMethod
    public static void addRecipe(int packagingTime, ILiquidStack fluidInput, IItemStack[] ingredients, IItemStack box, IItemStack output) {
        DescriptiveRecipe craftRecipe = new DescriptiveRecipe(3, 3, InputHelper.toShapedObjects((IIngredient[][])Carpenter.transform(ingredients, 3)), InputHelper.toStack(output), false);
        MineTweakerAPI.apply((IUndoableAction)new Add(new CarpenterRecipe(packagingTime, InputHelper.toFluid(fluidInput), InputHelper.toStack(box), craftRecipe)));
    }

    private static IItemStack[][] transform(IItemStack[] arr, int N) {
        int M = (arr.length + N - 1) / N;
        IItemStack[][] mat = new IItemStack[M][];
        int start = 0;
        for (int r = 0; r < M; ++r) {
            int L = Math.min(N, arr.length - start);
            mat[r] = Arrays.copyOfRange(arr, start, start + L);
            start += L;
        }
        return mat;
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output, @Optional IIngredient liquid) {
        LinkedList<ICarpenterRecipe> recipes = new LinkedList<ICarpenterRecipe>();
        for (ICarpenterRecipe recipe : RecipeManagers.carpenterManager.recipes()) {
            ItemStack recipeResult;
            if (recipe == null || (recipeResult = recipe.getCraftingGridRecipe().func_77571_b()) == null || !StackHelper.matches(output, InputHelper.toIItemStack(recipeResult))) continue;
            if (liquid != null) {
                if (!StackHelper.matches(liquid, InputHelper.toILiquidStack(recipe.getFluidResource()))) continue;
                recipes.add(recipe);
                continue;
            }
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends ForestryListRemoval<ICarpenterRecipe, ICarpenterManager> {
        public Remove(List<ICarpenterRecipe> recipes) {
            super(Carpenter.name, RecipeManagers.carpenterManager, recipes);
        }

        @Override
        protected String getRecipeInfo(ICarpenterRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getCraftingGridRecipe().func_77571_b());
        }
    }

    private static class Add
    extends ForestryListAddition<ICarpenterRecipe, ICarpenterManager> {
        public Add(ICarpenterRecipe recipe) {
            super(Carpenter.name, RecipeManagers.carpenterManager);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(ICarpenterRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getCraftingGridRecipe().func_77571_b());
        }
    }
}

