/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.crops.prediction;

import ic2.api.crops.CropCard;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.item.ItemStack;
import speiger.src.crops.api.CropPluginAPI;
import speiger.src.crops.prediction.BreedTask;

public class BreedResult
implements Comparable<BreedResult> {
    CropCard result;
    int points;
    int total;
    CropCard[] input;
    int hashCode;
    Set<CropCard> remover;

    public BreedResult(CropCard result, int points, int total, CropCard ... input) {
        this.result = result;
        this.points = points;
        this.total = total;
        this.input = input;
        Arrays.sort(this.input, BreedTask.SORTER);
        this.remover = new LinkedHashSet<CropCard>(Arrays.asList(this.input));
        this.hashCode = Objects.hash(result);
    }

    public CropCard[] getInput() {
        return this.input;
    }

    public int getPoints() {
        return this.points;
    }

    public float getChance() {
        return (float)this.points / (float)this.total * 100.0f;
    }

    public CropCard getResult() {
        return this.result;
    }

    public ItemStack[] getItemInputs() {
        ItemStack[] array = new ItemStack[this.input.length];
        int m = array.length;
        for (int i = 0; i < m; ++i) {
            array[i] = CropPluginAPI.instance.getDisplayItem(this.input[i]);
        }
        return array;
    }

    public ItemStack getItemResult() {
        return CropPluginAPI.instance.getDisplayItem(this.result);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BreedResult) {
            return this.matches((BreedResult)obj);
        }
        return false;
    }

    public boolean matches(BreedResult other) {
        if (other.input.length != this.input.length || this.points != other.points || this.result != other.result) {
            return false;
        }
        ArrayList<CropCard> left = new ArrayList<CropCard>(Arrays.asList(this.input));
        left.removeAll(this.remover);
        return left.size() == 0;
    }

    public void addToMaps(Map<CropCard, List<BreedResult>> craft, Map<CropCard, List<BreedResult>> usage) {
        int m = this.input.length;
        for (int i = 0; i < m; ++i) {
            this.addIfNotPresent(usage.get(this.input[i]));
        }
        this.addIfNotPresent(craft.get(this.result));
    }

    public void addIfNotPresent(List<BreedResult> result) {
        int m = result.size();
        for (int i = 0; i < m; ++i) {
            if (!this.matches(result.get(i))) continue;
            return;
        }
        result.add(this);
    }

    @Override
    public int compareTo(BreedResult o) {
        return Float.compare(o.getChance(), this.getChance());
    }
}

