/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure;

import chylex.hee.system.logging.Stopwatch;
import chylex.hee.world.structure.ComponentScatteredFeatureCustom;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public abstract class ComponentLargeStructureWorld
extends ComponentScatteredFeatureCustom {
    protected final LargeStructureWorld structure;
    private boolean isSetup;
    private int startX;
    private int startZ;
    private int bottomY;

    public ComponentLargeStructureWorld() {
        this.structure = new LargeStructureWorld(null, null);
    }

    public ComponentLargeStructureWorld(World world, Random rand, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        super(rand, x, y, z, sizeX, sizeY, sizeZ);
        this.structure = new LargeStructureWorld(world, this);
        this.startX = x;
        this.startZ = z;
    }

    public final boolean func_74875_a(World world, Random rand, StructureBoundingBox bb) {
        if (!this.isSetup) {
            Stopwatch.time("Structure setup");
            this.bottomY = this.setupStructure(world.func_72912_H().func_76063_b());
            Stopwatch.finish("Structure setup");
            this.isSetup = true;
        }
        int chunkXAmount = this.getSizeX() >> 4;
        for (int chunkX = 0; chunkX < chunkXAmount; ++chunkX) {
            int chunkZAmount = this.getSizeZ() >> 4;
            for (int chunkZ = 0; chunkZ < chunkZAmount; ++chunkZ) {
                this.structure.getChunkFromChunkCoords(chunkX, chunkZ).generateInStructure(this, world, bb, 8, this.bottomY, 8);
            }
        }
        return true;
    }

    protected final int getStartX() {
        return this.startX;
    }

    protected final int getStartZ() {
        return this.startZ;
    }

    protected abstract int setupStructure(long var1);

    @Override
    protected void func_143012_a(NBTTagCompound nbt) {
        super.func_143012_a(nbt);
        nbt.func_74768_a("startX", this.startX);
        nbt.func_74768_a("startZ", this.startZ);
        nbt.func_74774_a("bottomY", (byte)this.bottomY);
        nbt.func_74782_a("structure", (NBTBase)this.structure.saveToNBT());
    }

    @Override
    protected void func_143011_b(NBTTagCompound nbt) {
        super.func_143011_b(nbt);
        this.startX = nbt.func_74762_e("startX");
        this.startZ = nbt.func_74762_e("startZ");
        this.bottomY = nbt.func_74771_c("bottomY");
        this.structure.loadFromNBT(nbt.func_74775_l("structure"));
    }
}

