/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.populators;

import chylex.hee.world.feature.blobs.BlobPopulator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.util.IRandomAmount;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;

public class BlobPopulatorOreCluster
extends BlobPopulator {
    private Block ore;
    private IRandomAmount iterationAmountGen = IRandomAmount.exact;
    private IRandomAmount blockAmountGen = IRandomAmount.exact;
    private byte minAttempts;
    private byte maxAttempts;
    private byte minIterationAmount;
    private byte maxIterationAmount;
    private byte minBlockAmount;
    private byte maxBlockAmount;

    public BlobPopulatorOreCluster(int weight) {
        super(weight);
    }

    public BlobPopulatorOreCluster block(Block ore) {
        this.ore = ore;
        return this;
    }

    public BlobPopulatorOreCluster iterationAmount(IRandomAmount iterationAmountGen, int minIterationAmount, int maxIterationAmount) {
        this.iterationAmountGen = iterationAmountGen;
        this.minIterationAmount = (byte)minIterationAmount;
        this.maxIterationAmount = (byte)maxIterationAmount;
        return this;
    }

    public BlobPopulatorOreCluster blockAmount(IRandomAmount blockAmountGen, int minBlockAmount, int maxBlockAmount) {
        this.blockAmountGen = blockAmountGen;
        this.minBlockAmount = (byte)minBlockAmount;
        this.maxBlockAmount = (byte)maxBlockAmount;
        return this;
    }

    public BlobPopulatorOreCluster attempts(int minAttempts, int maxAttempts) {
        this.minAttempts = (byte)minAttempts;
        this.maxAttempts = (byte)maxAttempts;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        int iterations = this.iterationAmountGen.generate(rand, this.minIterationAmount, this.maxIterationAmount);
        block0: for (int iteration = 0; iteration < iterations; ++iteration) {
            boolean succeeded = false;
            int blockAmount = this.blockAmountGen.generate(rand, this.minBlockAmount, this.maxBlockAmount);
            int attempts = this.minAttempts + rand.nextInt(this.maxAttempts - this.minAttempts + 1);
            for (int attempt = 0; attempt < attempts; ++attempt) {
                int x = rand.nextInt(32) - 16;
                int y = rand.nextInt(32) - 16;
                int z = rand.nextInt(32) - 16;
                float randomAngle = rand.nextFloat() * (float)Math.PI;
                double genX1 = (float)x + MathHelper.func_76126_a((float)randomAngle) * (float)blockAmount * 0.125f;
                double genX2 = (float)x - MathHelper.func_76126_a((float)randomAngle) * (float)blockAmount * 0.125f;
                double genY1 = (float)z + MathHelper.func_76134_b((float)randomAngle) * (float)blockAmount * 0.125f;
                double genY2 = (float)z - MathHelper.func_76134_b((float)randomAngle) * (float)blockAmount * 0.125f;
                double genZ1 = y + rand.nextInt(4) - 2;
                double genZ2 = y + rand.nextInt(4) - 2;
                for (int a = 0; a <= blockAmount; ++a) {
                    double centerX = genX1 + (genX2 - genX1) * (double)a / (double)blockAmount;
                    double centerY = genZ1 + (genZ2 - genZ1) * (double)a / (double)blockAmount;
                    double centerZ = genY1 + (genY2 - genY1) * (double)a / (double)blockAmount;
                    double maxDist = rand.nextDouble() * (double)blockAmount * 0.0625;
                    double area = (double)(MathHelper.func_76126_a((float)((float)a * (float)Math.PI / (float)blockAmount)) + 1.0f) * maxDist + 1.0;
                    int minX = MathHelper.func_76128_c((double)(centerX - area * 0.5));
                    int minY = MathHelper.func_76128_c((double)(centerY - area * 0.5));
                    int minZ = MathHelper.func_76128_c((double)(centerZ - area * 0.5));
                    int maxX = MathHelper.func_76128_c((double)(centerX + area * 0.5));
                    int maxY = MathHelper.func_76128_c((double)(centerY + area * 0.5));
                    int maxZ = MathHelper.func_76128_c((double)(centerZ + area * 0.5));
                    for (int xx = minX; xx <= maxX; ++xx) {
                        double d12 = ((double)xx + 0.5 - centerX) / (area * 0.5);
                        if (!(d12 * d12 < 1.0)) continue;
                        for (int yy = minY; yy <= maxY; ++yy) {
                            double d13 = ((double)yy + 0.5 - centerY) / (area * 0.5);
                            if (!(d12 * d12 + d13 * d13 < 1.0)) continue;
                            for (int zz = minZ; zz <= maxZ; ++zz) {
                                double d14 = ((double)zz + 0.5 - centerZ) / (area * 0.5);
                                if (d12 * d12 + d13 * d13 + d14 * d14 >= 1.0 || gen.getBlock(xx, yy, zz) != Blocks.field_150377_bs) continue;
                                gen.setBlock(xx, yy, zz, this.ore);
                                succeeded = true;
                            }
                        }
                    }
                }
                if (succeeded) continue block0;
            }
        }
    }
}

