/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.item;

import chylex.hee.init.BlockList;
import chylex.hee.mechanics.causatum.CausatumMeters;
import chylex.hee.mechanics.causatum.CausatumUtils;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.ItemUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityEnergyCluster;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemEnergyWand
extends Item {
    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && !world.field_72995_K) {
            if (ItemUtil.getTagRoot(is, false).func_74764_b("cluster")) {
                BlockPosM tmpPos = BlockPosM.tmp(x, y, z);
                if (side > 0) {
                    tmpPos.move(side);
                }
                if (!player.func_82247_a(tmpPos.x, tmpPos.y, tmpPos.z, side, is) || !tmpPos.isAir(world)) {
                    return false;
                }
                tmpPos.setBlock(world, BlockList.energy_cluster);
                TileEntityEnergyCluster tile = (TileEntityEnergyCluster)tmpPos.getTileEntity((IBlockAccess)world);
                if (tile != null) {
                    double dist;
                    NBTTagCompound tag = ItemUtil.getTagSub(is, "cluster", true);
                    tag.func_74772_a("loc", tmpPos.toLong());
                    tile.readTileFromNBT(tag);
                    BlockPosM prevLoc = BlockPosM.fromNBT(ItemUtil.getTagRoot(is, false), "prevLoc");
                    double d = dist = ItemUtil.getTagRoot(is, false).func_74765_d("prevDim") == world.field_73011_w.field_76574_g ? MathUtil.distance(prevLoc.x - tmpPos.x, prevLoc.y - tmpPos.y, prevLoc.z - tmpPos.z) : Double.MAX_VALUE;
                    if (dist > 8.0) {
                        tile.data.setEnergyLevel(tile.data.getEnergyLevel() * (1.0f - 0.5f * Math.min(1.0f, (float)dist / 256.0f)));
                        if (field_77697_d.nextInt(100) < tile.data.getHealthStatus().chanceToWeaken) {
                            tile.data.weakenCluster();
                        }
                    }
                    tile.synchronize();
                }
                ItemUtil.getTagRoot(is, false).func_82580_o("cluster");
                return true;
            }
            if (BlockPosM.tmp(x, y, z).getBlock((IBlockAccess)world) == BlockList.energy_cluster) {
                TileEntityEnergyCluster tile = (TileEntityEnergyCluster)BlockPosM.tmp(x, y, z).getTileEntity((IBlockAccess)world);
                if (tile != null) {
                    tile.shouldNotExplode = true;
                    if (!world.field_72995_K) {
                        CausatumUtils.increase(player, CausatumMeters.END_ENERGY, tile.data.getEnergyLevel() * 0.5f);
                        NBTTagCompound tag = tile.writeTileToNBT(new NBTTagCompound());
                        tag.func_74772_a("loc", BlockPosM.tmp(0, -1, 0).toLong());
                        NBTTagCompound itemNbt = ItemUtil.getTagRoot(is, true);
                        itemNbt.func_74782_a("cluster", (NBTBase)tag);
                        itemNbt.func_74772_a("prevLoc", BlockPosM.tmp(x, y, z).toLong());
                        itemNbt.func_74777_a("prevDim", (short)world.field_73011_w.field_76574_g);
                        BlockPosM.tmp(x, y, z).setAir(world);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void func_77622_d(ItemStack is, World world, EntityPlayer player) {
        player.func_71064_a((StatBase)AchievementManager.ENERGY_WAND, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer player, List textLines, boolean showAdvancedInfo) {
        if (ItemUtil.getTagRoot(is, false).func_74764_b("cluster")) {
            textLines.add(I18n.func_135052_a((String)"item.energyWand.info.holding", (Object[])new Object[0]).replace("$", DragonUtil.formatTwoPlaces.format(ItemUtil.getTagSub(is, "cluster", false).func_74760_g("lvl"))));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack is, int pass) {
        return ItemUtil.getTagRoot(is, false).func_74764_b("cluster");
    }
}

