/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.item.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import galaxyspace.core.item.electric.ItemElectricArmor;
import galaxyspace.core.model.item.ModelJetPack;
import galaxyspace.core.proxy.CommonProxy;
import galaxyspace.core.register.GSItems;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemJetPack
extends ItemElectricArmor {
    public float transferMax;
    private World world;
    private Random rand;
    private EntityLivingBase entity;
    private Vector3 motionVec;
    private static boolean lastJetpackUsed = false;
    public boolean active;

    public ItemJetPack(int armorIndex) {
        super(GSItems.JETPACK, GalaxySpace.proxy.getJetpackArmorRenderIndex(), armorIndex);
        this.func_77655_b("JetPack");
        this.func_111206_d("galaxyspace:jetpack");
    }

    public CreativeTabs func_77640_w() {
        return GalaxySpace.tabArmor;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (this.func_82812_d() == GSItems.JETPACK) {
            return "galaxyspace:textures/model/armor/jetpack.png";
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this == GSItems.JetPack) {
            ModelJetPack model = new ModelJetPack();
            return model;
        }
        return null;
    }

    public void use(ItemStack itemStack, double amount) {
        this.drainfromJetpack(itemStack, (int)amount);
        this.discharge(itemStack, 5.0f, true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean useJetpack(EntityPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack jetpack = player.field_71071_by.field_70460_b[2];
        if ((double)this.getElectricityStored(jetpack) <= 0.0) {
            return false;
        }
        boolean electric = jetpack.func_77973_b() != GSItems.JetPack;
        float power = 1.0f;
        float dropPercentage = 0.2f;
        if (electric) {
            power = 0.7f;
            dropPercentage = 0.05f;
        }
        if ((double)this.getElectricityStored(jetpack) / this.getMaxCharge(jetpack) <= (double)dropPercentage) {
            power *= (float)((double)this.getElectricityStored(jetpack) / (this.getMaxCharge(jetpack) * (double)dropPercentage));
        }
        if (mc.field_71474_y.field_74351_w.func_151470_d() && mc.field_71462_r == null) {
            float maxFlightHeight;
            float worldHeight = 0.15f;
            if (electric) {
                worldHeight += 0.15f;
            }
            if ((maxFlightHeight = power * worldHeight * 2.0f) > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * maxFlightHeight, 0.02f);
            }
        }
        CommonProxy proxy = GalaxySpace.proxy;
        int worldHeight2 = CommonProxy.getWorldHeight(player.field_70170_p);
        double y = player.field_70163_u;
        int maxFlightHeight2 = electric ? (int)((float)worldHeight2 / 1.28f) : worldHeight2;
        if (y > (double)(maxFlightHeight2 - 25)) {
            if (y > (double)maxFlightHeight2) {
                y = maxFlightHeight2;
            }
            power *= (float)(((double)maxFlightHeight2 - y) / 25.0);
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (electric) {
            float consume = 0.0f;
            if (mc.field_71474_y.field_74314_A.func_151470_d() && mc.field_71462_r == null) {
                consume = electric ? 0.1f : 0.2f;
            }
            if (mc.field_71474_y.field_74311_E.func_151470_d() && mc.field_71462_r == null) {
                consume = electric ? -0.1f : -0.2f;
            }
            if (player.field_70181_x > (double)consume) {
                player.field_70181_x = consume;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        int consume2 = 2;
        if (electric) {
            consume2 += 6;
        }
        this.use(jetpack, consume2);
        player.field_70143_R = 1.0E-10f;
        player.field_70140_Q = 0.6f;
        GalaxySpace.proxy.resetPlayerInAirTime(player);
        return true;
    }

    public boolean drainfromJetpack(ItemStack pack, int amount) {
        return !ItemElectricArmor.isElectricItemEmpty(pack);
    }

    @SideOnly(value=Side.CLIENT)
    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        Minecraft mc = Minecraft.func_71410_x();
        if (player.field_71071_by.field_70460_b[2] == itemStack) {
            boolean toggleTimer = false;
            boolean jetpackUsed = false;
            boolean x = false;
            boolean y = false;
            boolean z = false;
            if (mc.field_71474_y.field_74314_A.func_151470_d() && mc.field_71462_r == null) {
                jetpackUsed = this.useJetpack(player);
            }
            if (jetpackUsed) {
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    public static double map(double value, double srcMax, double dstMax) {
        if (value < 0.0 || Double.isNaN(value)) {
            value = 0.0;
        }
        if (value > srcMax) {
            value = srcMax;
        }
        return value / srcMax * dstMax;
    }

    public void setActive() {
        this.active = true;
    }

    @Override
    public float getMaxElectricityStored(ItemStack theItem) {
        return 100000.0f;
    }
}

