/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.handler;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.BarnardsSystem.BRFluids;
import galaxyspace.BarnardsSystem.BRItems;
import galaxyspace.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiper;
import galaxyspace.SolarSystem.planets.mercury.dimension.WorldProviderMercury;
import galaxyspace.TCetiSystem.planets.tcetiE.dimension.WorldProviderTCetiE;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.entity.mob.EntityEvolvedEnderman;
import galaxyspace.core.gui.GSGuiMainMenu;
import galaxyspace.core.handler.GSSpaceSuitHandler;
import galaxyspace.core.handler.api.DamageSourceGS;
import galaxyspace.core.handler.api.IHostileBody;
import galaxyspace.core.handler.api.ILightningStorm;
import galaxyspace.core.register.GSFluids;
import galaxyspace.core.register.GSItems;
import galaxyspace.core.register.GSPotions;
import java.util.Calendar;
import micdoodle8.mods.galacticraft.api.inventory.AccessInventoryGC;
import micdoodle8.mods.galacticraft.api.inventory.IInventoryGC;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.world.BlockEvent;

public class GSEventHandler {
    private boolean message = false;

    @SubscribeEvent
    public void joinWorldEvent(EntityJoinWorldEvent event) {
        if (!this.message) {
            this.message = true;
            if (!event.world.field_72995_K && event.entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.entity;
                Calendar calendar = Calendar.getInstance();
                String star = EnumColor.RED + "*" + EnumColor.DARK_GREEN + "*";
                if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 20 && calendar.get(5) <= 31 || calendar.get(2) + 1 == 1 && calendar.get(5) >= 1 && calendar.get(5) <= 14) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(star + star + star + star + star + star + " [Galaxy Space] " + star + star + star + star + star + star));
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumColor.AQUA + GCCoreUtil.translate((String)"gui.holiday1.desc")));
                    if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 20 && calendar.get(5) <= 31) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumColor.AQUA + GCCoreUtil.translate((String)"gui.holiday2_1.desc")));
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumColor.AQUA + GCCoreUtil.translate((String)"gui.holiday3_1_1.desc")));
                    }
                    if (calendar.get(2) + 1 == 1 && calendar.get(5) >= 1 && calendar.get(5) <= 14) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumColor.AQUA + GCCoreUtil.translate((String)"gui.holiday2_2.desc")));
                        player.func_145747_a((IChatComponent)new ChatComponentText(EnumColor.AQUA + GCCoreUtil.translate((String)"gui.holiday3_2_1.desc")));
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumColor.AQUA + GCCoreUtil.translate((String)"gui.holiday4.desc")));
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumColor.AQUA + GCCoreUtil.translate((String)"gui.holiday5.desc")));
                    player.func_145747_a((IChatComponent)new ChatComponentText(star + star + star + star + star + star + star + star + star + star + star + star + star + star + star + star + star + star + star + star));
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (event.gui instanceof GuiMainMenu && GSConfigCore.enableNewMenu) {
            event.gui = new GSGuiMainMenu();
        }
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        World world = event.world;
        MovingObjectPosition pos = event.target;
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        int meta = world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        if (block == GSFluids.BlockLiquidMethane && meta == 0) {
            world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            event.result = new ItemStack(GSItems.MethaneBucket, 1, 0);
            event.setResult(Event.Result.ALLOW);
        }
        if (block == BRFluids.BlockUnknowWater && meta == 0) {
            world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            event.result = new ItemStack(BRItems.UnknowWaterBucket, 1, 0);
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onThermalArmorEvent(GCPlayerHandler.ThermalArmorEvent event) {
        if (event.armorStack == null) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.REMOVE);
            return;
        }
        if (event.armorStack.func_77973_b() == AsteroidsItems.thermalPadding && event.armorStack.func_77960_j() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        if (event.armorStack.func_77973_b() == GSItems.ThermalPaddingTier2 && event.armorStack.func_77960_j() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        if (event.armorStack.func_77973_b() == GSItems.ThermalPaddingTier2 && event.armorStack.func_77960_j() == 4) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.NOTHING);
    }

    @SubscribeEvent
    public void blockPlace(BlockEvent.PlaceEvent event) {
        if (event.world.field_73011_w instanceof WorldProviderMoon && event.world.func_147439_a(event.x, event.y, event.z).func_149688_o() == Material.field_151586_h) {
            event.world.func_147449_b(event.x, event.y, event.z, Blocks.field_150432_aD);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.entityLiving;
        World world = living.field_70170_p;
        if (living instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)living;
            if (world.field_73011_w instanceof ILightningStorm) {
                this.spawnLightningBolt(world, player);
            }
            if (GSEventHandler.getTier2ThermalArmor(player) || world.field_73011_w instanceof WorldProviderMercury && player.field_70163_u <= 30.0) {
                player.func_82170_o(GSPotions.radiation.field_76415_H);
            }
            if (world.field_73011_w instanceof WorldProviderKuiper && player.field_70163_u <= -20.0) {
                player.field_70163_u = 180.0;
            }
            if (player.field_70170_p.field_73011_w instanceof IHostileBody) {
                IHostileBody provider = (IHostileBody)player.field_70170_p.field_73011_w;
                int level = provider.AtmosphericPressure();
                if (!player.field_71075_bZ.field_75098_d) {
                    int numberOfMissingArmor = 0;
                    if (!GSSpaceSuitHandler.isValidHelmet(player.func_82169_q(3))) {
                        ++numberOfMissingArmor;
                    }
                    if (!GSSpaceSuitHandler.isValidChestPlate(player.func_82169_q(2))) {
                        ++numberOfMissingArmor;
                    }
                    if (!GSSpaceSuitHandler.isValidLeggings(player.func_82169_q(1))) {
                        ++numberOfMissingArmor;
                    }
                    if (!GSSpaceSuitHandler.isValidBoots(player.func_82169_q(0))) {
                        ++numberOfMissingArmor;
                    }
                    for (int i = 0; i < numberOfMissingArmor; ++i) {
                        if (level > 15) {
                            player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 10));
                        }
                        if (level > 20) {
                            player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 280));
                        }
                        if (level > 30) {
                            player.func_70097_a(DamageSourceGS.atmosphericPressure, 1.0f);
                        }
                        if (level > 40) {
                            player.func_70097_a(DamageSourceGS.atmosphericPressure, 10.0f);
                        }
                        if (level > 50) {
                            player.func_70097_a(DamageSourceGS.atmosphericPressure, 100.0f);
                        }
                        if (level <= 60) continue;
                        player.func_70097_a(DamageSourceGS.atmosphericPressure, 1000.0f);
                    }
                }
            }
            ItemStack stack2 = player.func_82169_q(3);
            IInventoryGC inv = AccessInventoryGC.getGCInventoryForPlayer((EntityPlayerMP)player);
            if (stack2 != null && (stack2.func_77973_b() == GSItems.SpacesuitHelmet || stack2.func_77973_b() == GSItems.SpacesuitHelmetGlasses) && player.func_70090_H()) {
                int air;
                if (inv.func_70301_a(2) != null) {
                    if (inv.func_70301_a(2).func_77960_j() != inv.func_70301_a(2).func_77958_k() && (air = player.func_70086_ai()) < 200) {
                        player.func_70050_g(air + 200);
                        inv.func_70301_a(2).func_77964_b(inv.func_70301_a(2).func_77960_j() + 1);
                    }
                } else if (inv.func_70301_a(2) == null && inv.func_70301_a(3) != null && inv.func_70301_a(3).func_77960_j() != inv.func_70301_a(3).func_77958_k() && (air = player.func_70086_ai()) < 200) {
                    player.func_70050_g(air + 200);
                    inv.func_70301_a(3).func_77964_b(inv.func_70301_a(3).func_77960_j() + 1);
                }
                if (inv.func_70301_a(2) != null && inv.func_70301_a(3) != null && inv.func_70301_a(2).func_77960_j() == inv.func_70301_a(2).func_77958_k() && inv.func_70301_a(3).func_77960_j() != inv.func_70301_a(3).func_77958_k() && (air = player.func_70086_ai()) < 200) {
                    player.func_70050_g(air + 200);
                    inv.func_70301_a(3).func_77964_b(inv.func_70301_a(3).func_77960_j() + 1);
                }
            }
            this.doRadiatoinForEntity(world, living);
        }
        if (living instanceof EntityPlayer && living.field_70170_p.field_73011_w instanceof WorldProviderTCetiE && living.func_70090_H()) {
            this.applyReverseWaterMovement(living);
        }
    }

    public static boolean getTier2ThermalArmor(EntityPlayerMP player) {
        IInventoryGC inv = AccessInventoryGC.getGCInventoryForPlayer((EntityPlayerMP)player);
        boolean armor1 = inv.func_70301_a(6) != null && inv.func_70301_a(6).func_77973_b() == GSItems.ThermalPaddingTier2 && inv.func_70301_a(6).func_77960_j() == 0;
        boolean armor2 = inv.func_70301_a(7) != null && inv.func_70301_a(7).func_77973_b() == GSItems.ThermalPaddingTier2 && inv.func_70301_a(7).func_77960_j() == 1;
        boolean armor3 = inv.func_70301_a(8) != null && inv.func_70301_a(8).func_77973_b() == GSItems.ThermalPaddingTier2 && inv.func_70301_a(8).func_77960_j() == 2;
        boolean armor4 = inv.func_70301_a(9) != null && inv.func_70301_a(9).func_77973_b() == GSItems.ThermalPaddingTier2 && inv.func_70301_a(9).func_77960_j() == 3;
        boolean armor5 = inv.func_70301_a(9) != null && inv.func_70301_a(9).func_77973_b() == GSItems.ThermalPaddingTier2 && inv.func_70301_a(9).func_77960_j() == 4;
        return armor1 && armor2 && armor3 && armor4 || armor1 && armor2 && armor3 && armor5;
    }

    private void doRadiatoinForEntity(World world, EntityLivingBase living) {
        EntityPlayerMP player = (EntityPlayerMP)living;
        if (world.field_73011_w instanceof IHostileBody && living.field_70163_u <= 1000.0 && ((IHostileBody)world.field_73011_w).SolarRadiation()) {
            if (!(living instanceof EntityPlayer)) {
                if (living.field_70173_aa % 100 == 0 && !(living instanceof IEntityLivingData) && living.getClass() != EntityEvolvedZombie.class && living.getClass() != EntityEvolvedSpider.class && living.getClass() != EntityEvolvedSkeleton.class && living.getClass() != EntityEvolvedCreeper.class && living.getClass() != EntityEvolvedEnderman.class) {
                    living.func_70690_d(new PotionEffect(GSPotions.radiation.field_76415_H, 80));
                }
            } else if (living instanceof EntityPlayerMP) {
                if (!(player.field_70173_aa % 20 != 0 || player.field_71075_bZ.field_75098_d || GSEventHandler.getTier2ThermalArmor(player) || OxygenUtil.inOxygenBubble((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v) || OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player))) {
                    player.func_70690_d(new PotionEffect(GSPotions.radiation.field_76415_H, 80));
                } else if (GSEventHandler.getTier2ThermalArmor(player) || OxygenUtil.inOxygenBubble((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v) || OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player)) {
                    player.func_82170_o(GSPotions.radiation.field_76415_H);
                }
            }
        }
    }

    private void spawnLightningBolt(World world, EntityPlayerMP player) {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.CLIENT && ((ILightningStorm)world.field_73011_w).getLightningStormFrequency() > 0.0) {
            EntityLightningBolt lightning;
            double z;
            double y;
            double x;
            EntityPlayer closestPlayer;
            int f = (int)(((ILightningStorm)world.field_73011_w).getLightningStormFrequency() * 1000.0);
            if (world.field_73012_v.nextInt(f) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                x = player.field_70165_t + (double)world.field_73012_v.nextInt(25) - 5.0;
                y = player.field_70163_u + (double)world.field_73012_v.nextInt(10);
                z = player.field_70161_v + (double)world.field_73012_v.nextInt(25) - 5.0;
                lightning = new EntityLightningBolt(world, x, y, z);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)lightning);
                }
            }
            if (world.field_73012_v.nextInt(f * 3) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                x = player.field_70165_t + (double)world.field_73012_v.nextInt(25) - 5.0;
                y = player.field_70163_u + (double)world.field_73012_v.nextInt(10);
                z = player.field_70161_v + (double)world.field_73012_v.nextInt(25) - 5.0;
                lightning = new EntityLightningBolt(world, x, y, z);
                if (!world.field_72995_K) {
                    for (int i = 0; i < 3; ++i) {
                        world.func_72838_d((Entity)lightning);
                    }
                }
            }
        }
    }

    private void applyReverseWaterMovement(EntityLivingBase entity) {
        int j2;
        AxisAlignedBB par1AxisAlignedBB = entity.field_70121_D.func_72314_b(0.0, (double)-0.4f, 0.0).func_72331_e(0.001, 0.001, 0.001);
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i2 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        if (!entity.field_70170_p.func_72904_c(i, k, i2, j, l, j2 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0)))) {
            return;
        }
        Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (int k2 = i; k2 < j; ++k2) {
            for (int l2 = k; l2 < l; ++l2) {
                for (int i3 = i2; i3 < j2; ++i3) {
                    double d0;
                    Block block = entity.field_70170_p.func_147439_a(k2, l2, i3);
                    if (block == null || block.func_149688_o() != Material.field_151586_h || !((double)l >= (d0 = (double)((float)(l2 + 1) - BlockLiquid.func_149801_b((int)entity.field_70170_p.func_72805_g(k2, l2, i3)))))) continue;
                    block.func_149640_a(entity.field_70170_p, k2, l2, i3, (Entity)entity, vec3);
                }
            }
        }
        if (vec3.func_72433_c() > 0.0 && entity.func_70090_H()) {
            vec3 = vec3.func_72432_b();
            double d2 = -0.014;
            entity.field_70159_w += vec3.field_72450_a * -0.014;
            entity.field_70181_x += vec3.field_72448_b * -0.014;
            entity.field_70179_y += vec3.field_72449_c * -0.014;
        }
    }
}

