/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.pluto.dimension;

import galaxyspace.SolarSystem.planets.pluto.world.BiomeGenBasePluto;
import galaxyspace.SolarSystem.planets.pluto.world.layer.GenLayerPluto;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldChunkManagerSpace;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class WorldChunkManagerPluto
extends WorldChunkManagerSpace {
    private GenLayer unzoomedBiomes;
    private GenLayer zoomedBiomes;
    private BiomeCache myBiomeCache = new BiomeCache((WorldChunkManager)this);
    private List<BiomeGenBase> myBiomesToSpawnIn = new ArrayList<BiomeGenBase>();

    protected WorldChunkManagerPluto() {
        this.myBiomesToSpawnIn.add(this.getBiome());
        this.myBiomesToSpawnIn.add(BiomeGenBasePluto.Pluto2);
        this.myBiomesToSpawnIn.add(BiomeGenBasePluto.Pluto3);
        this.myBiomesToSpawnIn.add(BiomeGenBasePluto.Pluto4);
    }

    public WorldChunkManagerPluto(long seed) {
        this();
        GenLayer[] agenlayer = GenLayerPluto.makeTheWorld(seed);
        this.unzoomedBiomes = agenlayer[0];
        this.zoomedBiomes = agenlayer[1];
    }

    public WorldChunkManagerPluto(World world) {
        this(world.func_72905_C());
    }

    public BiomeGenBase getBiome() {
        return BiomeGenBasePluto.Pluto;
    }

    public List func_76932_a() {
        return this.myBiomesToSpawnIn;
    }

    public BiomeGenBase func_76935_a(int par1, int par2) {
        BiomeGenBase biome = this.myBiomeCache.func_76837_b(par1, par2);
        if (biome == null) {
            return this.getBiome();
        }
        return biome;
    }

    public float[] func_76936_a(float[] par1, int x, int z, int width, int depth) {
        IntCache.func_76446_a();
        int[] aint = this.zoomedBiomes.func_75904_a(x, z, width, depth);
        if (par1 == null || par1.length < width * depth) {
            par1 = new float[width * depth];
        }
        for (int i1 = 0; i1 < width * depth; ++i1) {
            float f = (float)BiomeGenBase.func_150568_d((int)aint[i1]).func_76744_g() / 65536.0f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            par1[i1] = f;
        }
        return par1;
    }

    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int x, int z, int length, int width) {
        int[] arrayOfInts = this.unzoomedBiomes.func_75904_a(x, z, length, width);
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < length * width) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[length * width];
        }
        for (int i = 0; i < length * width; ++i) {
            par1ArrayOfBiomeGenBase[i] = arrayOfInts[i] >= 0 ? BiomeGenBase.func_150568_d((int)arrayOfInts[i]) : this.getBiome();
        }
        return par1ArrayOfBiomeGenBase;
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] par1ArrayOfBiomeGenBase, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiomeGenBase, par2, par3, par4, par5, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] par1ArrayOfBiomeGenBase, int x, int y, int width, int length, boolean cacheFlag) {
        int[] ai = this.zoomedBiomes.func_75904_a(x, y, width, length);
        if (par1ArrayOfBiomeGenBase == null || par1ArrayOfBiomeGenBase.length < width * length) {
            par1ArrayOfBiomeGenBase = new BiomeGenBase[width * length];
        }
        if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (y & 0xF) == 0) {
            BiomeGenBase[] abiomegenbase = this.myBiomeCache.func_76839_e(x, y);
            System.arraycopy(abiomegenbase, 0, par1ArrayOfBiomeGenBase, 0, width * length);
            return par1ArrayOfBiomeGenBase;
        }
        for (int i = 0; i < width * length; ++i) {
            par1ArrayOfBiomeGenBase[i] = ai[i] >= 0 ? BiomeGenBase.func_150568_d((int)ai[i]) : this.getBiome();
        }
        return par1ArrayOfBiomeGenBase;
    }

    public boolean func_76940_a(int par1, int par2, int par3, List par4List) {
        int i = par1 - par3 >> 2;
        int j = par2 - par3 >> 2;
        int k = par1 + par3 >> 2;
        int l = par2 + par3 >> 2;
        int i2 = k - i + 1;
        int j2 = l - j + 1;
        int[] ai = this.unzoomedBiomes.func_75904_a(i, j, i2, j2);
        for (int k2 = 0; k2 < i2 * j2; ++k2) {
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)ai[k2]);
            if (par4List.contains(biomegenbase)) continue;
            return false;
        }
        return true;
    }

    public ChunkPosition func_150795_a(int par1, int par2, int par3, List par4List, Random par5Random) {
        int i = par1 - par3 >> 2;
        int j = par2 - par3 >> 2;
        int k = par1 + par3 >> 2;
        int l = par2 + par3 >> 2;
        int i2 = k - i + 1;
        int j2 = l - j + 1;
        int[] ai = this.unzoomedBiomes.func_75904_a(i, j, i2, j2);
        ChunkPosition chunkposition = null;
        int k2 = 0;
        for (int l2 = 0; l2 < ai.length; ++l2) {
            int i3 = i + l2 % i2 << 2;
            int j3 = j + l2 / i2 << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)ai[l2]);
            if (!par4List.contains(biomegenbase) || chunkposition != null && par5Random.nextInt(k2 + 1) != 0) continue;
            chunkposition = new ChunkPosition(i3, 0, j3);
            ++k2;
        }
        return chunkposition;
    }

    public void func_76938_b() {
        this.myBiomeCache.func_76838_a();
    }
}

