/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockLandingPadFull;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import micdoodle8.mods.galacticraft.core.world.IChunkLoader;
import micdoodle8.mods.galacticraft.planets.mars.ConfigManagerMars;
import micdoodle8.mods.galacticraft.planets.mars.network.PacketSimpleMars;
import net.minecraft.block.Block;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public class TileEntityLaunchController
extends TileBaseElectricBlockWithInventory
implements IChunkLoader,
ISidedInventory,
ILandingPadAttachable {
    public static final int WATTS_PER_TICK = 1;
    private ItemStack[] containingItems = new ItemStack[1];
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean launchPadRemovalDisabled = true;
    private ForgeChunkManager.Ticket chunkLoadTicket;
    private final List<ChunkCoordinates> connectedPads = new ArrayList<ChunkCoordinates>();
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int frequency = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int destFrequency = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String ownerName = "";
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean frequencyValid;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean destFrequencyValid;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int launchDropdownSelection;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean launchSchedulingEnabled;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean controlEnabled;
    public boolean hideTargetDestination = true;
    public boolean requiresClientUpdate;
    public Object attachedDock = null;
    private boolean frequencyCheckNeeded = false;

    public TileEntityLaunchController() {
        this.storage.setMaxExtract(10.0f);
        this.noRedstoneControl = true;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean bl = this.controlEnabled = this.launchSchedulingEnabled && this.hasEnoughEnergyToRun && !this.getDisabled(0);
            if (this.frequencyCheckNeeded) {
                this.checkDestFrequencyValid();
                this.frequencyCheckNeeded = false;
            }
            if (this.requiresClientUpdate) {
                this.requiresClientUpdate = false;
            }
            if (this.ticks % 40 == 0) {
                this.setFrequency(this.frequency);
                this.setDestinationFrequency(this.destFrequency);
            }
            if (this.ticks % 20 == 0 && this.chunkLoadTicket != null) {
                for (int i = 0; i < this.connectedPads.size(); ++i) {
                    ChunkCoordinates coords = this.connectedPads.get(i);
                    Block block = this.field_145850_b.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                    if (block == GCBlocks.landingPadFull) continue;
                    this.connectedPads.remove(i);
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkLoadTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(coords.field_71574_a >> 4, coords.field_71573_c >> 4));
                }
            }
        } else if (this.frequency == -1 && this.destFrequency == -1) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimpleMars(PacketSimpleMars.EnumSimplePacketMars.S_UPDATE_ADVANCED_GUI, new Object[]{5, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0}));
        }
    }

    @Override
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.chunkLoadTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkLoadTicket);
        }
    }

    @Override
    public void onTicketLoaded(ForgeChunkManager.Ticket ticket, boolean placed) {
        if (!this.field_145850_b.field_72995_K && ConfigManagerMars.launchControllerChunkLoad) {
            if (ticket == null) {
                return;
            }
            if (this.chunkLoadTicket == null) {
                this.chunkLoadTicket = ticket;
            }
            NBTTagCompound nbt = this.chunkLoadTicket.getModData();
            nbt.func_74768_a("ChunkLoaderTileX", this.field_145851_c);
            nbt.func_74768_a("ChunkLoaderTileY", this.field_145848_d);
            nbt.func_74768_a("ChunkLoaderTileZ", this.field_145849_e);
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    Block blockID = this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z);
                    if (!(blockID instanceof BlockLandingPadFull) || this.field_145851_c + x >> 4 == this.field_145851_c >> 4 && this.field_145849_e + z >> 4 == this.field_145849_e >> 4) continue;
                    this.connectedPads.add(new ChunkCoordinates(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z));
                    if (placed) {
                        ChunkLoadingCallback.forceChunk(this.chunkLoadTicket, this.field_145850_b, this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z, this.getOwnerName());
                        continue;
                    }
                    ChunkLoadingCallback.addToList(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getOwnerName());
                }
            }
            ChunkLoadingCallback.forceChunk(this.chunkLoadTicket, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getOwnerName());
        }
    }

    @Override
    public ForgeChunkManager.Ticket getTicket() {
        return this.chunkLoadTicket;
    }

    @Override
    public ChunkCoordinates getCoords() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.containingItems = this.readStandardItemsFromNBT(nbt);
        this.ownerName = nbt.func_74779_i("OwnerName");
        this.launchDropdownSelection = nbt.func_74762_e("LaunchSelection");
        this.frequency = nbt.func_74762_e("ControllerFrequency");
        this.destFrequency = nbt.func_74762_e("TargetFrequency");
        this.frequencyCheckNeeded = true;
        this.launchPadRemovalDisabled = nbt.func_74767_n("LaunchPadRemovalDisabled");
        this.launchSchedulingEnabled = nbt.func_74767_n("LaunchPadSchedulingEnabled");
        this.hideTargetDestination = nbt.func_74767_n("HideTargetDestination");
        this.requiresClientUpdate = true;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeStandardItemsToNBT(nbt);
        nbt.func_74778_a("OwnerName", this.ownerName);
        nbt.func_74768_a("LaunchSelection", this.launchDropdownSelection);
        nbt.func_74768_a("ControllerFrequency", this.frequency);
        nbt.func_74768_a("TargetFrequency", this.destFrequency);
        nbt.func_74757_a("LaunchPadRemovalDisabled", this.launchPadRemovalDisabled);
        nbt.func_74757_a("LaunchPadSchedulingEnabled", this.launchSchedulingEnabled);
        nbt.func_74757_a("HideTargetDestination", this.hideTargetDestination);
    }

    @Override
    public ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.launchcontroller.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 0 && ItemElectricBase.isElectricItem(itemStack.func_77973_b());
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 0;
    }

    @Override
    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    @Override
    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            switch (index) {
                case 0: {
                    this.disabled = disabled;
                    this.disableCooldown = 10;
                    break;
                }
                case 1: {
                    this.launchSchedulingEnabled = disabled;
                    break;
                }
                case 2: {
                    this.hideTargetDestination = disabled;
                    this.disableCooldown = 10;
                }
            }
        }
    }

    @Override
    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.disabled;
            }
            case 1: {
                return this.launchSchedulingEnabled;
            }
            case 2: {
                return this.hideTargetDestination;
            }
        }
        return true;
    }

    @Override
    public boolean canAttachToLandingPad(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile instanceof TileEntityLandingPad;
    }

    public void setFrequency(int frequency) {
        block4: {
            this.frequency = frequency;
            if (this.frequency >= 0 && FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
                this.frequencyValid = true;
                WorldServer[] servers = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c;
                for (int i = 0; i < servers.length; ++i) {
                    WorldServer world = servers[i];
                    for (TileEntity tile2 : new ArrayList(world.field_147482_g)) {
                        if (this == tile2 || (tile2 = world.func_147438_o(tile2.field_145851_c, tile2.field_145848_d, tile2.field_145849_e)) == null || !(tile2 instanceof TileEntityLaunchController)) continue;
                        TileEntityLaunchController launchController2 = (TileEntityLaunchController)tile2;
                        if (launchController2.frequency != this.frequency) continue;
                        this.frequencyValid = false;
                        break block4;
                    }
                }
            } else {
                this.frequencyValid = false;
            }
        }
    }

    public void setDestinationFrequency(int frequency) {
        if (frequency != this.destFrequency) {
            this.destFrequency = frequency;
            this.checkDestFrequencyValid();
            this.updateRocketOnDockSettings();
        }
    }

    public void checkDestFrequencyValid() {
        if (!this.field_145850_b.field_72995_K && FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            this.destFrequencyValid = false;
            if (this.destFrequency >= 0) {
                WorldServer[] servers;
                for (WorldServer world : servers = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
                    for (TileEntity tile2 : new ArrayList(world.field_147482_g)) {
                        if (this == tile2 || (tile2 = world.func_147438_o(tile2.field_145851_c, tile2.field_145848_d, tile2.field_145849_e)) == null || !(tile2 instanceof TileEntityLaunchController)) continue;
                        TileEntityLaunchController launchController2 = (TileEntityLaunchController)tile2;
                        if (launchController2.frequency != this.destFrequency) continue;
                        this.destFrequencyValid = true;
                        return;
                    }
                }
            }
        }
    }

    public boolean validFrequency() {
        this.checkDestFrequencyValid();
        return !this.getDisabled(0) && this.hasEnoughEnergyToRun && this.frequencyValid && this.destFrequencyValid;
    }

    public void setLaunchDropdownSelection(int newvalue) {
        if (newvalue != this.launchDropdownSelection) {
            this.launchDropdownSelection = newvalue;
            this.checkDestFrequencyValid();
            this.updateRocketOnDockSettings();
        }
    }

    public void setLaunchSchedulingEnabled(boolean newvalue) {
        if (newvalue != this.launchSchedulingEnabled) {
            this.launchSchedulingEnabled = newvalue;
            this.checkDestFrequencyValid();
            this.updateRocketOnDockSettings();
        }
    }

    public void updateRocketOnDockSettings() {
        TileEntityLandingPad pad;
        IDockable rocket;
        Object object = this.attachedDock;
        if (object instanceof TileEntityLandingPad && (rocket = (pad = (TileEntityLandingPad)object).getDockedEntity()) instanceof EntityAutoRocket) {
            ((EntityAutoRocket)rocket).updateControllerSettings(pad);
        }
    }

    public void setAttachedPad(IFuelDock pad) {
        this.attachedDock = pad;
    }
}

