/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import cpw.mods.fml.relauncher.Side;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTelepadFake
extends TileBaseElectricBlock {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public BlockVec3 mainBlockPosition;
    private WeakReference<TileEntityShortRangeTelepad> mainTelepad = null;

    public void setMainBlock(BlockVec3 mainBlock) {
        this.mainBlockPosition = mainBlock.clone();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void onBlockRemoval() {
        TileEntityShortRangeTelepad telepad = this.getBaseTelepad();
        if (telepad != null) {
            telepad.onDestroy(this);
        }
    }

    public boolean onActivated(EntityPlayer par5EntityPlayer) {
        TileEntityShortRangeTelepad telepad = this.getBaseTelepad();
        return telepad != null && telepad.onActivated(par5EntityPlayer);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        TileEntityShortRangeTelepad telepad = this.getBaseTelepad();
        if (telepad != null) {
            this.storage.setCapacity(telepad.storage.getCapacityGC());
            this.storage.setMaxExtract(telepad.storage.getMaxExtract());
            this.storage.setMaxReceive(telepad.storage.getMaxReceive());
            this.extractEnergyGC(null, telepad.receiveEnergyGC(null, this.getEnergyStoredGC(), false), false);
        }
    }

    private TileEntityShortRangeTelepad getBaseTelepad() {
        TileEntity tileEntity;
        if (this.mainBlockPosition == null) {
            return null;
        }
        if (this.mainTelepad == null && (tileEntity = this.mainBlockPosition.getTileEntity((IBlockAccess)this.field_145850_b)) != null && tileEntity instanceof TileEntityShortRangeTelepad) {
            this.mainTelepad = new WeakReference<TileEntityShortRangeTelepad>((TileEntityShortRangeTelepad)tileEntity);
        }
        if (this.mainTelepad == null) {
            this.field_145850_b.func_147468_f(this.mainBlockPosition.x, this.mainBlockPosition.y, this.mainBlockPosition.z);
        } else {
            TileEntityShortRangeTelepad telepad = (TileEntityShortRangeTelepad)this.mainTelepad.get();
            if (telepad != null) {
                return telepad;
            }
            this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.mainBlockPosition = new BlockVec3(nbt.func_74775_l("mainBlockPosition"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.mainBlockPosition != null) {
            nbt.func_74782_a("mainBlockPosition", (NBTBase)this.mainBlockPosition.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public double getPacketRange() {
        return 30.0;
    }

    @Override
    public int getPacketCooldown() {
        return 50;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        if (this.mainBlockPosition == null && (this.field_145850_b.field_72995_K || !this.resetMainBlockPosition())) {
            return;
        }
        super.getNetworkedData(sendData);
    }

    private boolean resetMainBlockPosition() {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -2; y < 1; y += 2) {
                    BlockVec3 vecToCheck = new BlockVec3(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
                    if (!(vecToCheck.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityShortRangeTelepad)) continue;
                    this.setMainBlock(vecToCheck);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean shouldUseEnergy() {
        return false;
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        if (this.func_145832_p() != 0) {
            return null;
        }
        return ForgeDirection.UP;
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return null;
    }
}

