/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.machines;

import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.inventories.Inventory_RoundRobinator;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRoundRobinator
extends TileEntity
implements ISidedInventory,
IHopper {
    private int tickCount = 0;
    private final Inventory_RoundRobinator inventoryContents;
    private String customName;
    public int locationX;
    public int locationY;
    public int locationZ;
    private int aData = 1111;
    private int aTier = 1;
    private int aTickRate = 100;
    private ItemStack[] aHopperInventory = new ItemStack[5];
    private static final EnumSet<ForgeDirection> VALID_SIDES = EnumSet.of(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST);

    public TileEntityRoundRobinator() {
        this.inventoryContents = new Inventory_RoundRobinator();
        this.setTileLocation();
    }

    public boolean setTileLocation() {
        if (this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            this.locationX = this.field_145851_c;
            this.locationY = this.field_145848_d;
            this.locationZ = this.field_145849_e;
            this.aTier = this.func_145831_w().func_72805_g(this.locationX, this.locationY, this.locationZ) + 1;
            return true;
        }
        return false;
    }

    public final boolean hasInventoryContents() {
        for (ItemStack i : this.aHopperInventory) {
            if (i == null) continue;
            return true;
        }
        return false;
    }

    public Inventory_RoundRobinator getInventory() {
        return this.inventoryContents;
    }

    public int getTier() {
        return this.aTier;
    }

    public int getTickRate() {
        return this.aTickRate;
    }

    public void func_145845_h() {
        try {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.setTileLocation();
                this.aTickRate = 60 - this.aTier * 10;
                this.aTickRate = this.getTier() == 1 ? 400 : (this.getTier() == 2 ? 100 : (this.getTier() == 3 ? 20 : (this.getTier() == 4 ? 10 : (this.getTier() == 5 ? 1 : 999999))));
                if (this.tickCount % this.getTickRate() == 0 && this.hasInventoryContents()) {
                    Logger.WARNING("Trying to move items. " + this.aTickRate);
                    this.tryProcessItems();
                }
                ++this.tickCount;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean anyPlayerInRange() {
        return this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 32.0) != null;
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
        nbt.func_74768_a("aCurrentMode", this.aData);
        this.writeToNBT2(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
        this.aData = nbt.func_74762_e("aCurrentMode");
        this.readFromNBT2(nbt);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.getInventory().func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
    }

    public void func_70305_f() {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.func_145838_q());
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public int[] func_94128_d(int aSide) {
        return new int[]{0, 1, 2, 3, 4};
    }

    public boolean func_102007_a(int aSlot, ItemStack aStack, int aSide) {
        return aSide < 2;
    }

    public boolean func_102008_b(int aSlot, ItemStack aStack, int aSide) {
        return false;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.roundrobinator";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.equals("");
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public boolean onRightClick(ForgeDirection side, EntityPlayer player, int x, int y, int z) {
        if (player != null && player.func_70694_bm() == null) {
            if (!player.func_70093_af() && !KeyboardUtils.isShiftKeyDown()) {
                player.openGui((Object)GTplusplus.instance, 15, player.func_130014_f_(), x, y, z);
            } else {
                String InventoryContents = ItemUtils.getArrayStackNames(this.aHopperInventory);
                PlayerUtils.messagePlayer(player, "Contents: " + InventoryContents + " | " + this.getDataString());
            }
            return true;
        }
        return false;
    }

    public boolean onScrewdriverRightClick(ForgeDirection side, EntityPlayer player, int x, int y, int z) {
        try {
            if (side.offsetY == 0) {
                if (this.toggleSide(side)) {
                    PlayerUtils.messagePlayer(player, "Enabling side " + side + ".");
                } else {
                    PlayerUtils.messagePlayer(player, "Disabling side " + side + ".");
                }
                PlayerUtils.messagePlayer(player, "Mode String: " + this.aData + "");
            }
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public int getDataString() {
        return this.aData;
    }

    public boolean[] getActiveSides() {
        this.func_70296_d();
        String s = String.valueOf(this.aData);
        if (s == null || s.length() != 4) {
            s = "1111";
        }
        boolean[] aActiveSides = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            char ch = s.charAt(i);
            aActiveSides[i] = ch == '1';
        }
        return aActiveSides;
    }

    public boolean toggleSide(ForgeDirection side) {
        this.setSideActive(!this.getSideActive(side), side);
        return this.getSideActive(side);
    }

    public void setSideActive(boolean aActive, ForgeDirection side) {
        try {
            if (side.offsetY == 0) {
                if (this.aData < 1111) {
                    this.aData = 1111;
                } else if (this.aData > 2222) {
                    this.aData = 2222;
                }
                String s = String.valueOf(this.aData);
                StringBuilder aDataString = new StringBuilder(s);
                int aIndex = side.ordinal() - 2;
                if (aActive) {
                    aDataString.setCharAt(aIndex, '1');
                } else {
                    aDataString.setCharAt(aIndex, '2');
                }
                this.aData = Integer.valueOf(aDataString.toString());
                this.func_70296_d();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean getSideActive(ForgeDirection side) {
        this.func_70296_d();
        try {
            if (side.offsetY != 0) {
                return false;
            }
            if (this.aData < 1111) {
                this.aData = 1111;
            } else if (this.aData > 2222) {
                this.aData = 2222;
            }
            String s = String.valueOf(this.aData);
            int aIndex = side.ordinal() - 2;
            char ch = s.charAt(aIndex);
            return ch == '1';
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public double func_96107_aA() {
        return this.locationX;
    }

    public double func_96109_aB() {
        return this.locationY;
    }

    public double func_96108_aC() {
        return this.locationZ;
    }

    public int func_70302_i_() {
        return this.aHopperInventory.length;
    }

    public ItemStack func_70301_a(int aSlot) {
        return this.aHopperInventory[aSlot];
    }

    public ItemStack func_70298_a(int aSlot, int aMinimumSizeOfExistingStack) {
        if (this.aHopperInventory[aSlot] != null) {
            if (this.aHopperInventory[aSlot].field_77994_a <= aMinimumSizeOfExistingStack) {
                ItemStack itemstack = this.aHopperInventory[aSlot];
                this.aHopperInventory[aSlot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.aHopperInventory[aSlot].func_77979_a(aMinimumSizeOfExistingStack);
            if (this.aHopperInventory[aSlot].field_77994_a == 0) {
                this.aHopperInventory[aSlot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int aSlot) {
        if (this.aHopperInventory[aSlot] != null) {
            ItemStack itemstack = this.aHopperInventory[aSlot];
            this.aHopperInventory[aSlot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int aSlot, ItemStack aStack) {
        this.aHopperInventory[aSlot] = aStack;
        if (aStack != null && aStack.field_77994_a > this.func_70297_j_()) {
            aStack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean tryProcessItems() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            boolean didSomething = false;
            if (!this.isEmpty()) {
                Logger.WARNING("Has Items, Trying to push to all active directions.");
                didSomething = this.tryPushItemsIntoNeighbours();
            }
            if (didSomething) {
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean isEmpty() {
        for (ItemStack itemstack : this.aHopperInventory) {
            if (itemstack == null) continue;
            return false;
        }
        return true;
    }

    private boolean tryPushItemsIntoNeighbours() {
        boolean aDidPush = false;
        for (ForgeDirection side : VALID_SIDES) {
            int ordinalSide = side.ordinal();
            if (!this.getSideActive(side)) {
                Logger.WARNING("Not pushing on side " + side);
                continue;
            }
            Logger.WARNING("Pushing on side " + side);
            IInventory iinventory = this.getInventoryFromFacing(side);
            if (iinventory == null) {
                Logger.WARNING("No inventory found.");
                continue;
            }
            ForgeDirection oppositeSide = side.getOpposite();
            Logger.WARNING("Using Opposite direction: " + oppositeSide);
            if (this.isInventoryFull(iinventory, oppositeSide.ordinal())) {
                Logger.WARNING("Target is full, skipping.");
                continue;
            }
            Logger.WARNING("Target has space, let's move a single item.");
            for (int j = 0; j < this.func_70302_i_(); ++j) {
                if (this.func_70301_a(j) == null) continue;
                ItemStack itemstack = this.func_70301_a(j).func_77946_l();
                ItemStack itemstack1 = TileEntityRoundRobinator.setStackInNeighbour(iinventory, this.func_70298_a(j, 1), ordinalSide);
                if (itemstack1 == null || itemstack1.field_77994_a == 0) {
                    iinventory.func_70296_d();
                    aDidPush = true;
                    continue;
                }
                this.func_70299_a(j, itemstack);
            }
        }
        return aDidPush;
    }

    private boolean isInventoryFull(IInventory aInv, int ordinalSide) {
        if (aInv instanceof ISidedInventory && ordinalSide > -1) {
            ISidedInventory isidedinventory = (ISidedInventory)aInv;
            int[] aint = isidedinventory.func_94128_d(ordinalSide);
            for (int l = 0; l < aint.length; ++l) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(aint[l]);
                if (itemstack1 != null && itemstack1.field_77994_a == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int j = aInv.func_70302_i_();
            for (int k = 0; k < j; ++k) {
                ItemStack itemstack = aInv.func_70301_a(k);
                if (itemstack != null && itemstack.field_77994_a == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    public static ItemStack setStackInNeighbour(IInventory aNeighbour, ItemStack aStack, int ordinalSide) {
        if (aNeighbour instanceof ISidedInventory && ordinalSide > -1) {
            ISidedInventory isidedinventory = (ISidedInventory)aNeighbour;
            int[] aint = isidedinventory.func_94128_d(ordinalSide);
            for (int l = 0; l < aint.length && aStack != null && aStack.field_77994_a > 0; ++l) {
                aStack = TileEntityRoundRobinator.tryMoveStack(aNeighbour, aStack, aint[l], ordinalSide);
            }
        } else {
            int j = aNeighbour.func_70302_i_();
            for (int k = 0; k < j && aStack != null && aStack.field_77994_a > 0; ++k) {
                aStack = TileEntityRoundRobinator.tryMoveStack(aNeighbour, aStack, k, ordinalSide);
            }
        }
        if (aStack != null && aStack.field_77994_a == 0) {
            aStack = null;
        }
        return aStack;
    }

    private static boolean canInsertItemIntoNeighbour(IInventory aNeighbour, ItemStack aStack, int aSlot, int aSide) {
        return !aNeighbour.func_94041_b(aSlot, aStack) ? false : !(aNeighbour instanceof ISidedInventory) || ((ISidedInventory)aNeighbour).func_102007_a(aSlot, aStack, aSide);
    }

    private static ItemStack tryMoveStack(IInventory aNeighbour, ItemStack aStack, int aSlot, int aSide) {
        ItemStack itemstack1 = aNeighbour.func_70301_a(aSlot);
        if (TileEntityRoundRobinator.canInsertItemIntoNeighbour(aNeighbour, aStack, aSlot, aSide)) {
            int max;
            boolean aDidSomething = false;
            if (itemstack1 == null) {
                int max2 = Math.min(aStack.func_77976_d(), aNeighbour.func_70297_j_());
                if (max2 >= aStack.field_77994_a) {
                    aNeighbour.func_70299_a(aSlot, aStack);
                    aStack = null;
                } else {
                    aNeighbour.func_70299_a(aSlot, aStack.func_77979_a(max2));
                }
                aDidSomething = true;
            } else if (TileEntityRoundRobinator.areItemStacksEqual(itemstack1, aStack) && (max = Math.min(aStack.func_77976_d(), aNeighbour.func_70297_j_())) > itemstack1.field_77994_a) {
                int l = Math.min(aStack.field_77994_a, max - itemstack1.field_77994_a);
                aStack.field_77994_a -= l;
                itemstack1.field_77994_a += l;
                boolean bl = aDidSomething = l > 0;
            }
            if (aDidSomething) {
                aNeighbour.func_70296_d();
            }
        }
        return aStack;
    }

    private IInventory getInventoryFromFacing(ForgeDirection side) {
        return TileEntityRoundRobinator.tryFindInvetoryAtXYZ(this.func_145831_w(), this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
    }

    public static IInventory tryFindInvetoryAtXYZ(World aWorld, double aX, double aY, double aZ) {
        List list;
        Block block;
        int sZ;
        int sY;
        IInventory iinventory = null;
        int sX = MathHelper.func_76128_c((double)aX);
        TileEntity tileentity = aWorld.func_147438_o(sX, sY = MathHelper.func_76128_c((double)aY), sZ = MathHelper.func_76128_c((double)aZ));
        if (tileentity != null && tileentity instanceof IInventory && (iinventory = (IInventory)tileentity) instanceof TileEntityChest && (block = aWorld.func_147439_a(sX, sY, sZ)) instanceof BlockChest) {
            iinventory = ((BlockChest)block).func_149951_m(aWorld, sX, sY, sZ);
        }
        if (iinventory == null && (list = aWorld.func_94576_a((Entity)null, AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1.0), (double)(aY + 1.0), (double)(aZ + 1.0)), IEntitySelector.field_96566_b)) != null && list.size() > 0) {
            iinventory = (IInventory)list.get(aWorld.field_73012_v.nextInt(list.size()));
        }
        return iinventory;
    }

    private static boolean areItemStacksEqual(ItemStack aStack, ItemStack aStack2) {
        return aStack.func_77973_b() != aStack2.func_77973_b() ? false : (aStack.func_77960_j() != aStack2.func_77960_j() ? false : (aStack.field_77994_a > aStack.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)aStack, (ItemStack)aStack2)));
    }

    public void readFromNBT2(NBTTagCompound p_145839_1_) {
        super.func_145839_a(p_145839_1_);
        NBTTagList nbttaglist = p_145839_1_.func_150295_c("Items", 10);
        this.aHopperInventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.aHopperInventory.length) continue;
            this.aHopperInventory[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void writeToNBT2(NBTTagCompound aNBT) {
        super.func_145841_b(aNBT);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.aHopperInventory.length; ++i) {
            if (this.aHopperInventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.aHopperInventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        aNBT.func_74782_a("Items", (NBTBase)nbttaglist);
    }
}

