/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles"), @Optional.Interface(iface="baubles.api.BaubleType", modid="Baubles")})
public class ItemCloakingDevice
extends Item
implements IElectricItem,
IElectricItemManager,
IBauble {
    private final String unlocalizedName = "personalCloakingDevice";
    private final ItemStack thisStack;
    private static final int maxValueEU = 100000000;
    protected double chargeEU = 0.0;

    public ItemCloakingDevice(double charge) {
        this.chargeEU = charge;
        this.func_77637_a(AddToCreativeTab.tabMachines);
        this.func_77655_b(this.unlocalizedName);
        this.func_77625_d(1);
        this.func_111206_d(Mods.GTPlusPlus.ID + ":personalCloakingDevice");
        this.thisStack = ItemUtils.getSimpleStack(this);
        this.charge(this.thisStack, charge, 3, true, false);
        if (charge == 1.0E8) {
            this.setDamage(this.thisStack, 13);
        }
        GameRegistry.registerItem((Item)this, (String)(this.unlocalizedName + "-" + charge));
    }

    public void func_77663_a(ItemStack itemStack, World worldObj, Entity player, int p_77663_4_, boolean p_77663_5_) {
        if (worldObj.field_72995_K) {
            return;
        }
        if (player instanceof EntityPlayer) {
            for (ItemStack is : ((EntityPlayer)player).field_71071_by.field_70462_a) {
                if (is == itemStack || is == null || !(is.func_77973_b() instanceof IElectricItem)) continue;
                IElectricItem electricItem = (IElectricItem)is.func_77973_b();
                this.chargeEU = ElectricItem.manager.getCharge(is);
            }
        }
        super.func_77663_a(itemStack, worldObj, player, p_77663_4_, p_77663_5_);
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public Item getChargedItem(ItemStack itemStack) {
        ItemStack x = itemStack.func_77946_l();
        x.func_77964_b(100000000);
        return x.func_77973_b();
    }

    public Item getEmptyItem(ItemStack itemStack) {
        ItemStack x = itemStack.func_77946_l();
        x.func_77964_b(0);
        return x.func_77973_b();
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 1.0E8;
    }

    public int getTier(ItemStack itemStack) {
        return 5;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 8196.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int secondsLeft(ItemStack stack) {
        double r = 0.0;
        r = this.getCharge(stack) / 200000.0;
        return (int)MathUtils.decimalRounding(r);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        list.add("");
        list.add(StatCollector.func_74838_a((String)"item.personalCloakingDevice.tooltip.0"));
        list.add(StatCollector.func_74838_a((String)"item.personalCloakingDevice.tooltip.1"));
        list.add("");
        list.add(StatCollector.func_74838_a((String)"item.personalCloakingDevice.tooltip.2"));
        list.add(StatCollector.func_74837_a((String)"item.personalCloakingDevice.tooltip.3", (Object[])new Object[]{this.getTier(this.thisStack), this.getTransferLimit(this.thisStack)}));
        list.add(StatCollector.func_74837_a((String)"item.personalCloakingDevice.tooltip.4", (Object[])new Object[]{(long)this.getCharge(stack), MathUtils.findPercentage(this.getCharge(stack), this.getMaxCharge(stack))}));
        list.add(StatCollector.func_74837_a((String)"item.personalCloakingDevice.tooltip.5", (Object[])new Object[]{this.secondsLeft(stack)}));
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public double charge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (!simulate) {
            ElectricItem.manager.charge(stack, amount, tier, true, simulate);
        }
        return ElectricItem.manager.charge(stack, amount, tier, true, simulate);
    }

    public double discharge(ItemStack stack, double amount, int tier, boolean ignoreTransferLimit, boolean externally, boolean simulate) {
        if (!simulate) {
            ElectricItem.manager.discharge(stack, amount, tier, ignoreTransferLimit, externally, simulate);
        }
        return ElectricItem.manager.discharge(stack, amount, tier, ignoreTransferLimit, externally, simulate);
    }

    public double getCharge(ItemStack stack) {
        return ElectricItem.manager.getCharge(stack);
    }

    public boolean canUse(ItemStack stack, double amount) {
        return ElectricItem.manager.canUse(stack, amount);
    }

    public boolean use(ItemStack stack, double amount, EntityLivingBase entity) {
        return ElectricItem.manager.use(stack, amount, entity);
    }

    public void chargeFromArmor(ItemStack stack, EntityLivingBase entity) {
        ElectricItem.manager.chargeFromArmor(stack, entity);
    }

    public String getToolTip(ItemStack stack) {
        return ElectricItem.manager.getToolTip(stack);
    }

    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.BELT;
    }

    public void onEquipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    public void onUnequipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    public void onWornTick(ItemStack arg0, EntityLivingBase arg1) {
        if (!arg1.field_70170_p.field_72995_K) {
            if (this.getCharge(arg0) >= 10000.0) {
                arg1.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 10, 2));
                this.discharge(arg0, 10000.0, 5, true, true, false);
            } else if (arg1.func_70644_a(Potion.field_76441_p)) {
                arg1.func_82170_o(Potion.field_76441_p.field_76415_H);
            }
        }
    }
}

