/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.bauble;

import baubles.api.BaubleType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GT_Values;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.AABB;
import gtPlusPlus.core.item.bauble.ElectricBaseBauble;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import ic2.api.item.ElectricItem;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class MonsterKillerBaseBauble
extends ElectricBaseBauble {
    private final Class[] mTargets;

    public MonsterKillerBaseBauble(Class[] aMonsterBaseClassArray, String aMonsterTypeName, int aPowerTier) {
        super(BaubleType.AMULET, aPowerTier, GT_Values.V[aPowerTier] * 20L * 300L, "GTPP.MonsterKiller." + aMonsterTypeName + ".name");
        this.mTargets = aMonsterBaseClassArray;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack charged;
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getEmptyItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 0.0, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getChargedItem(itemStack) == this) {
            charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, Double.POSITIVE_INFINITY, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World worldObj, Entity player, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(itemStack, worldObj, player, p_77663_4_, p_77663_5_);
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        double aItemCharge = ElectricItem.manager.getCharge(itemStack);
        return aItemCharge > 0.0;
    }

    @Override
    public String func_77653_i(ItemStack p_77653_1_) {
        return EnumChatFormatting.WHITE + super.func_77653_i(p_77653_1_) + EnumChatFormatting.GRAY;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        list.add("");
        String aString1 = StatCollector.func_74838_a((String)"GTPP.monsterkiller.tooltip.1");
        String aString2 = StatCollector.func_74838_a((String)"GTPP.monsterkiller.tooltip.2");
        String aString3 = StatCollector.func_74838_a((String)"GTPP.monsterkiller.tooltip.3");
        String aString4 = StatCollector.func_74838_a((String)"GTPP.monsterkiller.tooltip.4");
        String aEU = StatCollector.func_74838_a((String)"GTPP.info.eu");
        String aEUT = aEU + "/t";
        list.add(EnumChatFormatting.GREEN + aString1 + EnumChatFormatting.GRAY);
        list.add(EnumChatFormatting.GREEN + aString2 + " " + (int)this.getTransferLimit(stack) + aEUT + " " + aString3 + EnumChatFormatting.GRAY);
        list.add("");
        list.add("" + EnumChatFormatting.GREEN + aString4 + " " + EnumChatFormatting.GRAY);
        for (Class cz : this.mTargets) {
            list.add("- " + EnumChatFormatting.DARK_GREEN + cz.getSimpleName().replace("Entity", "") + EnumChatFormatting.GRAY);
        }
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    @Override
    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Override
    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Override
    public void onEquipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    @Override
    public void onUnequipped(ItemStack arg0, EntityLivingBase arg1) {
    }

    @Override
    public void onWornTick(ItemStack aBaubleStack, EntityLivingBase aPlayerEntity) {
        if (aPlayerEntity == null) {
            return;
        }
        EntityPlayer aPlayer = (EntityPlayer)aPlayerEntity;
        if (!aPlayer.field_70170_p.field_72995_K) {
            if (this.getCharge(aBaubleStack) >= this.getTransferLimit(aBaubleStack)) {
                AABB aPlayerBox = new AABB((Entity)aPlayerEntity, 5, 5, 5);
                if (this.mTargets != null && this.mTargets.length > 0) {
                    for (Class clazz : this.mTargets) {
                        float aEntMaxHealth;
                        float aEntHealth;
                        double aEntHealthPerc;
                        long aEuUsage;
                        AutoMap<Entity> aEnts = EntityUtils.getEntitiesWithinBoundingBox(clazz, aPlayerBox);
                        if (aEnts.isEmpty()) continue;
                        EntityLiving aClosest = null;
                        double aEntityDistance = -32768.0;
                        for (Entity ent : aEnts) {
                            if (!EntityLiving.class.isInstance(ent)) continue;
                            double aCurEntDis = EntityUtils.getDistance((Entity)aPlayerEntity, ent);
                            if (aEntityDistance != -32768.0 && !(aCurEntDis < aEntityDistance)) continue;
                            aEntityDistance = aCurEntDis;
                            aClosest = (EntityLiving)ent;
                        }
                        if (aClosest == null || !(this.discharge(aBaubleStack, aEuUsage = (long)((aEntHealthPerc = (double)MathUtils.findPercentage(aEntHealth = aClosest.func_110143_aJ(), aEntMaxHealth = aClosest.func_110138_aP())) * 50.0 * (double)aEntMaxHealth), this.mTier, true, false, false) > 0.0)) continue;
                        aClosest.func_70106_y();
                        PlayerUtils.messagePlayer(aPlayer, "Removed 1x " + aClosest.func_70005_c_());
                        break;
                    }
                }
            } else {
                return;
            }
        }
    }

    @Override
    public String getTextureNameForBauble() {
        return "baubles/itemAmulet";
    }
}

