/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.entity.monster;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.entity.ai.batking.EntityAIBatKingAttack;
import gtPlusPlus.core.entity.projectile.EntityThrowableBomb;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.lang.reflect.Field;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityBatKing
extends EntityMob
implements IRangedAttackMob {
    public int courseChangeCooldown;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    private Entity targetedEntity;
    private int aggroCooldown;
    public int prevAttackCounter;
    public int attackCounter;
    private int explosionStrength = 1;
    private EntityAIBatKingAttack aiAttack = new EntityAIBatKingAttack(this, null, 1.0, 20, 60, 15.0f, true);
    private EntityAIAttackOnCollide aiAttackOnCollide = new EntityAIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.2, false);

    public EntityBatKing(World p_i1680_1_) {
        super(p_i1680_1_);
        this.func_70105_a(2.5f, 1.5f);
        this.setIsBatHanging(false);
        this.field_70178_ae = true;
        this.field_70728_aV = 1000;
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiAttack);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityBat.class, 0, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.15f;
    }

    protected String func_70639_aQ() {
        int aRand = MathUtils.randInt(0, 10);
        if (aRand < 6) {
            return null;
        }
        if (aRand <= 8) {
            return "mob.bat.idle";
        }
        return "mob.blaze.breathe";
    }

    protected String func_70621_aR() {
        return "mob.blaze.hit";
    }

    protected String func_70673_aS() {
        return "mob.bat.death";
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity aEntity) {
        if (aEntity != null && aEntity instanceof EntityPlayer) {
            EntityUtils.doDamage(aEntity, DamageSource.field_76376_m, (int)(((EntityPlayer)aEntity).func_110143_aJ() / 20.0f));
        }
    }

    protected void func_85033_bc() {
    }

    protected void func_110147_ax() {
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111267_a);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111266_c);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111263_d);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111265_b);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(250.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(120.0);
    }

    public boolean getIsBatHanging() {
        return false;
    }

    public void setIsBatHanging(boolean p_82236_1_) {
        EntityBatKing.generateParticles(this);
        EntityBatKing.generateParticles(this);
        EntityBatKing.generateParticles(this);
        for (int i = 0; i < 32; ++i) {
            String particleName = "lava";
            if (MathUtils.randInt(0, 3) <= 2) {
                particleName = "crit";
            }
            this.field_70170_p.func_72869_a(particleName, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
        }
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        EntityBatKing.generateParticles(this);
        if (!(this.field_70170_p.field_72995_K || this.targetedEntity != null && this.aggroCooldown-- > 0)) {
            this.targetedEntity = this.field_70170_p.func_72856_b((Entity)this, 100.0);
            if (this.targetedEntity != null) {
                this.aggroCooldown = 30;
                if (this.aiAttack.hasValidTarget()) {
                    this.func_70624_b(this.aiAttack.getTarget());
                } else {
                    Logger.INFO("No valid target.");
                    if (ReflectionUtils.doesFieldExist(((Object)((Object)this.aiAttack)).getClass(), "mEntityTarget")) {
                        Logger.INFO("Found field.");
                    } else {
                        Logger.INFO("Did not find field.");
                    }
                    Field target = ReflectionUtils.getField(EntityAIBatKingAttack.class, "mEntityTarget");
                    if (target != null) {
                        ReflectionUtils.setField((Object)this.aiAttack, target, (Object)this.targetedEntity);
                        Logger.INFO("Set target.");
                    } else {
                        Logger.INFO("Could not set via reflection.");
                    }
                }
            } else {
                Vec3 vec3 = RandomPositionGenerator.func_75463_a((EntityCreature)this, (int)32, (int)20);
                if (vec3 != null) {
                    double xPosition = vec3.field_72450_a;
                    double yPosition = vec3.field_72448_b;
                    double zPosition = vec3.field_72449_c;
                    this.func_70661_as().func_75492_a(xPosition, yPosition, zPosition, 3.0);
                }
            }
        }
    }

    private static void generateParticles(EntityBatKing aKing) {
        for (int i = 0; i < 20; ++i) {
            String particleName;
            if (MathUtils.randInt(0, 50) <= 1) {
                particleName = "smoke";
                if (MathUtils.randInt(0, 3) <= 2) {
                    particleName = "largesmoke";
                }
                aKing.field_70170_p.func_72869_a(particleName, aKing.field_70165_t + (aKing.field_70146_Z.nextDouble() - 0.5) * (double)aKing.field_70130_N, aKing.field_70163_u + aKing.field_70146_Z.nextDouble() * (double)aKing.field_70131_O, aKing.field_70161_v + (aKing.field_70146_Z.nextDouble() - 0.5) * (double)aKing.field_70130_N, 0.0, 0.0, 0.0);
            }
            if (MathUtils.randInt(0, 100) > 1) continue;
            particleName = "smoke";
            int test2 = MathUtils.randInt(0, 3);
            if (test2 == 2) {
                particleName = "dripLava";
            } else if (test2 == 3) {
                particleName = "portal";
            }
            aKing.field_70170_p.func_72869_a(particleName, aKing.field_70165_t + (aKing.field_70146_Z.nextDouble() - 0.5) * (double)aKing.field_70130_N, aKing.field_70163_u + aKing.field_70146_Z.nextDouble() * (double)aKing.field_70131_O, aKing.field_70161_v + (aKing.field_70146_Z.nextDouble() - 0.5) * (double)aKing.field_70130_N, 0.0, 0.0, 0.0);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    private boolean isFlying() {
        return !this.field_70122_E;
    }

    private boolean hasAir() {
        BlockPos p = EntityUtils.findBlockPosUnderEntity((Entity)this);
        int y = p.yPos;
        int yOriginal = p.yPos;
        for (int u = 0; u < 5 && u <= 50 && y > 0 && this.field_70170_p.func_147437_c(p.xPos, y, p.zPos); --y, ++u) {
        }
        if (yOriginal != y) {
            int i = 0;
            while (i < y) {
                this.func_70664_aZ();
                ++y;
            }
            return true;
        }
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_85032_ar()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.getIsBatHanging()) {
            this.setIsBatHanging(false);
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        if (p_70037_1_.func_150297_b("ExplosionPower", 99)) {
            this.explosionStrength = p_70037_1_.func_74762_e("ExplosionPower");
        }
    }

    public void func_70014_b(NBTTagCompound p_70014_1_) {
        super.func_70014_b(p_70014_1_);
        p_70014_1_.func_74768_a("ExplosionPower", this.explosionStrength);
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        Logger.INFO("Trying to do ranged attack 1 |" + (this.targetedEntity != null) + "|");
        if (!this.isFlying() || !this.field_70160_al) {
            // empty if block
        }
        double d4 = 64.0;
        if (this.targetedEntity != null && this.targetedEntity.func_70068_e((Entity)this) < d4 * d4 * 8.0) {
            Logger.INFO("Trying to do ranged attack 2");
            double d5 = this.targetedEntity.field_70165_t - this.field_70165_t;
            double d6 = this.targetedEntity.field_70121_D.field_72338_b + (double)(this.targetedEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d7 = this.targetedEntity.field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(d5, d7)) * 180.0f / (float)Math.PI;
            ++this.attackCounter;
            if (this.func_70685_l(this.targetedEntity)) {
                Logger.INFO("Trying to do ranged attack 3a | " + this.attackCounter);
                if (this.attackCounter >= 2) {
                    Logger.INFO("Trying to do ranged attack 3a1");
                    this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                    this.setIsBatHanging(true);
                    EntityThrowableBomb entitylargefireball = new EntityThrowableBomb(this.field_70170_p, (EntityLivingBase)this);
                    double d8 = 4.0;
                    Vec3 vec3 = this.func_70676_i(1.0f);
                    entitylargefireball.field_70165_t = this.field_70165_t + vec3.field_72450_a * d8;
                    entitylargefireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
                    entitylargefireball.field_70161_v = this.field_70161_v + vec3.field_72449_c * d8;
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    for (int u = 0; u < MathUtils.randInt(2, 10); ++u) {
                        boolean boostAttack;
                        if (this.attackCounter <= 0) continue;
                        Logger.INFO("Trying to do ranged attack 5a");
                        --this.attackCounter;
                        EntityArrow entityarrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, p_82196_1_, MathUtils.randFloat(1.0f, 3.0f), (float)(14 - this.field_70170_p.field_73013_u.func_151525_a() * 4));
                        int i = MathUtils.randInt(0, 4);
                        int j = MathUtils.randInt(0, 3);
                        int k = MathUtils.randInt(0, 3);
                        entityarrow.func_70239_b((double)(p_82196_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f));
                        boolean bl = boostAttack = MathUtils.randInt(0, 100) <= 21;
                        if (boostAttack) {
                            if (i > 0) {
                                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
                            }
                            if (j > 0) {
                                entityarrow.func_70240_a(j);
                            }
                            if (k > 0) {
                                entityarrow.func_70015_d(50 * k);
                            }
                        }
                        this.func_85030_a("mob.skeleton.say", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        this.field_70170_p.func_72838_d((Entity)entityarrow);
                        Logger.INFO("Trying to do ranged attack 5a done");
                    }
                    this.attackCounter = 0;
                }
            } else if (this.attackCounter > 0) {
                Logger.INFO("Trying to do ranged attack 3b");
                --this.attackCounter;
            }
        } else {
            Logger.INFO("Trying to do ranged attack 4a");
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            if (this.attackCounter > 0) {
                boolean boostAttack;
                Logger.INFO("Trying to do ranged attack 5a");
                --this.attackCounter;
                EntityArrow entityarrow = new EntityArrow(this.field_70170_p, (EntityLivingBase)this, p_82196_1_, 1.6f, (float)(14 - this.field_70170_p.field_73013_u.func_151525_a() * 4));
                int i = MathUtils.randInt(0, 4);
                int j = MathUtils.randInt(0, 3);
                int k = MathUtils.randInt(0, 3);
                entityarrow.func_70239_b((double)(p_82196_2_ * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.field_73013_u.func_151525_a() * 0.11f));
                boolean bl = boostAttack = MathUtils.randInt(0, 100) <= 21;
                if (boostAttack) {
                    if (i > 0) {
                        entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)i * 0.5 + 0.5);
                    }
                    if (j > 0) {
                        entityarrow.func_70240_a(j);
                    }
                    if (k > 0) {
                        entityarrow.func_70015_d(50 * k);
                    }
                }
                this.func_85030_a("mob.skeleton.say", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_72838_d((Entity)entityarrow);
                Logger.INFO("Trying to do ranged attack 5a done");
            }
        }
    }

    protected float func_70599_aP() {
        return 10.0f;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi() && this.field_70170_p.field_73013_u != EnumDifficulty.PEACEFUL;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected void func_70628_a(boolean p_70628_1_, int p_70628_2_) {
        int k;
        int j = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(1 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151073_bk, 1);
        }
        j = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + p_70628_2_);
        for (k = 0; k < j; ++k) {
            this.func_145779_a(Items.field_151016_H, 1);
        }
    }

    protected void func_70626_be() {
        byte b0;
        byte b1;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.func_70623_bb();
        this.prevAttackCounter = this.attackCounter;
        double d0 = this.waypointX - this.field_70165_t;
        double d1 = this.waypointY - this.field_70163_u;
        double d2 = this.waypointZ - this.field_70161_v;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        if (d3 < 1.0 || d3 > 3600.0) {
            this.waypointX = this.field_70165_t + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointY = this.field_70163_u + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
            this.waypointZ = this.field_70161_v + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 16.0f);
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.field_70146_Z.nextInt(5) + 2;
            if (this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, d3 = (double)MathHelper.func_76133_a((double)d3))) {
                this.field_70159_w += d0 / d3 * 0.1;
                this.field_70181_x += d1 / d3 * 0.1;
                this.field_70179_y += d2 / d3 * 0.1;
            } else {
                this.waypointX = this.field_70165_t;
                this.waypointY = this.field_70163_u;
                this.waypointZ = this.field_70161_v;
            }
        }
        if (this.targetedEntity != null && this.targetedEntity.field_70128_L) {
            this.targetedEntity = null;
        }
        if (this.targetedEntity == null || this.aggroCooldown-- <= 0) {
            this.targetedEntity = this.field_70170_p.func_72856_b((Entity)this, 100.0);
            if (this.targetedEntity != null) {
                this.aggroCooldown = 20;
            }
        }
        double d4 = 64.0;
        if (this.targetedEntity != null && this.targetedEntity.func_70068_e((Entity)this) < d4 * d4) {
            double d5 = this.targetedEntity.field_70165_t - this.field_70165_t;
            double d6 = this.targetedEntity.field_70121_D.field_72338_b + (double)(this.targetedEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d7 = this.targetedEntity.field_70161_v - this.field_70161_v;
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(d5, d7)) * 180.0f / (float)Math.PI;
            if (this.func_70685_l(this.targetedEntity)) {
                if (this.attackCounter == 10) {
                    this.field_70170_p.func_72889_a((EntityPlayer)null, 1007, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                }
                ++this.attackCounter;
                if (this.attackCounter == 20) {
                    this.field_70170_p.func_72889_a((EntityPlayer)null, 1008, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                    EntityLargeFireball entitylargefireball = new EntityLargeFireball(this.field_70170_p, (EntityLivingBase)this, d5, d6, d7);
                    entitylargefireball.field_92057_e = this.explosionStrength;
                    double d8 = 4.0;
                    Vec3 vec3 = this.func_70676_i(1.0f);
                    entitylargefireball.field_70165_t = this.field_70165_t + vec3.field_72450_a * d8;
                    entitylargefireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
                    entitylargefireball.field_70161_v = this.field_70161_v + vec3.field_72449_c * d8;
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    this.attackCounter = -40;
                }
            } else if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        } else {
            this.field_70761_aq = this.field_70177_z = -((float)Math.atan2(this.field_70159_w, this.field_70179_y)) * 180.0f / (float)Math.PI;
            if (this.attackCounter > 0) {
                --this.attackCounter;
            }
        }
        if (!this.field_70170_p.field_72995_K && (b1 = this.field_70180_af.func_75683_a(16)) != (b0 = (byte)(this.attackCounter > 10 ? 1 : 0))) {
            this.field_70180_af.func_75692_b(16, (Object)b0);
        }
    }

    private boolean isCourseTraversable(double p_70790_1_, double p_70790_3_, double p_70790_5_, double p_70790_7_) {
        double d4 = (this.waypointX - this.field_70165_t) / p_70790_7_;
        double d5 = (this.waypointY - this.field_70163_u) / p_70790_7_;
        double d6 = (this.waypointZ - this.field_70161_v) / p_70790_7_;
        AxisAlignedBB axisalignedbb = this.field_70121_D.func_72329_c();
        int i = 1;
        while ((double)i < p_70790_7_) {
            axisalignedbb.func_72317_d(d4, d5, d6);
            ++i;
        }
        return true;
    }

    protected void func_70069_a(float p_70069_1_) {
    }

    protected void func_70064_a(double p_70064_1_, boolean p_70064_3_) {
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.func_70090_H()) {
            this.func_70060_a(p_70612_1_, p_70612_2_, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_70058_J()) {
            this.func_70060_a(p_70612_1_, p_70612_2_, 0.02f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            this.func_70060_a(p_70612_1_, p_70612_2_, this.field_70122_E ? 0.1f * f3 : 0.02f);
            f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }
}

