/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.commands;

import cpw.mods.fml.common.registry.GameRegistry;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.commands.CommandUtils;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.preloader.CORE_Preloader;
import gtPlusPlus.preloader.asm.AsmConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class CommandEnableDebugWhileRunning
implements ICommand {
    private final List<String> aliases = new ArrayList<String>();

    public CommandEnableDebugWhileRunning() {
        this.aliases.add("gtplusplus");
    }

    public int compareTo(Object o) {
        if (o instanceof Comparable) {
            Comparable a = (Comparable)o;
            if (a.equals(this)) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public String func_71517_b() {
        return "gtpp";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/gtpp ?";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_71515_b(ICommandSender S, String[] argString) {
        int aMaxArgumentsAllowed = 2;
        if (argString == null || argString.length == 0 || argString.length > aMaxArgumentsAllowed || argString[0].toLowerCase().equals("?")) {
            Logger.INFO("Listing commands and their uses.");
            EntityPlayer P = CommandUtils.getPlayer(S);
            AsmConfig.disableAllLogging = Utils.invertBoolean(AsmConfig.disableAllLogging);
            PlayerUtils.messagePlayer(P, "The following are valid args for the '/gtpp' command:");
            PlayerUtils.messagePlayer(P, "?       - This help command.");
            PlayerUtils.messagePlayer(P, "logging - Toggles ALL GT++ logging for current session.");
            PlayerUtils.messagePlayer(P, "hand - Lists information about held item.");
            PlayerUtils.messagePlayer(P, "fuid xxx - Tries to find the fluid in the FluidRegistry.");
            PlayerUtils.messagePlayer(P, "debug   - Toggles GT++ Debug Mode. Only use when advised, may break everything. (OP)");
        } else if (argString[0].toLowerCase().equals("debug")) {
            Logger.INFO("Toggling Debug Mode.");
            EntityPlayer P = CommandUtils.getPlayer(S);
            if (PlayerUtils.isPlayerOP(P)) {
                CORE_Preloader.DEBUG_MODE = Utils.invertBoolean(CORE_Preloader.DEBUG_MODE);
                PlayerUtils.messagePlayer(P, "Toggled GT++ Debug Mode - Enabled: " + CORE_Preloader.DEBUG_MODE);
            }
        } else if (argString[0].toLowerCase().equals("logging")) {
            Logger.INFO("Toggling Logging.");
            EntityPlayer P = CommandUtils.getPlayer(S);
            AsmConfig.disableAllLogging = Utils.invertBoolean(AsmConfig.disableAllLogging);
            PlayerUtils.messagePlayer(P, "Toggled GT++ Logging - Enabled: " + !AsmConfig.disableAllLogging);
        } else if (argString[0].toLowerCase().equals("inv")) {
            EntityPlayer P = CommandUtils.getPlayer(S);
            if (P != null && !P.field_70170_p.field_72995_K) {
                ItemStack[] aInv;
                for (ItemStack aItem : aInv = P.field_71071_by.field_70462_a) {
                    if (aItem == null) continue;
                    String aModID = GameRegistry.findUniqueIdentifierFor((Item)aItem.func_77973_b()).modId;
                    String aRegistryName = GameRegistry.findUniqueIdentifierFor((Item)aItem.func_77973_b()).name;
                    Logger.INFO(aModID + ":" + aRegistryName + ":" + aItem.func_77960_j() + " | " + aItem.func_82833_r());
                }
                PlayerUtils.messagePlayer(P, "Dumped Inventory.");
            }
        } else if (argString[0].toLowerCase().equals("hand")) {
            EntityPlayer P = CommandUtils.getPlayer(S);
            if (P != null) {
                ItemStack aHeldItem = PlayerUtils.getItemStackInPlayersHand(P);
                if (aHeldItem != null) {
                    int[] aOreIDs;
                    String aItemDisplayName = ItemUtils.getItemName(aHeldItem);
                    String aItemUnlocalName = ItemUtils.getUnlocalizedItemName(aHeldItem);
                    String aNbtString = CommandEnableDebugWhileRunning.tryIterateNBTData(aHeldItem);
                    AutoMap<String> aOreDictNames = new AutoMap<String>();
                    for (int id : aOreIDs = OreDictionary.getOreIDs((ItemStack)aHeldItem)) {
                        String aOreNameFromID = OreDictionary.getOreName((int)id);
                        if (aOreNameFromID == null || aOreNameFromID.length() <= 0 || aOreNameFromID.equals("Unknown")) continue;
                        aOreDictNames.add(aOreNameFromID);
                    }
                    String aOreDictData = "";
                    if (!aOreDictNames.isEmpty()) {
                        for (String tag : aOreDictNames) {
                            aOreDictData = aOreDictData + tag + ", ";
                        }
                        if (aOreDictData.endsWith(", ")) {
                            aOreDictData = aOreDictData.substring(0, aOreDictData.length() - 2);
                        }
                    }
                    AutoMap<String> aFluidContainerData = new AutoMap<String>();
                    FluidStack aHeldItemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)aHeldItem);
                    if (aHeldItemFluid != null) {
                        aFluidContainerData.put("FluidStack Unlocal Name: " + aHeldItemFluid.getUnlocalizedName());
                        aFluidContainerData.put("FluidStack Local Name: " + aHeldItemFluid.getLocalizedName());
                        aFluidContainerData.put("Fluid Unlocal Name: " + aHeldItemFluid.getFluid().getUnlocalizedName());
                        aFluidContainerData.put("Fluid Local Name: " + aHeldItemFluid.getLocalizedName());
                        aFluidContainerData.put("Fluid Name: " + aHeldItemFluid.getFluid().getName());
                    }
                    PlayerUtils.messagePlayer(P, "[" + aItemUnlocalName + "][" + aItemDisplayName + "] ");
                    if (aFluidContainerData.size() > 0) {
                        for (String s : aFluidContainerData) {
                            PlayerUtils.messagePlayer(P, "" + s);
                        }
                    }
                    if (!aOreDictNames.isEmpty()) {
                        PlayerUtils.messagePlayer(P, "" + aOreDictData);
                    }
                    if (aNbtString.length() > 0) {
                        PlayerUtils.messagePlayer(P, "" + aNbtString);
                    }
                } else {
                    PlayerUtils.messagePlayer(P, "No item held.");
                }
            }
        } else if (argString[0].toLowerCase().equals("fluid")) {
            if (argString.length > 1 && argString[1] != null && argString[1].length() > 0) {
                EntityPlayer P = CommandUtils.getPlayer(S);
                FluidStack aFluid = FluidUtils.getWildcardFluidStack(argString[1], 1);
                if (P != null && aFluid != null) {
                    PlayerUtils.messagePlayer(P, "Found fluid stack: " + FluidRegistry.getFluidName((FluidStack)aFluid));
                } else if (P != null && aFluid == null) {
                    PlayerUtils.messagePlayer(P, "Could not find any fluids.");
                }
            }
        } else if (argString[0].toLowerCase().equals("item")) {
            if (argString.length > 1 && argString[1] != null && argString[1].length() > 0) {
                EntityPlayer P = CommandUtils.getPlayer(S);
                ItemStack aTest = ItemUtils.getItemStackFromFQRN(argString[1], 1);
                if (P != null && aTest != null) {
                    PlayerUtils.messagePlayer(P, "Found fluid stack: " + ItemUtils.getItemName(aTest));
                } else if (P != null && aTest == null) {
                    PlayerUtils.messagePlayer(P, "Could not find valid item.");
                }
            }
        } else {
            EntityPlayer P = CommandUtils.getPlayer(S);
            PlayerUtils.messagePlayer(P, "Invalid command, use '?' as an argument for help.'");
        }
    }

    public boolean func_71519_b(ICommandSender var1) {
        return var1 != null && CommandUtils.getPlayer(var1) != null;
    }

    public List<?> func_71516_a(ICommandSender var1, String[] var2) {
        ArrayList<String> aTabCompletes = new ArrayList<String>();
        aTabCompletes.add("?");
        aTabCompletes.add("logging");
        aTabCompletes.add("debug");
        aTabCompletes.add("hand");
        aTabCompletes.add("fluid");
        return aTabCompletes;
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return false;
    }

    public boolean playerUsesCommand(World W, EntityPlayer P, int cost) {
        return true;
    }

    public static String tryIterateNBTData(ItemStack aStack) {
        try {
            AutoMap<String> aItemDataTags = new AutoMap<String>();
            NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
            if (aNBT != null && !aNBT.func_82582_d()) {
                Map mInternalMap = (Map)ReflectionUtils.getField(aNBT, "tagMap");
                if (mInternalMap != null) {
                    for (Map.Entry e : mInternalMap.entrySet()) {
                        aItemDataTags.add(e.getKey().toString() + ":" + e.getValue());
                    }
                    boolean a = false;
                    String data = "";
                    for (String tag : aItemDataTags) {
                        data = data + tag + ", ";
                    }
                    if (data.endsWith(", ")) {
                        data = data.substring(0, data.length() - 2);
                    }
                    return data;
                }
                Logger.INFO("Data map reflected from NBTTagCompound was not valid.");
                return "Bad NBT";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }
}

