/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.minecraft;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.FakeBlockPos;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class FakeWorld
implements IBlockAccess {
    public static HashMap<String, FakeBlockPos> mStaticFakeWorldData;
    public HashMap<String, FakeBlockPos> mFakeWorldData = new HashMap();
    private int aWorldSize = 99;
    private final int aDistanceFromOrigin;
    private final int aWorldHeight;

    public FakeWorld() {
        this(99);
    }

    public FakeWorld(int aSize) {
        if (MathUtils.isNumberEven(aSize)) {
            ++aSize;
        }
        this.aWorldSize = aSize;
        this.aDistanceFromOrigin = (this.aWorldSize - 1) / 2;
        this.aWorldHeight = this.aDistanceFromOrigin >= 255 ? 255 : this.aDistanceFromOrigin;
        Logger.WARNING("Created a Fake World with data:");
        Logger.WARNING("World Size: " + this.aWorldSize);
        Logger.WARNING("Distance from Origin in each dir: " + this.aDistanceFromOrigin);
        Logger.WARNING("World Height: " + this.aWorldHeight);
        this.init();
    }

    public void init() {
        this.mFakeWorldData = new HashMap();
    }

    public FakeBlockPos getBlockAtCoords(int x, int y, int z) {
        String S = "" + x + "@" + y + "@" + z;
        FakeBlockPos aBlock = this.mFakeWorldData.get(S);
        if (aBlock == null) {
            return new FakeBlockPos(x, y, z, Blocks.field_150350_a, 0);
        }
        return aBlock;
    }

    public void setBlockAtCoords(int x, int y, int z, Block aBlock, int aMeta) {
        FakeBlockPos aTempPos = new FakeBlockPos(x, y, z, aBlock, aMeta);
        Logger.WARNING("Setting " + x + ", " + y + ", " + z + " to " + aBlock.func_149732_F() + ":" + aMeta);
        this.mFakeWorldData.put(aTempPos.getLocationString(), aTempPos);
    }

    public AutoMap<ItemStack> getAllBlocksStoredInFakeWorld() {
        AutoMap<ItemStack> aOutput = new AutoMap<ItemStack>();
        for (FakeBlockPos aPos : this.mFakeWorldData.values()) {
            ItemStack aTempStack;
            if (aPos == null || aPos.getBlockAtPos() == Blocks.field_150350_a || !ItemUtils.checkForInvalidItems(aTempStack = ItemUtils.simpleMetaStack(aPos.getBlockAtPos(), aPos.getMetaAtPos(), 1))) continue;
            aOutput.put(aTempStack);
        }
        return aOutput;
    }

    public Block func_147439_a(int x, int y, int z) {
        FakeBlockPos aPos = this.getBlockAtCoords(x, y, z);
        return aPos.getBlockAtPos();
    }

    public boolean func_147437_c(int x, int y, int z) {
        Block aBlock = this.func_147439_a(x, y, z);
        return aBlock == Blocks.field_150350_a || aBlock.func_149688_o() == Material.field_151579_a;
    }

    public TileEntity func_147438_o(int p_147438_1_, int p_147438_2_, int p_147438_3_) {
        return null;
    }

    public int func_72802_i(int p_72802_1_, int p_72802_2_, int p_72802_3_, int p_72802_4_) {
        return 0;
    }

    public int func_72805_g(int x, int y, int z) {
        return this.getBlockAtCoords(x, y, z).getMetaAtPos();
    }

    public int func_72879_k(int p_72879_1_, int p_72879_2_, int p_72879_3_, int p_72879_4_) {
        return 0;
    }

    public BiomeGenBase func_72807_a(int p_72807_1_, int p_72807_2_) {
        return BiomeGenBase.field_76772_c;
    }

    public int func_72800_K() {
        return this.aWorldHeight;
    }

    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        return !this.func_147437_c(x, y, z);
    }
}

