/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.data;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;

public abstract class ConcurrentSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final long serialVersionUID = -6761513279741915432L;
    private final ConcurrentMap<Integer, E> mInternalMap;
    private int mInternalID = 0;

    public ConcurrentSet(ConcurrentMap<Integer, E> aMap) {
        this.mInternalMap = aMap;
    }

    @Override
    public int size() {
        return this.mInternalMap.size();
    }

    @Override
    public boolean contains(Object o) {
        return this.mInternalMap.containsKey(o);
    }

    @Override
    public boolean add(E o) {
        return this.mInternalMap.putIfAbsent(this.mInternalID++, o) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.mInternalMap.remove(o) != null;
    }

    @Override
    public void clear() {
        this.mInternalID = 0;
        this.mInternalMap.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mInternalMap.values().iterator();
    }
}

