/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import net.minecraftforge.fluids.FluidStack;

public class GasSpargingRecipe
implements Comparable<GasSpargingRecipe> {
    public final FluidStack mInputGas;
    public final FluidStack mInputSpentFuel;
    public final FluidStack mOutputSpargedFuel;
    public final int[] mMaxOutputQuantity;
    public final FluidStack[] mFluidInputs;
    public final FluidStack[] mFluidOutputs;
    public final int mDuration;
    public final int mEUt;

    public GasSpargingRecipe(FluidStack aSpargeGas, FluidStack aSpentFuel, FluidStack aSpargedFuel, FluidStack[] aOutputs, int[] aMaxOutputQuantity) {
        this.mInputGas = aSpargeGas;
        this.mInputSpentFuel = aSpentFuel;
        this.mOutputSpargedFuel = aSpargedFuel;
        this.mFluidInputs = new FluidStack[]{this.mInputGas, this.mInputSpentFuel};
        aOutputs = ArrayUtils.insertElementAtIndex(aOutputs, 0, aSpargeGas);
        aOutputs = ArrayUtils.insertElementAtIndex(aOutputs, 1, aSpargedFuel);
        this.mFluidOutputs = aOutputs;
        this.mMaxOutputQuantity = aMaxOutputQuantity;
        this.mDuration = 500;
        this.mEUt = MaterialUtils.getVoltageForTier(5);
    }

    public boolean equals(Object o) {
        if (o instanceof GasSpargingRecipe) {
            GasSpargingRecipe i = (GasSpargingRecipe)o;
            if (this.mInputGas.equals((Object)i.mInputGas) && this.mInputSpentFuel.equals((Object)i.mInputSpentFuel)) {
                return true;
            }
        }
        return false;
    }

    public int getMaxOutput(int aIndex) {
        if (aIndex == 0) {
            return this.mInputGas.amount * 100;
        }
        if (aIndex == 1) {
            return this.mOutputSpargedFuel.amount * 100;
        }
        if ((aIndex -= 2) < 0 || aIndex >= this.mMaxOutputQuantity.length) {
            return 10000;
        }
        return this.mMaxOutputQuantity[aIndex];
    }

    public boolean isValid() {
        return this.mInputGas != null && this.mInputGas.amount > 0 && this.mInputSpentFuel != null && this.mInputSpentFuel.amount > 0 && this.mFluidOutputs != null && this.mFluidOutputs.length >= 1 && this.mMaxOutputQuantity != null && this.mMaxOutputQuantity.length >= 1 && this.mFluidOutputs.length == this.mMaxOutputQuantity.length;
    }

    public boolean containsInputs(FluidStack aSpargeGas, FluidStack aSpentFuel) {
        return aSpargeGas != null && aSpargeGas.getFluid().equals(this.mInputGas.getFluid()) && aSpentFuel != null && aSpentFuel.getFluid().equals(this.mInputSpentFuel.getFluid());
    }

    @Override
    public int compareTo(GasSpargingRecipe o) {
        if (o.mFluidOutputs.length > this.mFluidOutputs.length) {
            return 1;
        }
        if (o.mFluidOutputs.length == this.mFluidOutputs.length) {
            return 0;
        }
        return -1;
    }

    public String[] getRecipeInfo() {
        AutoMap<String> result = new AutoMap<String>();
        result.put("Input " + ItemUtils.getArrayStackNames(this.mFluidInputs));
        result.put("Output " + ItemUtils.getArrayStackNames(this.mFluidOutputs));
        result.put("Duration: " + this.mDuration);
        result.put("EU/t: " + this.mEUt);
        String[] s = (String[])result.toArray();
        return s;
    }
}

