/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.api.objects.GTPP_CopiedBlockTexture;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class TAE {
    public static int gtPPLastUsedIndex = 64;
    public static int secondaryIndex = 0;
    public static HashMap<Integer, GTPP_CopiedBlockTexture> mTAE = new HashMap();
    private static final HashSet<Integer> mFreeSlots = new HashSet(64);

    public static boolean registerTexture(int aPage, int aID, GTPP_CopiedBlockTexture GTPP_CopiedBlockTexture2) {
        int aRealID = aID + aPage * 16;
        return TAE.registerTexture(64 + aRealID, GTPP_CopiedBlockTexture2);
    }

    public static boolean registerTexture(int aID, GTPP_CopiedBlockTexture GTPP_CopiedBlockTexture2) {
        if (mFreeSlots.contains(aID)) {
            mFreeSlots.remove(aID);
            mTAE.put(aID, GTPP_CopiedBlockTexture2);
            return true;
        }
        CORE.crash("Tried to register texture with ID " + aID + " to TAE, but it is already in use.");
        return false;
    }

    public static void finalizeTAE() {
        String aFreeSpaces = "";
        String aPageAndSlotFree = "";
        AutoMap<Integer> aTemp = new AutoMap<Integer>((Set<Integer>)mFreeSlots);
        for (int i = 0; i < mFreeSlots.size(); ++i) {
            int j = aTemp.get(i);
            aFreeSpaces = aFreeSpaces + j;
            aPageAndSlotFree = aPageAndSlotFree + TAE.getPageFromIndex(j);
            if (i == mFreeSlots.size() - 1) continue;
            aFreeSpaces = aFreeSpaces + ", ";
            aPageAndSlotFree = aPageAndSlotFree + ", ";
        }
        Logger.INFO("Free Indexes within TAE: " + aFreeSpaces);
        Logger.INFO("Free Page slots within TAE: " + aPageAndSlotFree);
        Logger.INFO("Filling them with ERROR textures.");
        for (int aFreeSlot : aTemp.values()) {
            TAE.registerTexture(aFreeSlot, new GTPP_CopiedBlockTexture(ModBlocks.blockCasingsTieredGTPP, 1, 15));
        }
        Logger.INFO("Finalising TAE.");
        for (int aKeyTae : mTAE.keySet()) {
            Textures.BlockIcons.setCasingTextureForId((int)aKeyTae, (ITexture)((ITexture)mTAE.get(aKeyTae)));
        }
        Logger.INFO("Finalised TAE.");
    }

    private static boolean registerTextures(GTPP_CopiedBlockTexture GTPP_CopiedBlockTexture2) {
        block4: {
            try {
                Logger.INFO("[TAE} Registering Texture, Last used casing ID is " + gtPPLastUsedIndex + ".");
                if (gtPPLastUsedIndex >= 128) {
                    ITexture[][] h;
                    Field x = ReflectionUtils.getField(Textures.BlockIcons.class, "casingTexturePages");
                    if (x != null && (h = (ITexture[][])x.get(null)) != null) {
                        h[64][TAE.secondaryIndex++] = GTPP_CopiedBlockTexture2;
                        x.set(null, h);
                        Logger.INFO("[TAE} Registered Texture with ID " + (secondaryIndex - 1) + " in secondary index.");
                        return true;
                    }
                    break block4;
                }
                Textures.BlockIcons.setCasingTextureForId((int)gtPPLastUsedIndex, (ITexture)GTPP_CopiedBlockTexture2);
                Logger.INFO("[TAE} Registered Texture with ID " + gtPPLastUsedIndex + " in main index.");
                ++gtPPLastUsedIndex;
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Logger.INFO("[TAE} Failed to register texture, Last used casing ID is " + gtPPLastUsedIndex + ".");
        return false;
    }

    public static ITexture getTexture(int index) {
        if (gtPPLastUsedIndex >= 128) {
            return Textures.BlockIcons.getCasingTextureForId((int)(8192 + index));
        }
        return Textures.BlockIcons.getCasingTextureForId((int)(64 + index));
    }

    public static int GTPP_INDEX(int ID) {
        if (ID >= 64 && gtPPLastUsedIndex >= 128) {
            return 128 + ID;
        }
        return 64 + ID;
    }

    public static int getIndexFromPage(int page, int blockMeta) {
        int id = 64;
        id += page == 0 ? 0 : (page == 1 ? 16 : (page == 2 ? 32 : (page == 3 ? 48 : (page == 4 ? 64 : 0))));
        return id += blockMeta;
    }

    public static String getPageFromIndex(int aIndex) {
        int aPage = 0;
        int aSlot = 0;
        int aAdjustedIndex = aIndex > 64 ? aIndex - 64 : aIndex;
        aPage = aAdjustedIndex / 16;
        aSlot = aAdjustedIndex - 16 * aPage;
        return "[" + aIndex + " | " + aPage + ", " + aSlot + "]";
    }

    static {
        for (int i = 64; i < 128; ++i) {
            mFreeSlots.add(i);
        }
        Logger.INFO("Initialising TAE.");
    }
}

