/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.blocks;

import forestry.core.blocks.IMachineProperties;
import forestry.core.tiles.TileForestry;
import forestry.mail.tiles.TileMailbox;
import forestry.mail.tiles.TileStampCollector;
import forestry.mail.tiles.TileTrader;
import java.util.Locale;
import org.apache.commons.lang3.text.WordUtils;

public enum BlockMailType implements IMachineProperties
{
    MAILBOX(TileMailbox.class),
    TRADESTATION(TileTrader.class),
    PHILATELIST(TileStampCollector.class);

    public static final BlockMailType[] VALUES;
    private final String teIdent;
    private final Class<? extends TileForestry> teClass;

    private BlockMailType(Class<? extends TileForestry> teClass) {
        String name = this.toString().toLowerCase(Locale.ENGLISH);
        this.teIdent = "forestry." + WordUtils.capitalize((String)name);
        this.teClass = teClass;
    }

    @Override
    public int getMeta() {
        return this.ordinal();
    }

    @Override
    public String getTeIdent() {
        return this.teIdent;
    }

    @Override
    public Class<? extends TileForestry> getTeClass() {
        return this.teClass;
    }

    static {
        VALUES = BlockMailType.values();
    }
}

