/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.render.IconProviderWood;
import forestry.arboriculture.tiles.TileWood;
import forestry.core.render.ParticleHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockArbStairs
extends BlockStairs
implements IWoodTyped,
ITileEntityProvider {
    private final ParticleHelper.Callback particleCallback;
    private final boolean fireproof;
    private final ThreadLocal<ArrayList<ItemStack>> drops = new ThreadLocal();

    public BlockArbStairs(Block par2Block, boolean fireproof) {
        super(par2Block, 0);
        this.fireproof = fireproof;
        this.func_149647_a(Tabs.tabArboriculture);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
        this.particleCallback = new ParticleHelper.DefaultCallback((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (EnumWoodType woodType : EnumWoodType.VALUES) {
            list.add(TreeManager.woodItemAccess.getStairs(woodType, this.fireproof));
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer playerProfile) {
        this.drops.set(TileWood.getDrops(this, world, x, y, z));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = this.drops.get();
        this.drops.remove();
        if (ret == null) {
            ret = TileWood.getDrops(this, world, x, y, z);
        }
        return ret;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return TileWood.getPickBlock((Block)this, (IBlockAccess)world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        IconProviderWood.registerIcons(register);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return IconProviderWood.getPlankIcon(EnumWoodType.LARCH);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileWood wood = TileWood.getWoodTile(world, x, y, z);
        EnumWoodType woodType = wood.getWoodType();
        return IconProviderWood.getPlankIcon(woodType);
    }

    public boolean func_149710_n() {
        return true;
    }

    @Override
    public String getBlockKind() {
        return "stairs";
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileWood();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return ParticleHelper.addHitEffects(worldObj, (Block)this, target, effectRenderer, this.particleCallback);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return ParticleHelper.addDestroyEffects(worldObj, (Block)this, x, y, z, meta, effectRenderer, this.particleCallback);
    }
}

