/*
 * Decompiled with CFR 0.152.
 */
package emt.gthandler.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import emt.gthandler.common.items.EMT_CasingBlock;
import emt.gthandler.common.loader.EMT_RecipeAdder;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class DE_Fusion_Crafter
extends GT_MetaTileEntity_EnhancedMultiBlockBase<DE_Fusion_Crafter> {
    private static final int CASING_INDEX = 191;
    private int mTierCasing = 0;
    private int mFusionTierCasing = 0;
    private int mCasing = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final List<Pair<Block, Integer>> fusionCasingTiers = Arrays.asList(Pair.of((Object)GregTech_API.sBlockCasings4, (Object)6), Pair.of((Object)GregTech_API.sBlockCasings4, (Object)8));
    private static final List<Pair<Block, Integer>> coreTiers = Arrays.asList(Pair.of((Object)EMT_CasingBlock.EMT_GT_BLOCKS[0], (Object)8), Pair.of((Object)EMT_CasingBlock.EMT_GT_BLOCKS[0], (Object)9), Pair.of((Object)EMT_CasingBlock.EMT_GT_BLOCKS[0], (Object)10), Pair.of((Object)EMT_CasingBlock.EMT_GT_BLOCKS[0], (Object)11), Pair.of((Object)EMT_CasingBlock.EMT_GT_BLOCKS[0], (Object)12));
    private static final IStructureDefinition<DE_Fusion_Crafter> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"nnnnn", "nnnnn", "nnnnn", "nnnnn", "nnnnn"}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"RRRRR", "R F R", "RFfFR", "R F R", "RRRRR"}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"RRRRR", "R F R", "RFfFR", "R F R", "RRRRR"}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"NN~NN", "NNNNN", "NNNNN", "NNNNN", "NNNNN"}})).addElement('N', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(e -> ++e.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)EMT_CasingBlock.EMT_GT_BLOCKS[0], (int)7)), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, (int)191, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, (int)191, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, (int)191, (int)1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, (int)191, (int)1)})).addElement('n', StructureUtility.onElementPass(e -> ++e.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)EMT_CasingBlock.EMT_GT_BLOCKS[0], (int)7))).addElement('f', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)7)).addElement('F', StructureUtility.ofBlocksTiered((b, m) -> {
        if (b != GregTech_API.sBlockCasings4 || m != 6 && m != 8) {
            return -2;
        }
        return m == 6 ? 1 : 2;
    }, fusionCasingTiers, (Object)-1, (e, i) -> {
        e.mFusionTierCasing = i;
    }, e -> e.mFusionTierCasing)).addElement('R', StructureUtility.ofBlocksTiered((b, m) -> {
        if (b != EMT_CasingBlock.EMT_GT_BLOCKS[0] || m < 8 || m > 12) {
            return -2;
        }
        return m - 7;
    }, coreTiers, (Object)-1, (e, i) -> {
        e.mTierCasing = i;
    }, e -> e.mTierCasing)).build();

    public DE_Fusion_Crafter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public DE_Fusion_Crafter(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new DE_Fusion_Crafter(this.mName);
    }

    public IStructureDefinition<DE_Fusion_Crafter> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mTierCasing = -1;
        this.mFusionTierCasing = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 9, 0)) {
            return false;
        }
        if (this.mCasing < 19) {
            return false;
        }
        if (this.mTierCasing == -2 || this.mFusionTierCasing == -2) {
            return false;
        }
        if (this.mTierCasing > 3 && this.mFusionTierCasing < 2) {
            return false;
        }
        return this.mMaintenanceHatches.size() == 1;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Fusion Crafter").addInfo("Controller Block for the Draconic Evolution Fusion Crafter").addInfo("Machine can be overclocked by using casings above the recipe tier:").addInfo("Recipe time is divided by number of tiers above the recipe").addInfo("Normal EU OC still applies !").addInfo("To see the structure, use a " + EnumChatFormatting.BLUE + "Tec" + EnumChatFormatting.DARK_BLUE + "Tech" + EnumChatFormatting.GRAY + " structure hologram on the Controller!").addSeparator().beginStructureBlock(5, 10, 5, false).addController("Front bottom center").addCasingInfo("Naquadah Alloy Fusion Casing", 19).addOtherStructurePart("Fusion Coil Block", "Center pillar").addOtherStructurePart("Fusion Machine Casing", "Touching Fusion Coil Block at every side").addOtherStructurePart("Tiered Fusion Casing", "Rings (5x5 hollow) at layer 4 and 7").addStructureInfo("Bloody Ichorium for tier 1, Draconium for tier 2, etc").addStructureInfo("To use tier 3 + you have to use fusion casing MK II").addInputBus("Any bottom casing", new int[]{1}).addInputHatch("Any bottom casing", new int[]{1}).addOutputBus("Any bottom casing", new int[]{1}).addOutputHatch("Any bottom casing", new int[]{1}).addEnergyHatch("Any bottom casing", new int[]{1}).addMaintenanceHatch("Any bottom casing", new int[]{1}).toolTipFinisher("Electro-Magic Tools");
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TELEPORTER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TELEPORTER_GLOW}).extFacing().glow().build()};
        }
        if (aActive) {
            return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_MAGIC}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_MAGIC_GLOW}).extFacing().glow().build()};
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return EMT_RecipeAdder.sFusionCraftingRecipes;
    }

    public boolean checkRecipe(ItemStack aStack) {
        ItemStack[] tInputs = this.getCompactedInputs();
        FluidStack[] tFluids = this.getCompactedFluids();
        if (tInputs.length > 0) {
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
            GT_Recipe tRecipe = EMT_RecipeAdder.sFusionCraftingRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            if (tRecipe != null && this.mTierCasing >= tRecipe.mSpecialValue && tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 2, tVoltage);
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.mMaxProgresstime /= this.mTierCasing - tRecipe.mSpecialValue + 1;
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
                this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 9, 0);
    }
}

