/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.driver;

import li.cil.oc.api.Network;
import li.cil.oc.api.component.RackMountable;
import li.cil.oc.api.internal.Rack;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import pl.asie.computronics.oc.driver.RackMountableWithComponentConnector;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.OCUtils;

public class DriverBoardSwitch
extends RackMountableWithComponentConnector {
    protected final boolean[] switches = new boolean[4];
    protected final Rack host;
    protected boolean needsUpdate = false;
    protected static final int[] pixToSwitch = new int[]{-1, 0, 0, -1, 1, 1, -1, -1, 2, 2, -1, 3, 3, -1, -1};

    public DriverBoardSwitch(Rack host) {
        this.host = host;
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("switch_board", Visibility.Network).withConnector().create());
    }

    public NBTTagCompound getData() {
        NBTTagCompound tag = new NBTTagCompound();
        byte switchData = 0;
        for (int i = 0; i < this.switches.length; ++i) {
            switchData = (byte)(switchData | (this.switches[i] ? 1 : 0) << i);
        }
        tag.func_74774_a("s", switchData);
        return tag;
    }

    @Override
    public boolean onActivate(EntityPlayer player, float hitX, float hitY) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        int xPix = (int)(hitX * 14.0f);
        int yPix = (int)(hitY * 3.0f);
        if (yPix == 1 && xPix > 0 && xPix < pixToSwitch.length && pixToSwitch[xPix] >= 0) {
            this.flipSwitch(pixToSwitch[xPix]);
        }
        return true;
    }

    protected void flipSwitch(int i) {
        this.switches[i] = !this.switches[i];
        this.node.sendToReachable("computer.signal", new Object[]{"switch_flipped", i + 1, this.switches[i]});
        this.needsUpdate = true;
    }

    public boolean canUpdate() {
        return true;
    }

    public void update() {
        super.update();
        for (int i = 0; i < this.switches.length; ++i) {
            if (!this.switches[i] || this.node.tryChangeBuffer(-Config.SWITCH_BOARD_MAINTENANCE_COST)) continue;
            this.setActive(i, false, false);
        }
        if (this.needsUpdate) {
            this.host.markChanged(this.host.indexOfMountable((RackMountable)this));
            this.needsUpdate = false;
        }
    }

    public Boolean isActive(int index) {
        return index >= 0 && index < this.switches.length ? Boolean.valueOf(this.switches[index]) : null;
    }

    public boolean isActiveB(int index) {
        Boolean active = this.isActive(index);
        return active != null ? active : false;
    }

    private void setActive(int index, boolean active, boolean signal) {
        if (this.switches[index] != active) {
            this.switches[index] = active;
            if (signal) {
                this.node.sendToReachable("computer.signal", new Object[]{"switch_flipped", index + 1, this.switches[index]});
            }
            this.needsUpdate = true;
        }
    }

    private int checkSwitch(int index) {
        Boolean active = this.isActive(index - 1);
        if (active == null) {
            throw new IllegalArgumentException("index out of range: " + index);
        }
        return index - 1;
    }

    @Callback(doc="function(index:number, active:boolean):boolean; Activates or deactivates the specified switch. Returns true if the state changed.", direct=true)
    public Object[] setActive(Context context, Arguments args) {
        boolean active;
        int index = this.checkSwitch(args.checkInteger(0));
        if (this.switches[index] != (active = args.checkBoolean(1))) {
            this.setActive(index, active, true);
            return new Object[]{true};
        }
        return new Object[]{false};
    }

    @Callback(doc="function(index:number):boolean; Returns true if the switch at the specified position is currently active", direct=true)
    public Object[] isActive(Context context, Arguments args) {
        return new Object[]{this.isActiveB(this.checkSwitch(args.checkInteger(0)))};
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        if (tag.func_74764_b("s")) {
            byte switchData = tag.func_74771_c("s");
            for (int i = 0; i < this.switches.length; ++i) {
                this.switches[i] = (switchData >> i & 1) == 1;
            }
        }
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        byte switchData = 0;
        for (int i = 0; i < this.switches.length; ++i) {
            switchData = (byte)(switchData | (this.switches[i] ? 1 : 0) << i);
        }
        tag.func_74774_a("s", switchData);
    }

    @Override
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("input", "Switch board", "Soluna Technologies", "Clickety-Clack Q3", new String[0]);
    }
}

