/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.item;

import java.util.List;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EntityLocomotiveElectric;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.railcraft.tile.TileLocomotiveRelay;
import pl.asie.computronics.oc.manual.IItemWithPrefix;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.StringUtil;

public class ItemRelaySensor
extends Item
implements IItemWithPrefix {
    private IIcon icon_off;
    private IIcon icon_on;

    public ItemRelaySensor() {
        this.func_77637_a(Computronics.tab);
        this.func_77627_a(false);
        this.func_77655_b("computronics.relaySensor");
        this.func_111206_d("computronics:relay_sensor_off");
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77664_n();
        this.setNoRepair();
    }

    public void func_94581_a(IIconRegister ir) {
        this.icon_off = ir.func_94245_a("computronics:relay_sensor_off");
        this.icon_on = ir.func_94245_a("computronics:relay_sensor_on");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("bound")) {
            return this.icon_on;
        }
        return this.icon_off;
    }

    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileLocomotiveRelay && !player.field_70170_p.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (stack.func_77942_o()) {
                NBTTagCompound data = stack.func_77978_p();
                data.func_74768_a("relayX", x);
                data.func_74768_a("relayY", y);
                data.func_74768_a("relayZ", z);
                data.func_74757_a("bound", true);
                stack.func_77982_d(data);
                player.func_71038_i();
                return true;
            }
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player.func_70093_af() && entity != null) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("bound") && !player.field_70170_p.field_72995_K) {
                NBTTagCompound data = stack.func_77978_p();
                int x = data.func_74762_e("relayX");
                int y = data.func_74762_e("relayY");
                int z = data.func_74762_e("relayZ");
                if (entity instanceof EntityLocomotiveElectric) {
                    if (!player.field_70170_p.func_72899_e(x, y, z)) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.computronics.sensor.noRelayDetected", new Object[0]));
                        return true;
                    }
                    if (entity.field_70170_p.func_147438_o(x, y, z) != null && entity.field_70170_p.func_147438_o(x, y, z) instanceof TileLocomotiveRelay) {
                        TileLocomotiveRelay relay = (TileLocomotiveRelay)entity.field_70170_p.func_147438_o(x, y, z);
                        EntityLocomotiveElectric loco = (EntityLocomotiveElectric)entity;
                        if (loco.field_71093_bK == relay.func_145831_w().field_73011_w.field_76574_g) {
                            if (loco.func_70092_e((double)relay.field_145851_c, (double)relay.field_145848_d, (double)relay.field_145849_e) <= Config.LOCOMOTIVE_RELAY_RANGE * Config.LOCOMOTIVE_RELAY_RANGE) {
                                relay.setLocomotive(loco);
                                player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.computronics.sensor.bound", new Object[0]));
                                player.func_71038_i();
                                player.func_71028_bD();
                            } else {
                                player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.computronics.sensor.tooFarAway", new Object[0]));
                            }
                        } else {
                            player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.computronics.sensor.wrongDim", new Object[0]));
                        }
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.computronics.sensor.noRelay", new Object[0]));
                    }
                } else if (entity instanceof EntityLocomotive) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.computronics.sensor.wrongLoco", new Object[0]));
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List text, boolean par4) {
        String[] local;
        String descKey;
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("bound")) {
            NBTTagCompound data = stack.func_77978_p();
            int x = data.func_74762_e("relayX");
            int y = data.func_74762_e("relayY");
            int z = data.func_74762_e("relayZ");
            text.add(EnumChatFormatting.AQUA + StringUtil.localizeAndFormat("tooltip.computronics.sensor.bound", String.valueOf(x), String.valueOf(y), String.valueOf(z)));
            descKey = "tooltip.computronics.sensor.desc2";
        } else {
            descKey = "tooltip.computronics.sensor.desc1";
        }
        for (String s : local = StringUtil.localize(descKey).split("\n")) {
            text.add(EnumChatFormatting.GRAY + s);
        }
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return "relay_sensor";
    }

    @Override
    public String getPrefix(ItemStack stack) {
        return "railcraft/";
    }
}

