/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.nbt;

import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public final class NBTTagSmartByteArray
extends NBTTagByteArray {
    private _ByteArrayOutputStream arrayout;
    private DataOutputStream dataout;

    public NBTTagSmartByteArray() {
        this(64);
    }

    public NBTTagSmartByteArray(int n) {
        super(null);
        this.arrayout = new _ByteArrayOutputStream(n);
        this.dataout = new DataOutputStream(this.arrayout);
    }

    public NBTTagSmartByteArray addString(String string) {
        try {
            this.dataout.writeUTF(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addUUID(UUID uUID) {
        try {
            this.dataout.writeLong(uUID.getMostSignificantBits());
            this.dataout.writeLong(uUID.getLeastSignificantBits());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addLong(long l) {
        try {
            this.dataout.writeLong(l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addInt(int n) {
        try {
            this.dataout.writeInt(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addVarInt(int n) {
        try {
            int n2 = 0;
            if (n < 0) {
                n2 |= 0x40;
                n ^= 0xFFFFFFFF;
            }
            if ((n & 0xFFFFFFC0) != 0) {
                n2 |= 0x80;
            }
            this.dataout.writeByte(n2 | n & 0x3F);
            n >>>= 6;
            while (n != 0) {
                this.dataout.writeByte(n & 0x7F | ((n & 0xFFFFFF80) != 0 ? 128 : 0));
                n >>>= 7;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addBool(boolean bl) {
        try {
            this.dataout.writeBoolean(bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addByte(byte by) {
        try {
            this.dataout.writeByte(by);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addByte(int n) {
        return this.addByte((byte)n);
    }

    public NBTTagSmartByteArray addShort(short s) {
        try {
            this.dataout.writeShort(s);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addShort(int n) {
        return this.addShort((short)n);
    }

    public NBTTagSmartByteArray addByteArray(byte[] byArray) {
        try {
            this.dataout.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addFloat(float f) {
        try {
            this.dataout.writeFloat(f);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addItemStack(ItemStack itemStack) {
        try {
            if (itemStack == null) {
                this.addShort(-1);
            } else {
                this.addShort(Item.func_150891_b((Item)itemStack.func_77973_b()));
                this.addByte(itemStack.field_77994_a);
                this.addShort(ItemHelper.getItemDamage(itemStack));
                this.addNBT(itemStack.field_77990_d);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public void addNBT(NBTTagCompound nBTTagCompound) throws IOException {
        if (nBTTagCompound == null) {
            this.addShort(-1);
        } else {
            byte[] byArray = CompressedStreamTools.func_74798_a((NBTTagCompound)nBTTagCompound);
            this.addShort((short)byArray.length);
            this.addByteArray(byArray);
        }
    }

    public NBTTagSmartByteArray addFluidStack(FluidStack fluidStack) {
        try {
            FluidHelper.writeFluidStackToPacket(fluidStack, this.dataout);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return this;
    }

    public NBTTagSmartByteArray addCoords(TileEntity tileEntity) {
        this.addInt(tileEntity.field_145851_c);
        this.addInt(tileEntity.field_145848_d);
        return this.addInt(tileEntity.field_145849_e);
    }

    public NBTTagSmartByteArray addCoords(int n, int n2, int n3) {
        this.addInt(n);
        this.addInt(n2);
        return this.addInt(n3);
    }

    public void func_74734_a(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.arrayout.size());
        dataOutput.write(this.arrayout.getByteArray(), 0, this.arrayout.size());
    }

    public String toString() {
        return "[" + this.arrayout.size() + " bytes]";
    }

    public NBTBase func_74737_b() {
        return new NBTTagByteArray(this.func_150292_c());
    }

    public boolean equals(Object object) {
        if (super.equals(object) && object.getClass() == NBTTagSmartByteArray.class) {
            NBTTagSmartByteArray nBTTagSmartByteArray = (NBTTagSmartByteArray)((Object)object);
            return nBTTagSmartByteArray.dataout.equals(this.dataout);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() ^ this.dataout.hashCode();
    }

    public byte[] func_150292_c() {
        return this.arrayout.toByteArray();
    }

    private class _ByteArrayOutputStream
    extends ByteArrayOutputStream {
        _ByteArrayOutputStream(int n) {
            super(n);
        }

        byte[] getByteArray() {
            return this.buf;
        }
    }
}

