/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.tileEntity;

import WayofTime.alchemicalWizardry.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;

public class TESpectralContainer
extends TileEntity {
    private ItemStack[] inv = new ItemStack[1];
    private int ticksRemaining = 0;

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        NBTTagList tagList = par1NBTTagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.ticksRemaining = par1NBTTagCompound.func_74762_e("ticksRemaining");
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        par1NBTTagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        par1NBTTagCompound.func_74768_a("ticksRemaining", this.ticksRemaining);
    }

    public void func_145845_h() {
        super.func_145845_h();
        --this.ticksRemaining;
        if (this.ticksRemaining <= 0) {
            this.returnContainedBlock();
        }
    }

    public static boolean createSpectralBlockAtLocation(World world, int x, int y, int z, int duration) {
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return false;
        }
        if (world.func_147438_o(x, y, z) == null || block instanceof IFluidBlock) {
            int meta = world.func_72805_g(x, y, z);
            ItemStack item = new ItemStack(block, 1, meta);
            world.func_147449_b(x, y, z, ModBlocks.blockSpectralContainer);
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TESpectralContainer) {
                ((TESpectralContainer)tile).setContainedItem(item);
                ((TESpectralContainer)tile).setDuration(duration);
                return true;
            }
        }
        return false;
    }

    public void setDuration(int dur) {
        this.ticksRemaining = dur;
    }

    public void resetDuration(int dur) {
        if (this.ticksRemaining < dur) {
            this.ticksRemaining = dur;
        }
    }

    public void setContainedItem(ItemStack item) {
        this.inv[0] = item;
    }

    public void returnContainedBlock() {
        ItemStack item = this.inv[0];
        if (item != null) {
            if (item.func_77973_b() instanceof ItemBlock) {
                Block block = ((ItemBlock)item.func_77973_b()).field_150939_a;
                int meta = item.func_77960_j();
                if (block != null) {
                    this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, block, meta, 6);
                }
            }
        } else {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

