/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.api2.utils.Tuple2;
import bq_standard.client.gui.editors.tasks.GuiEditTaskHunt;
import bq_standard.client.gui.tasks.PanelTaskHunt;
import bq_standard.tasks.base.TaskProgressableBase;
import bq_standard.tasks.factory.FactoryTaskHunt;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;

public class TaskHunt
extends TaskProgressableBase<Integer> {
    public String idName = "Zombie";
    public String damageType = "";
    public int required = 1;
    public boolean ignoreNBT = true;
    public boolean subtypes = true;
    public NBTTagCompound targetTags = new NBTTagCompound();

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.idName = nbt.func_74779_i("target");
        this.required = nbt.func_74762_e("required");
        this.subtypes = nbt.func_74767_n("subtypes");
        this.ignoreNBT = nbt.func_74767_n("ignoreNBT");
        this.targetTags = nbt.func_74775_l("targetNBT");
        this.damageType = nbt.func_74779_i("damageType");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("target", this.idName);
        nbt.func_74768_a("required", this.required);
        nbt.func_74757_a("subtypes", this.subtypes);
        nbt.func_74757_a("ignoreNBT", this.ignoreNBT);
        nbt.func_74782_a("targetNBT", (NBTBase)this.targetTags);
        nbt.func_74778_a("damageType", this.damageType);
        return nbt;
    }

    @Override
    public String getUnlocalisedName() {
        return "bq_standard.task.hunt";
    }

    @Override
    public ResourceLocation getFactoryID() {
        return FactoryTaskHunt.INSTANCE.getRegistryName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, Map.Entry<UUID, IQuest> quest) {
        return new PanelTaskHunt(rect, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, Map.Entry<UUID, IQuest> quest) {
        return new GuiEditTaskHunt(parent, quest, this);
    }

    @Override
    public Integer getUsersProgress(UUID uuid) {
        Integer n = (Integer)this.userProgress.get(uuid);
        return n == null ? 0 : n;
    }

    @Override
    public Integer readUserProgressFromNBT(NBTTagCompound nbt) {
        return nbt.func_74762_e("value");
    }

    @Override
    public void writeUserProgressToNBT(NBTTagCompound nbt, Integer progress) {
        nbt.func_74768_a("value", progress.intValue());
    }

    @Override
    public void detect(ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest) {
        List<Tuple2<UUID, Tuple2>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        progress.forEach(value -> {
            if ((Integer)value.func_76340_b() >= this.required) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        pInfo.markDirtyParty(quest.getKey());
    }

    public void onKilledByPlayer(ParticipantInfo pInfo, Map.Entry<UUID, IQuest> quest, EntityLivingBase entity, DamageSource source) {
        if (!(this.damageType.length() <= 0 || source != null && this.damageType.equalsIgnoreCase(source.field_76373_n))) {
            return;
        }
        Class<?> subject = entity.getClass();
        Class target = (Class)EntityList.field_75625_b.get(this.idName);
        String subjectID = EntityList.func_75621_b((Entity)entity);
        if (subjectID == null || target == null) {
            return;
        }
        if (this.subtypes && !target.isAssignableFrom(subject)) {
            return;
        }
        if (!this.subtypes && !subjectID.equals(this.idName)) {
            return;
        }
        NBTTagCompound subjectTags = new NBTTagCompound();
        entity.func_70039_c(subjectTags);
        if (!this.ignoreNBT && !ItemComparison.CompareNBTTag((NBTBase)this.targetTags, (NBTBase)subjectTags, true)) {
            return;
        }
        List<Tuple2<UUID, Tuple2>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        progress.forEach(value -> {
            if (this.isComplete((UUID)value.func_76341_a())) {
                return;
            }
            int np = Math.min(this.required, (Integer)value.func_76340_b() + 1);
            this.setUserProgress((UUID)value.func_76341_a(), np);
            if (np >= this.required) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        pInfo.markDirtyParty(quest.getKey());
    }

    @Override
    public List<String> getTextsForSearch() {
        return Collections.singletonList(this.idName);
    }
}

