/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasMinimum;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.themes.presets.PresetIcon;
import bq_standard.network.handlers.NetTaskCheckbox;
import bq_standard.tasks.TaskCheckbox;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;

public class PanelTaskCheckbox
extends CanvasMinimum {
    private final Map.Entry<UUID, IQuest> quest;
    private final TaskCheckbox task;
    private final IGuiRect initialRect;

    public PanelTaskCheckbox(IGuiRect rect, Map.Entry<UUID, IQuest> quest, TaskCheckbox task) {
        super(rect);
        this.quest = quest;
        this.task = task;
        this.initialRect = rect;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        boolean isComplete = this.task.isComplete(QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        final UUID questID = this.quest.getKey();
        final int taskID = this.quest.getValue().getTasks().getID(this.task);
        PanelButton btnCheck = new PanelButton(new GuiTransform(GuiAlign.TOP_LEFT, (this.initialRect.getWidth() - 32) / 2, 0, 32, 32, 0), -1, ""){

            @Override
            public void onButtonClick() {
                this.setIcon(PresetIcon.ICON_TICK.getTexture(), new GuiColorStatic(-16711936), 4);
                this.setActive(false);
                NetTaskCheckbox.requestClick(questID, taskID);
            }
        };
        btnCheck.setIcon(isComplete ? PresetIcon.ICON_TICK.getTexture() : PresetIcon.ICON_CROSS.getTexture(), new GuiColorStatic(isComplete ? -16711936 : -65536), 4);
        btnCheck.setActive(!isComplete);
        this.addPanel(btnCheck);
        this.recalcSizes();
    }
}

