/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing.tasks;

import betterquesting.api.placeholders.tasks.FactoryTaskPlaceholder;
import betterquesting.api.placeholders.tasks.TaskPlaceholder;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.registry.IFactory;
import betterquesting.api2.registry.IFactoryData;
import betterquesting.api2.registry.IRegistry;
import betterquesting.core.BetterQuesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class TaskRegistry
implements IRegistry<IFactoryData<ITask, NBTTagCompound>, ITask> {
    public static final TaskRegistry INSTANCE = new TaskRegistry();
    private final HashMap<ResourceLocation, IFactoryData<ITask, NBTTagCompound>> taskRegistry = new HashMap();

    @Override
    public void register(IFactoryData<ITask, NBTTagCompound> factory) {
        if (factory == null) {
            throw new NullPointerException("Tried to register null task");
        }
        if (factory.getRegistryName() == null) {
            throw new IllegalArgumentException("Tried to register a task with a null name: " + factory.getClass());
        }
        if (this.taskRegistry.containsKey(factory.getRegistryName()) || this.taskRegistry.containsValue(factory)) {
            throw new IllegalArgumentException("Cannot register dupliate task type: " + factory.getRegistryName());
        }
        this.taskRegistry.put(factory.getRegistryName(), factory);
    }

    @Override
    public IFactoryData<ITask, NBTTagCompound> getFactory(ResourceLocation registryName) {
        return this.taskRegistry.get(registryName);
    }

    @Override
    public List<IFactoryData<ITask, NBTTagCompound>> getAll() {
        return new ArrayList<IFactoryData<ITask, NBTTagCompound>>(this.taskRegistry.values());
    }

    @Override
    public ITask createNew(ResourceLocation registryName) {
        try {
            IFactory<TaskPlaceholder> factory = FactoryTaskPlaceholder.INSTANCE.getRegistryName().equals((Object)registryName) ? FactoryTaskPlaceholder.INSTANCE : this.getFactory(registryName);
            if (factory == null) {
                BetterQuesting.logger.log(Level.ERROR, "Tried to load missing task type '" + registryName + "'! Are you missing an expansion pack?");
                return null;
            }
            return factory.createNew();
        }
        catch (Exception e) {
            BetterQuesting.logger.log(Level.ERROR, "Unable to instatiate task: " + registryName, (Throwable)e);
            return null;
        }
    }
}

