/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.utils.Tuple2;
import betterquesting.core.BetterQuesting;
import betterquesting.handlers.SaveLoadHandler;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.network.handlers.NetChapterSync;
import betterquesting.questing.QuestLineDatabase;
import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

public class NetChapterEdit {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:chapter_edit");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetChapterEdit::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetChapterEdit::onClient);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendEdit(NBTTagCompound payload) {
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple2<NBTTagCompound, EntityPlayerMP> message) {
        EntityPlayerMP sender = message.func_76340_b();
        MinecraftServer server = sender.field_71133_b;
        if (server == null) {
            return;
        }
        boolean isOP = server.func_71203_ab().func_152596_g(sender.func_146103_bH());
        if (!isOP) {
            BetterQuesting.logger.log(Level.WARN, "Player " + sender.func_70005_c_() + " (UUID:" + QuestingAPI.getQuestingUUID((EntityPlayer)sender) + ") tried to edit chapters without OP permissions!");
            sender.func_146105_b((IChatComponent)new ChatComponentText(ChatFormatting.RED + "You need to be OP to edit quests!"));
            return;
        }
        NBTTagCompound tag = message.func_76341_a();
        int action = !message.func_76341_a().func_150297_b("action", 99) ? -1 : message.func_76341_a().func_74762_e("action");
        switch (action) {
            case 0: {
                NetChapterEdit.editChapters(tag.func_150295_c("data", 10));
                break;
            }
            case 1: {
                NetChapterEdit.deleteChapters(NBTConverter.UuidValueType.QUEST_LINE.readIds(tag, "questLineIDs"));
                break;
            }
            case 2: {
                NetChapterEdit.reorderChapters(NBTConverter.UuidValueType.QUEST_LINE.readIds(tag, "questLineIDs"));
                break;
            }
            case 3: {
                NetChapterEdit.createChapters(tag.func_150295_c("data", 10));
                break;
            }
            default: {
                BetterQuesting.logger.log(Level.ERROR, "Invalid chapter edit action '" + action + "'. Full payload:\n" + message.func_76341_a().toString());
            }
        }
    }

    private static void editChapters(NBTTagList data) {
        ArrayList<UUID> ids = new ArrayList<UUID>(data.func_74745_c());
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound entry = data.func_150305_b(i);
            UUID chapterID = NBTConverter.UuidValueType.QUEST_LINE.readId(entry);
            ids.add(chapterID);
            IQuestLine chapter = (IQuestLine)QuestLineDatabase.INSTANCE.get(chapterID);
            if (chapter == null) continue;
            chapter.readFromNBT((NBTBase)entry.func_74775_l("config"), false);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NetChapterSync.sendSync(null, ids);
    }

    private static void deleteChapters(Collection<UUID> chapterIDs) {
        for (UUID id : chapterIDs) {
            QuestLineDatabase.INSTANCE.remove(id);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("questLineIDs", (NBTBase)NBTConverter.UuidValueType.QUEST_LINE.writeIds(chapterIDs));
        payload.func_74768_a("action", 1);
        PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
    }

    private static void reorderChapters(List<UUID> chapterIDs) {
        for (int n = 0; n < chapterIDs.size(); ++n) {
            QuestLineDatabase.INSTANCE.setOrderIndex(chapterIDs.get(n), n);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74782_a("questLineIDs", (NBTBase)NBTConverter.UuidValueType.QUEST_LINE.writeIds(chapterIDs));
        payload.func_74768_a("action", 2);
        PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
    }

    private static void createChapters(NBTTagList data) {
        ArrayList<UUID> ids = new ArrayList<UUID>(data.func_74745_c());
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound entry = data.func_150305_b(i);
            Optional<UUID> chapterIDOptional = NBTConverter.UuidValueType.QUEST_LINE.tryReadId(entry);
            UUID chapterID = chapterIDOptional.isPresent() ? chapterIDOptional.get() : QuestLineDatabase.INSTANCE.generateKey();
            ids.add(chapterID);
            IQuestLine chapter = (IQuestLine)QuestLineDatabase.INSTANCE.get(chapterID);
            if (chapter == null) {
                chapter = QuestLineDatabase.INSTANCE.createNew(chapterID);
            }
            if (!entry.func_150297_b("config", 10)) continue;
            chapter.readFromNBT((NBTBase)entry.func_74775_l("config"), false);
        }
        SaveLoadHandler.INSTANCE.markDirty();
        NetChapterSync.sendSync(null, ids);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        int action = !message.func_150297_b("action", 99) ? -1 : message.func_74762_e("action");
        switch (action) {
            case 1: {
                for (UUID id : NBTConverter.UuidValueType.QUEST_LINE.readIds(message, "questLineIDs")) {
                    QuestLineDatabase.INSTANCE.remove(id);
                }
                MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.CHAPTER));
                break;
            }
            case 2: {
                List<UUID> chapterIDs = NBTConverter.UuidValueType.QUEST_LINE.readIds(message, "questLineIDs");
                for (int n = 0; n < chapterIDs.size(); ++n) {
                    QuestLineDatabase.INSTANCE.setOrderIndex(chapterIDs.get(n), n);
                }
                MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.CHAPTER));
                break;
            }
        }
    }
}

