/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.blocks;

import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.tasks.IFluidTask;
import betterquesting.api.questing.tasks.IItemTask;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.storage.QuestSettings;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileObservationStation
extends TileEntity {
    public UUID owner = null;
    private static final String NBT_KEY_OWNER = "owner";

    /*
     * WARNING - void declaration
     */
    public void func_145845_h() {
        void var7_9;
        if (this.owner == null || QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue() || this.field_145850_b == null || this.field_145850_b.field_72995_K || this.field_145850_b.func_82737_E() % 20L != 0L) {
            return;
        }
        EntityPlayerMP player = this.getPlayerByUUID(this.owner);
        if (player == null) {
            return;
        }
        ParticipantInfo pInfo = new ParticipantInfo((EntityPlayer)player);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
        int n = forgeDirectionArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            IFluidTank tank;
            FluidStack fluid;
            ForgeDirection side = forgeDirectionArray[var7_9];
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
            if (tile instanceof IInventory) {
                IInventory inventory = (IInventory)tile;
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack == null || 0 >= stack.field_77994_a) continue;
                    items.add(stack);
                }
            }
            if (tile instanceof IFluidTank && (fluid = (tank = (IFluidTank)tile).getFluid()) != null && 0 < fluid.amount) {
                fluids.add(fluid);
            }
            if (tile instanceof IFluidHandler) {
                IFluidHandler handler = (IFluidHandler)tile;
                for (FluidTankInfo tank2 : handler.getTankInfo(ForgeDirection.UNKNOWN)) {
                    FluidStack fluid2 = tank2.fluid;
                    if (fluid2 == null || 0 >= fluid2.amount) continue;
                    fluids.add(fluid2);
                }
            }
            ++var7_9;
        }
        if (items.isEmpty() && fluids.isEmpty()) {
            return;
        }
        IQuestDatabase questDB = QuestingAPI.getAPI(ApiReference.QUEST_DB);
        if (questDB == null) {
            return;
        }
        for (Map.Entry<UUID, IQuest> entry : questDB.filterKeys(pInfo.getSharedQuests()).entrySet()) {
            for (DBEntry taskEntry : ((IQuest)entry.getValue()).getTasks().getEntries()) {
                ITask task = (ITask)taskEntry.getValue();
                if (task instanceof IItemTask && !items.isEmpty()) {
                    ((IItemTask)task).retrieveItems(pInfo, entry, items.toArray(new ItemStack[0]));
                }
                if (!(task instanceof IFluidTask) || fluids.isEmpty()) continue;
                ((IFluidTask)task).retrieveFluids(pInfo, entry, fluids.toArray(new FluidStack[0]));
            }
        }
    }

    @Nullable
    private EntityPlayerMP getPlayerByUUID(UUID uuid) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server == null) {
            return null;
        }
        for (EntityPlayerMP player : server.func_71203_ab().field_72404_b) {
            if (!player.func_146103_bH().getId().equals(uuid)) continue;
            return player;
        }
        return null;
    }

    public void func_145839_a(@Nonnull NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (!nbt.func_150297_b(NBT_KEY_OWNER, 8)) {
            return;
        }
        try {
            this.owner = UUID.fromString(nbt.func_74779_i(NBT_KEY_OWNER));
        }
        catch (Exception ignored) {
            this.owner = null;
        }
    }

    public void func_145841_b(@Nonnull NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.owner == null) {
            return;
        }
        nbt.func_74778_a(NBT_KEY_OWNER, this.owner.toString());
    }
}

