/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.colors;

import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class GuiColorStatic
implements IGuiColor {
    private final int argb;

    public GuiColorStatic(int color) {
        this.argb = color;
    }

    public GuiColorStatic(int red, int green, int blue, int alpha) {
        this.argb = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public GuiColorStatic(float red, float green, float blue, float alpha) {
        this((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    public GuiColorStatic(Color color) {
        this(color.getRGB());
    }

    @Override
    public int getRGB() {
        return this.argb;
    }

    @Override
    public float getRed() {
        return (float)(this.argb >> 16 & 0xFF) / 255.0f;
    }

    @Override
    public float getGreen() {
        return (float)(this.argb >> 8 & 0xFF) / 255.0f;
    }

    @Override
    public float getBlue() {
        return (float)(this.argb & 0xFF) / 255.0f;
    }

    @Override
    public float getAlpha() {
        return (float)(this.argb >> 24 & 0xFF) / 255.0f;
    }

    @Override
    public void applyGlColor() {
        GL11.glColor4f((float)this.getRed(), (float)this.getGreen(), (float)this.getBlue(), (float)this.getAlpha());
    }
}

