/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.event;

import baubles.api.IBauble;
import baubles.common.Baubles;
import baubles.common.Config;
import baubles.common.container.InventoryBaubles;
import baubles.common.event.EventHandlerNetwork;
import baubles.common.lib.PlayerHandler;
import com.google.common.io.Files;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class EventHandlerEntity {
    private File playerDirectory;
    private Map<String, Boolean> playerModes = new HashMap<String, Boolean>();

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (Config.isSplitSurvivalCreative()) {
                if (this.playerModes.containsKey(player.func_70005_c_()) && this.playerDirectory != null) {
                    Boolean mode = this.playerModes.get(player.func_70005_c_());
                    if (mode.booleanValue() && !player.field_71075_bZ.field_75098_d) {
                        this.playerSaveDo(player, this.playerDirectory, true);
                        this.playerLoadDo(player, this.playerDirectory, false);
                    } else if (!mode.booleanValue() && player.field_71075_bZ.field_75098_d) {
                        this.playerSaveDo(player, this.playerDirectory, false);
                        this.playerLoadDo(player, this.playerDirectory, true);
                    }
                }
                this.playerModes.put(player.func_70005_c_(), player.field_71075_bZ.field_75098_d);
            }
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles(player);
            for (int a = 0; a < baubles.func_70302_i_(); ++a) {
                if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof IBauble)) continue;
                ((IBauble)baubles.func_70301_a(a).func_77973_b()).onWornTick(baubles.func_70301_a(a), (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void playerDeath(PlayerDropsEvent event) {
        if (event.entity instanceof EntityPlayer && !event.entity.field_70170_p.field_72995_K && !event.entity.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
            PlayerHandler.getPlayerBaubles(event.entityPlayer).dropItemsAt(event.drops, (Entity)event.entityPlayer);
        }
    }

    @SubscribeEvent
    public void playerLoad(PlayerEvent.LoadFromFile event) {
        this.playerLoadDo(event.entityPlayer, event.playerDirectory, event.entityPlayer.field_71075_bZ.field_75098_d);
        this.playerDirectory = event.playerDirectory;
    }

    private void playerLoadDo(EntityPlayer player, File directory, Boolean gamemode) {
        String fileNameBackup;
        String fileName;
        PlayerHandler.clearPlayerBaubles(player);
        if (gamemode.booleanValue() || !Config.isSplitSurvivalCreative()) {
            fileName = "baub";
            fileNameBackup = "baubback";
        } else {
            fileName = "baubs";
            fileNameBackup = "baubsback";
        }
        File file1 = this.getPlayerFile(fileName, directory, player.func_70005_c_());
        File file2 = this.getPlayerFile(fileNameBackup, directory, player.func_70005_c_());
        if (!file1.exists()) {
            File filep = this.getPlayerFileUUID(fileName, directory, player.func_146103_bH().getId().toString());
            if (filep.exists()) {
                try {
                    Files.copy((File)filep, (File)file1);
                    Baubles.log.info("Using and converting UUID Baubles savefile for " + player.func_70005_c_());
                    filep.delete();
                    File fb = this.getPlayerFileUUID(fileNameBackup, directory, player.func_146103_bH().getId().toString());
                    if (fb.exists()) {
                        fb.delete();
                    }
                }
                catch (IOException fb) {}
            } else {
                File filet = EventHandlerEntity.getLegacyFileFromPlayer(player);
                if (filet.exists()) {
                    try {
                        Files.copy((File)filet, (File)file1);
                        Baubles.log.info("Using pre MC 1.7.10 Baubles savefile for " + player.func_70005_c_());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        PlayerHandler.loadPlayerBaubles(player, file1, file2);
        EventHandlerNetwork.syncBaubles(player);
    }

    public File getPlayerFile(String suffix, File playerDirectory, String playername) {
        if ("dat".equals(suffix)) {
            throw new IllegalArgumentException("The suffix 'dat' is reserved");
        }
        return new File(playerDirectory, playername + "." + suffix);
    }

    public File getPlayerFileUUID(String suffix, File playerDirectory, String playerUUID) {
        if ("dat".equals(suffix)) {
            throw new IllegalArgumentException("The suffix 'dat' is reserved");
        }
        return new File(playerDirectory, playerUUID + "." + suffix);
    }

    public static File getLegacyFileFromPlayer(EntityPlayer player) {
        try {
            File playersDirectory = new File(player.field_70170_p.func_72860_G().func_75765_b(), "players");
            return new File(playersDirectory, player.func_70005_c_() + ".baub");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @SubscribeEvent
    public void playerSave(PlayerEvent.SaveToFile event) {
        this.playerSaveDo(event.entityPlayer, event.playerDirectory, event.entityPlayer.field_71075_bZ.field_75098_d);
    }

    private void playerSaveDo(EntityPlayer player, File directory, Boolean gamemode) {
        if (gamemode.booleanValue() || !Config.isSplitSurvivalCreative()) {
            PlayerHandler.savePlayerBaubles(player, this.getPlayerFile("baub", directory, player.func_70005_c_()), this.getPlayerFile("baubback", directory, player.func_70005_c_()));
        } else {
            PlayerHandler.savePlayerBaubles(player, this.getPlayerFile("baubs", directory, player.func_70005_c_()), this.getPlayerFile("baubsback", directory, player.func_70005_c_()));
        }
    }
}

