/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.avaritia.compat.forestry;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import fox.spiteful.avaritia.compat.forestry.BeeBranch;
import fox.spiteful.avaritia.compat.forestry.Genomes;
import fox.spiteful.avaritia.compat.forestry.Ranger;
import fox.spiteful.avaritia.items.LudicrousItems;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public enum GreedyBeeSpecies implements IAlleleBeeSpecies,
IIconProvider
{
    ANNOYING("annoying", "incommodus", BeeBranch.BALANCED, "SpitefulFox", 6696193, 0x777777, false),
    TEDIOUS("tedious", "longus", BeeBranch.BALANCED, "SpitefulFox", 6696193, 6696193, false),
    INSUFFERABLE("insufferable", "intolerabilis", BeeBranch.BALANCED, "SpitefulFox", 6696193, 16763632, true),
    TRIPPY("trippy", "laetus", BeeBranch.INFINITE, "SpitefulFox", 0xFFFFFF, -1, false),
    COSMIC("cosmic", "caelus", BeeBranch.INFINITE, "SpitefulFox", 0xFFFFFF, -1, true),
    NEUTRONIUM("neutronium", "sidereus", BeeBranch.INFINITE, "SpitefulFox", 11137791, 0x2C2C2C, true),
    INFINITE("infinite", "infinitus", BeeBranch.INFINITE, "SpitefulFox", -1, -1, true, false, true);

    private String name;
    private String binomial;
    private IClassification branch;
    private boolean dominant;
    private String authority;
    private EnumTemperature temperature = EnumTemperature.NORMAL;
    private EnumHumidity humidity = EnumHumidity.NORMAL;
    private boolean hasEffect;
    private boolean isSecret;
    private boolean isCounted = true;
    private boolean fancy;
    private boolean isNocturnal = false;
    private IAllele[] genomeTemplate;
    private HashMap<ItemStack, Float> products = new HashMap();
    private HashMap<ItemStack, Float> specialties = new HashMap();
    private HashMap<ItemStack, Integer> legacyProducts = new HashMap();
    private HashMap<ItemStack, Integer> legacySpecialties = new HashMap();
    private int primaryColor;
    private int secondaryColor;
    @SideOnly(value=Side.CLIENT)
    private IIcon[][] icons;

    private GreedyBeeSpecies(String nombre, String genus, IClassification bran, String author, int mainColor, int otherColor, boolean dom, boolean secret, boolean shiny) {
        this.name = nombre;
        this.binomial = genus;
        this.branch = bran;
        this.primaryColor = mainColor;
        this.secondaryColor = otherColor;
        this.authority = author;
        this.dominant = dom;
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
        this.branch.addMemberSpecies((IAlleleSpecies)this);
        this.isSecret = secret;
        this.fancy = shiny;
    }

    private GreedyBeeSpecies(String nombre, String genus, IClassification bran, String author, int mainColor, int otherColor, boolean dom) {
        this(nombre, genus, bran, author, mainColor, otherColor, dom, false, false);
    }

    public static void buzz() {
        ANNOYING.registerGenomeTemplate(Genomes.getBalanced());
        TEDIOUS.registerGenomeTemplate(Genomes.getTedious());
        INSUFFERABLE.registerGenomeTemplate(Genomes.getInsufferable());
        TRIPPY.registerGenomeTemplate(Genomes.getInfinite());
        COSMIC.registerGenomeTemplate(Genomes.getCosmic());
        NEUTRONIUM.registerGenomeTemplate(Genomes.getNeutronium());
        INFINITE.registerGenomeTemplate(Genomes.getInfiniteBee());
        ANNOYING.addProduct(new ItemStack(LudicrousItems.combs, 1, 0), 0.4f);
        TEDIOUS.addProduct(new ItemStack(LudicrousItems.combs, 1, 0), 0.2f);
        INSUFFERABLE.addProduct(new ItemStack(LudicrousItems.combs, 1, 0), 0.1f);
        TRIPPY.addProduct(new ItemStack(LudicrousItems.combs, 1, 1), 0.15f);
        COSMIC.addProduct(new ItemStack(LudicrousItems.combs, 1, 1), 0.15f);
        COSMIC.addSpecialty(new ItemStack(LudicrousItems.beesource, 1, 0), 0.1f);
        NEUTRONIUM.addProduct(new ItemStack(LudicrousItems.combs, 1, 1), 0.15f);
        NEUTRONIUM.addSpecialty(new ItemStack(LudicrousItems.resource, 1, 2), 0.8f);
        INFINITE.addProduct(new ItemStack(LudicrousItems.combs, 1, 1), 0.15f);
    }

    public String getUID() {
        return "avaritia." + this.name;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("avaritia.bee." + this.name));
    }

    public String getUnlocalizedName() {
        return "avaritia.bee." + this.name;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getDescription() {
        return StatCollector.func_74838_a((String)("avaritia.bee." + this.name + ".desc"));
    }

    public IClassification getBranch() {
        return this.branch;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public boolean isCounted() {
        return this.isCounted;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public boolean hasEffect() {
        return this.fancy;
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    public boolean isNocturnal() {
        return this.isNocturnal;
    }

    public IAllele[] getGenome() {
        return this.genomeTemplate;
    }

    public void setGenome(IAllele[] genome) {
        this.genomeTemplate = genome;
    }

    public int getComplexity() {
        return 1 + this.getGeneticAdvancement((IAllele)this, new ArrayList<IAllele>());
    }

    public HashMap<ItemStack, Float> getProductChances() {
        return this.products;
    }

    public HashMap<ItemStack, Float> getSpecialtyChances() {
        return this.specialties;
    }

    public IBeeRoot getRoot() {
        return BeeManager.beeRoot;
    }

    public boolean isJubilant(IBeeGenome genome, IBeeHousing housing) {
        return true;
    }

    public void addProduct(ItemStack produce, float percentChance) {
        this.products.put(produce, Float.valueOf(percentChance));
        this.legacyProducts.put(produce, (int)(percentChance * 100.0f));
    }

    public void addSpecialty(ItemStack produce, float percentChance) {
        this.specialties.put(produce, Float.valueOf(percentChance));
        this.legacySpecialties.put(produce, (int)(percentChance * 100.0f));
    }

    public void registerGenomeTemplate(IAllele[] genome) {
        this.genomeTemplate = genome;
        BeeManager.beeRoot.registerTemplate(this.getUID(), genome);
    }

    private int getGeneticAdvancement(IAllele species, ArrayList<IAllele> exclude) {
        int own = 1;
        int highest = 0;
        exclude.add(species);
        for (IMutation mutation : this.getRoot().getPaths(species, (IChromosomeType)EnumBeeChromosome.SPECIES)) {
            int otherAdvance;
            if (!exclude.contains(mutation.getAllele0()) && (otherAdvance = this.getGeneticAdvancement((IAllele)mutation.getAllele0(), exclude)) > highest) {
                highest = otherAdvance;
            }
            if (exclude.contains(mutation.getAllele1()) || (otherAdvance = this.getGeneticAdvancement((IAllele)mutation.getAllele1(), exclude)) <= highest) continue;
            highest = otherAdvance;
        }
        return own + (highest < 0 ? 0 : highest);
    }

    public float getResearchSuitability(ItemStack itemStack) {
        if (itemStack == null) {
            return 0.0f;
        }
        for (ItemStack itemStack2 : this.products.keySet()) {
            if (!itemStack.func_77969_a(itemStack2)) continue;
            return 1.0f;
        }
        for (ItemStack itemStack3 : this.specialties.keySet()) {
            if (!itemStack3.func_77969_a(itemStack)) continue;
            return 1.0f;
        }
        if (itemStack.func_77973_b() == Ranger.honey) {
            return 0.5f;
        }
        if (itemStack.func_77973_b() == Ranger.honeydew) {
            return 0.7f;
        }
        if (itemStack.func_77973_b() == Ranger.comb) {
            return 0.4f;
        }
        if (this.getRoot().isMember(itemStack)) {
            return 1.0f;
        }
        for (Map.Entry entry : BeeManager.beeRoot.getResearchCatalysts().entrySet()) {
            if (!OreDictionary.itemMatches((ItemStack)itemStack, (ItemStack)((ItemStack)entry.getKey()), (boolean)false)) continue;
            return ((Float)entry.getValue()).floatValue();
        }
        return 0.0f;
    }

    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        ItemStack copy;
        Collection resultantMutations;
        System.out.println("Bounty level: " + bountyLevel);
        ArrayList<ItemStack> bounty = new ArrayList<ItemStack>();
        if (world.field_73012_v.nextFloat() < 10.0f / (float)bountyLevel && (resultantMutations = this.getRoot().getCombinations((IAllele)this)).size() > 0) {
            IMutation[] candidates = resultantMutations.toArray(new IMutation[resultantMutations.size()]);
            bounty.add(AlleleManager.alleleRegistry.getMutationNoteStack(researcher, candidates[world.field_73012_v.nextInt(candidates.length)]));
        }
        for (ItemStack product : this.products.keySet()) {
            copy = product.func_77946_l();
            copy.field_77994_a = 1 + world.field_73012_v.nextInt(bountyLevel / 2);
            bounty.add(copy);
        }
        for (ItemStack specialty : this.specialties.keySet()) {
            copy = specialty.func_77946_l();
            copy.field_77994_a = world.field_73012_v.nextInt(bountyLevel / 3);
            if (copy.field_77994_a <= 0) continue;
            bounty.add(copy);
        }
        return bounty.toArray(new ItemStack[bounty.size()]);
    }

    public String getEntityTexture() {
        return "/gfx/forestry/entities/bees/honeyBee.png";
    }

    public int getIconColour(int renderPass) {
        int value = 0xFFFFFF;
        if (renderPass == 0) {
            if (this.primaryColor == -1) {
                int hue = (int)(System.currentTimeMillis() >> 2) % 360;
                value = Color.getHSBColor((float)hue / 360.0f, 0.75f, 0.8f).getRGB();
            } else {
                value = this.primaryColor;
            }
        } else if (renderPass == 1) {
            if (this.secondaryColor == -1) {
                int hue = (int)(System.currentTimeMillis() >> 3) % 360;
                hue += 60;
                value = Color.getHSBColor((float)(hue %= 360) / 360.0f, 0.5f, 0.6f).getRGB();
            } else {
                value = this.secondaryColor;
            }
        }
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(EnumBeeType type, int renderPass) {
        return this.icons[type.ordinal()][Math.min(renderPass, 2)];
    }

    public void registerIcons(IIconRegister itemMap) {
        this.icons = new IIcon[EnumBeeType.values().length][3];
        IIcon body1 = itemMap.func_94245_a("forestry:bees/default/body1");
        for (int i = 0; i < EnumBeeType.values().length; ++i) {
            if (EnumBeeType.values()[i] == EnumBeeType.NONE) continue;
            this.icons[i][0] = itemMap.func_94245_a("forestry:bees/default/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".outline");
            this.icons[i][1] = EnumBeeType.values()[i] != EnumBeeType.LARVAE ? body1 : itemMap.func_94245_a("forestry:bees/default/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body");
            this.icons[i][2] = itemMap.func_94245_a("forestry:bees/default/" + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body2");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(short texUID) {
        return this.icons[0][0];
    }
}

