/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib.inventory;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class HashableItemWithoutSize {
    public final int damage;
    public final NBTTagCompound tagCompound;
    private final int itemID;

    public HashableItemWithoutSize(ItemStack stack) {
        this.itemID = Item.func_150891_b((Item)stack.func_77973_b());
        this.damage = stack.func_77960_j();
        this.tagCompound = stack.func_77978_p();
    }

    public HashableItemWithoutSize(Item item, int damage, NBTTagCompound tagCompound) {
        this.itemID = Item.func_150891_b((Item)item);
        this.damage = damage;
        this.tagCompound = tagCompound;
    }

    private HashableItemWithoutSize(int itemID, int damage, NBTTagCompound tagCompound) {
        this.itemID = itemID;
        this.damage = damage;
        this.tagCompound = tagCompound;
    }

    public HashableItemWithoutSize(HashableItemWithoutSize item, boolean ignoreMetadata, boolean ignoreNBT) {
        this.itemID = item.itemID;
        this.damage = ignoreMetadata ? 0 : item.damage;
        this.tagCompound = ignoreNBT ? null : item.tagCompound;
    }

    public ItemStack getItemStack(int size) {
        ItemStack stack = new ItemStack(Item.func_150899_d((int)this.itemID), size, this.damage);
        if (this.tagCompound != null) {
            stack.func_77982_d(this.tagCompound);
        }
        return stack;
    }

    public Item getItem() {
        return Item.func_150899_d((int)this.itemID);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.damage;
        result = 31 * result + this.itemID;
        result = 31 * result + (this.tagCompound == null ? 0 : this.tagCompound.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HashableItemWithoutSize)) {
            return false;
        }
        HashableItemWithoutSize other = (HashableItemWithoutSize)obj;
        if (this.damage != other.damage) {
            return false;
        }
        if (this.itemID != other.itemID) {
            return false;
        }
        return !(this.tagCompound == null ? other.tagCompound != null : !this.tagCompound.equals((Object)other.tagCompound));
    }

    public boolean isSameItem(ItemStack stack) {
        return this.isSameItem(stack, false, false);
    }

    public boolean isSameItem(ItemStack stack, boolean ignoreMetadata, boolean ignoreNBT) {
        if (stack == null || this.itemID != Item.func_150891_b((Item)stack.func_77973_b())) {
            return false;
        }
        if (!ignoreMetadata && this.damage != stack.func_77960_j()) {
            return false;
        }
        if (!ignoreNBT) {
            NBTTagCompound checkTagCompound = stack.func_77978_p();
            if (this.tagCompound == null ? checkTagCompound != null : !this.tagCompound.equals((Object)checkTagCompound)) {
                return false;
            }
        }
        return true;
    }

    public boolean isSameItem(HashableItemWithoutSize item, boolean ignoreMetadata, boolean ignoreNBT) {
        if (item == null || this.itemID != item.itemID) {
            return false;
        }
        if (!ignoreMetadata && this.damage != item.damage) {
            return false;
        }
        if (!ignoreNBT) {
            NBTTagCompound checkTagCompound = item.tagCompound;
            if (this.tagCompound == null ? checkTagCompound != null : !this.tagCompound.equals((Object)checkTagCompound)) {
                return false;
            }
        }
        return true;
    }

    public static HashableItemWithoutSize getWithWildcardDamage(HashableItemWithoutSize item) {
        return new HashableItemWithoutSize(item.itemID, Short.MAX_VALUE, item.tagCompound);
    }
}

