/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.entities;

import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.entities.DataFromEntity;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.tiles.TileEntityMobLure;

public class EntityAICharmWalk
extends EntityAIBase {
    private final EntityLiving thisEntity;
    private final float maxSpeed;
    private float currentSpeed;
    public static int TARGET_IGNORABLE_RANGE = 100;
    public static int PRIORITY = -1;
    public static WeakHashMap<UUID, EntityAICharmWalk> charmedEntities = new WeakHashMap();
    protected WorldSpecificCoordinates coord;
    protected WorldSpecificCoordinates coordCooldown = null;
    protected int cooldown = 0;
    protected int prevX;
    protected int prevZ;
    protected int checkStuck = 0;
    public double maxLureRangeSquared;
    public int lureStrength;

    public EntityAICharmWalk(EntityLiving p_i1620_1_, float p_i1620_2_, WorldSpecificCoordinates coord, double rangeSquared, int lureStrength) {
        this.thisEntity = p_i1620_1_;
        this.maxSpeed = p_i1620_2_;
        this.coord = coord;
        this.maxLureRangeSquared = rangeSquared;
        this.lureStrength = lureStrength;
        this.func_75248_a(3);
    }

    public void func_75249_e() {
        this.currentSpeed = 0.0f;
    }

    public void func_75251_c() {
        this.currentSpeed = 0.0f;
    }

    public boolean func_75250_a() {
        return this.shouldExecuteHelper(true);
    }

    private boolean shouldExecuteHelper(boolean doCount) {
        if (this.cooldown > 0) {
            if (doCount) {
                --this.cooldown;
                if (this.cooldown < 1) {
                    this.coordCooldown = null;
                }
            }
            if (this.coord.equals(this.coordCooldown)) {
                return false;
            }
        }
        int x = (int)this.thisEntity.field_70165_t;
        int y = (int)this.thisEntity.field_70163_u;
        int z = (int)this.thisEntity.field_70161_v;
        if (x == this.prevX && z == this.prevZ) {
            if (doCount) {
                ++this.checkStuck;
            }
            if (this.checkStuck > 140) {
                if (doCount) {
                    this.cooldown = 100;
                    this.coordCooldown = this.coord;
                    this.checkStuck = 0;
                }
                return false;
            }
        } else if (doCount) {
            this.checkStuck = 0;
            this.prevX = x;
            this.prevZ = z;
        }
        return this.thisEntity.func_70089_S() && this.thisEntity.field_70170_p.field_73011_w.field_76574_g == this.coord.dim && ModBlocks.mobLure.canLureAffectEntity((IBlockAccess)this.thisEntity.field_70170_p, this.coord.x, this.coord.y, this.coord.z, (EntityLivingBase)this.thisEntity, this.maxLureRangeSquared) && EntityAICharmWalk.attackTargetIgnorable(this.thisEntity);
    }

    public void func_75246_d() {
        this.thisEntity.func_70605_aq().func_75642_a((double)this.coord.x + 0.5, (double)this.coord.y, (double)this.coord.z + 0.5, 0.1);
        EntityLiving entitycreature = this.thisEntity;
        if (this.currentSpeed < this.maxSpeed) {
            this.currentSpeed += (this.maxSpeed - this.currentSpeed) * 0.01f;
        }
        if (this.currentSpeed > this.maxSpeed) {
            this.currentSpeed = this.maxSpeed;
        }
        int i = MathHelper.func_76128_c((double)this.thisEntity.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.thisEntity.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.thisEntity.field_70161_v);
        float f1 = this.currentSpeed;
        float f2 = 0.91f;
        if (this.thisEntity.field_70122_E) {
            f2 = this.thisEntity.field_70170_p.func_147439_a((int)MathHelper.func_76141_d((float)((float)i)), (int)(MathHelper.func_76141_d((float)((float)j)) - 1), (int)MathHelper.func_76141_d((float)((float)k))).field_149765_K * 0.91f;
        }
        float f3 = 0.16277136f / (f2 * f2 * f2);
        float f4 = MathHelper.func_76126_a((float)(entitycreature.field_70177_z * (float)Math.PI / 180.0f));
        float f5 = MathHelper.func_76134_b((float)(entitycreature.field_70177_z * (float)Math.PI / 180.0f));
        float f6 = entitycreature.func_70689_ay() * f3;
        float f7 = Math.max(f1, 1.0f);
        f7 = f6 / f7;
        float f8 = f1 * f7;
        float f9 = -(f8 * f4);
        float f10 = f8 * f5;
        if (MathHelper.func_76135_e((float)f9) > MathHelper.func_76135_e((float)f10)) {
            if (f9 < 0.0f) {
                f9 -= this.thisEntity.field_70130_N / 2.0f;
            }
            if (f9 > 0.0f) {
                f9 += this.thisEntity.field_70130_N / 2.0f;
            }
            f10 = 0.0f;
        } else {
            f9 = 0.0f;
            if (f10 < 0.0f) {
                f10 -= this.thisEntity.field_70130_N / 2.0f;
            }
            if (f10 > 0.0f) {
                f10 += this.thisEntity.field_70130_N / 2.0f;
            }
        }
        int l = MathHelper.func_76128_c((double)(this.thisEntity.field_70165_t + (double)f9));
        int i1 = MathHelper.func_76128_c((double)(this.thisEntity.field_70161_v + (double)f10));
        PathPoint pathpoint = new PathPoint(MathHelper.func_76141_d((float)(this.thisEntity.field_70130_N + 1.0f)), MathHelper.func_76141_d((float)(this.thisEntity.field_70131_O + 1.0f)), MathHelper.func_76141_d((float)(this.thisEntity.field_70130_N + 1.0f)));
        if (i != l || k != i1) {
            boolean flag;
            Block block = this.thisEntity.field_70170_p.func_147439_a(i, j, k);
            boolean bl = flag = !this.func_151498_a(block) && (block.func_149688_o() != Material.field_151579_a || !this.func_151498_a(this.thisEntity.field_70170_p.func_147439_a(i, j - 1, k)));
            if (flag && PathFinder.func_82565_a((Entity)this.thisEntity, (int)l, (int)j, (int)i1, (PathPoint)pathpoint, (boolean)false, (boolean)false, (boolean)true) == 0 && PathFinder.func_82565_a((Entity)this.thisEntity, (int)i, (int)(j + 1), (int)k, (PathPoint)pathpoint, (boolean)false, (boolean)false, (boolean)true) == 1 && PathFinder.func_82565_a((Entity)this.thisEntity, (int)l, (int)(j + 1), (int)i1, (PathPoint)pathpoint, (boolean)false, (boolean)false, (boolean)true) == 1) {
                entitycreature.func_70683_ar().func_75660_a();
            }
        }
        this.thisEntity.func_70612_e(0.0f, f1);
        this.thisEntity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 20, 0));
    }

    private boolean func_151498_a(Block p_151498_1_) {
        return p_151498_1_.func_149645_b() == 10 || p_151498_1_ instanceof BlockSlab;
    }

    public static boolean attackTargetIgnorable(EntityLiving entity) {
        int revengeTimer;
        EntityLivingBase target = entity.func_70638_az();
        if (target != null && (revengeTimer = entity.func_142015_aE()) > 0 && entity.field_70173_aa - revengeTimer < 100) {
            return entity.func_70068_e((Entity)target) >= (double)TARGET_IGNORABLE_RANGE;
        }
        return true;
    }

    public static boolean addAIToEntity(EntityLiving entity, World world, int x, int y, int z, double range, int lureStrength, TileEntityMobLure teML) {
        UUID id = entity.func_110124_au();
        if (!charmedEntities.containsKey(id)) {
            if (!DataFromEntity.isAIEnabled(entity)) {
                return false;
            }
            WorldSpecificCoordinates coord = new WorldSpecificCoordinates(world, x, y, z);
            EntityAICharmWalk aiCharmedWalk = new EntityAICharmWalk(entity, 5.0f, coord, range * range, lureStrength);
            entity.field_70714_bg.func_75776_a(PRIORITY, (EntityAIBase)aiCharmedWalk);
            charmedEntities.put(id, aiCharmedWalk);
            if (entity instanceof EntityAgeable) {
                for (EntityAITasks.EntityAITaskEntry entityaitaskentry : entity.field_70714_bg.field_75782_a) {
                    EntityAIBase entityaibase1 = entityaitaskentry.field_75733_a;
                    if (!(entityaibase1 instanceof EntityAIFollowParent)) continue;
                    entity.field_70714_bg.func_85156_a(entityaibase1);
                    break;
                }
            }
        } else {
            EntityAICharmWalk aiCharmedWalk = charmedEntities.get(id);
            WorldSpecificCoordinates coord = new WorldSpecificCoordinates(world, x, y, z);
            double rangeSquared = range * range;
            if (aiCharmedWalk.coord.equals(coord)) {
                if (aiCharmedWalk.maxLureRangeSquared != rangeSquared || aiCharmedWalk.lureStrength != lureStrength) {
                    aiCharmedWalk.maxLureRangeSquared = rangeSquared;
                    aiCharmedWalk.lureStrength = lureStrength;
                }
            } else if (!(aiCharmedWalk.lureStrength >= lureStrength && aiCharmedWalk.shouldExecuteHelper(false) || coord.equals(aiCharmedWalk.coordCooldown) || !ModBlocks.mobLure.canActiveLureAffectEntity(teML, (EntityLivingBase)aiCharmedWalk.thisEntity, rangeSquared))) {
                aiCharmedWalk.coord = coord;
                aiCharmedWalk.cooldown = 200;
                aiCharmedWalk.maxLureRangeSquared = rangeSquared;
                int prev = aiCharmedWalk.lureStrength;
                aiCharmedWalk.lureStrength = lureStrength;
            }
        }
        return true;
    }
}

