/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import tuhljin.automagy.items.ItemGlyph;
import tuhljin.automagy.tiles.ModTileEntity;
import tuhljin.automagy.tiles.TileEntityThirstyTank;

public class ItemBlockThirstyTank
extends ItemBlock {
    public static final String GLYPH_KEY = "Glyphs";

    public ItemBlockThirstyTank(Block block) {
        super(block);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean placed = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (placed && stack.func_77942_o()) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.field_77990_d);
            if (fluidStack != null) {
                TileEntityThirstyTank te = (TileEntityThirstyTank)world.func_147438_o(x, y, z);
                te.setFluid(fluidStack);
            }
            if (stack.field_77990_d.func_74764_b(GLYPH_KEY)) {
                int[] glyphs = ModTileEntity.getIntArrayFromNbtOrDefault(stack.field_77990_d, GLYPH_KEY, 0, 6);
                TileEntityThirstyTank te = (TileEntityThirstyTank)world.func_147438_o(x, y, z);
                te.setGlyphs(glyphs);
            }
        }
        return placed;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean p_77624_4_) {
        if (stack.func_77942_o()) {
            if (stack.field_77990_d.func_74764_b(GLYPH_KEY)) {
                int[] glyphs = ModTileEntity.getIntArrayFromNbtOrDefault(stack.field_77990_d, GLYPH_KEY, 0, 6);
                HashMap<Integer, Integer> glyphCount = new HashMap<Integer, Integer>();
                for (int id : glyphs) {
                    if (id <= 0) continue;
                    Integer c = (Integer)glyphCount.get(id);
                    glyphCount.put(id, (c == null ? 0 : c) + 1);
                }
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.field_77990_d);
                if (fluidStack != null) {
                    Integer capacity = (Integer)glyphCount.get(8);
                    capacity = 16 + (capacity == null ? 0 : capacity) * TileEntityThirstyTank.CAPACITY_IN_BUCKETS_PER_UPGRADE;
                    list.add(StatCollector.func_74837_a((String)"Automagy.tip.tankFluidData", (Object[])new Object[]{fluidStack.amount, 1000 * capacity, fluidStack.getLocalizedName()}));
                }
                for (Map.Entry entry : glyphCount.entrySet()) {
                    String s = ItemGlyph.getLocalizedGlyphName((Integer)entry.getKey());
                    int c = (Integer)entry.getValue();
                    if (c > 1) {
                        s = s + EnumChatFormatting.DARK_GRAY + " (" + c + ")";
                    }
                    list.add(s);
                }
            } else {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.field_77990_d);
                if (fluidStack != null) {
                    list.add(StatCollector.func_74837_a((String)"Automagy.tip.tankFluidData", (Object[])new Object[]{fluidStack.amount, 16000, fluidStack.getLocalizedName()}));
                }
            }
        }
    }
}

