/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import tuhljin.automagy.blocks.ItemBlockThirstyTank;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.blocks.fluid.BlockFillableByBucket;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.References;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.tiles.TileEntityThirstyTank;

public class BlockThirstyTank
extends BlockFillableByBucket {
    private FluidStack lastFluidStack = null;
    private int[] lastGlyphs = null;

    public BlockThirstyTank(String name) {
        super(name, ModBlocks.materialNiceStone, ItemBlockThirstyTank.class, true);
        this.func_149658_d("thaumcraft:pedestal_top");
        this.func_149676_a(0.031f, 0.0f, 0.031f, 0.969f, 0.939f, 0.969f);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityThirstyTank();
    }

    @Override
    public int func_149645_b() {
        return References.renderBlockThirstyTank;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return ((TileEntityThirstyTank)world.func_147438_o(x, y, z)).getComparatorStrength();
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        TileEntityThirstyTank te = null;
        try {
            te = (TileEntityThirstyTank)world.func_147438_o(x, y, z);
            this.lastFluidStack = te.tank.getFluid();
            this.lastGlyphs = null;
            for (int i = 0; i < te.glyphs.length; ++i) {
                if (te.glyphs[i] == 0) continue;
                this.lastGlyphs = te.glyphs;
                break;
            }
        }
        catch (Exception ex) {
            this.lastFluidStack = null;
            this.lastGlyphs = null;
        }
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
        ItemStack stack = new ItemStack(item, 1, this.func_149692_a(metadata));
        TileEntityThirstyTank te = null;
        try {
            te = (TileEntityThirstyTank)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FluidStack fluidStack = null;
        fluidStack = te != null ? te.tank.getFluid() : this.lastFluidStack;
        if (fluidStack != null) {
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            fluidStack.writeToNBT(stack.field_77990_d);
        }
        this.lastFluidStack = null;
        int[] glyphs = null;
        glyphs = te != null ? te.glyphs : this.lastGlyphs;
        if (glyphs != null) {
            if (stack.field_77990_d == null) {
                stack.field_77990_d = new NBTTagCompound();
            }
            stack.field_77990_d.func_74783_a("Glyphs", glyphs);
        }
        this.lastGlyphs = null;
        drops.add(stack);
        return drops;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        int glyph;
        if (super.func_149727_a(world, x, y, z, player, side, par7, par8, par9)) {
            return true;
        }
        ItemStack heldStack = player.field_71071_by.func_70448_g();
        if (heldStack != null && heldStack.func_77973_b() == ModItems.tankGlyph && (glyph = heldStack.func_77960_j()) > 0) {
            TileEntityThirstyTank te;
            if (!world.field_72995_K && (te = (TileEntityThirstyTank)world.func_147438_o(x, y, z)).installGlyph(glyph, side)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    TjUtil.consumePlayerItem(player, player.field_71071_by.field_70461_c);
                }
                world.func_72956_a((Entity)player, "thaumcraft:upgrade", 0.5f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntityThirstyTank te = (TileEntityThirstyTank)world.func_147438_o(x, y, z);
        RedstoneCalc.PowerResult result = RedstoneCalc.getRedstonePowerAt(world, x, y, z);
        if (result != null) {
            te.receivingSignal = true;
            te.markDirty(false);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TileEntityThirstyTank te = null;
            try {
                te = (TileEntityThirstyTank)world.func_147438_o(x, y, z);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (te != null) {
                RedstoneCalc.PowerResult result = RedstoneCalc.getRedstonePowerAt(world, x, y, z);
                te.updateRedstoneInput(result != null);
            }
        }
    }
}

