/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tuhljin.automagy.Automagy;
import tuhljin.automagy.blocks.BlockRemoteComparator;
import tuhljin.automagy.blocks.ModBlockContainer;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.IRemoteComparatorOverride;
import tuhljin.automagy.lib.NeighborNotifier;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.tiles.TileEntityRemoteComparator;
import tuhljin.automagy.tiles.TileEntityTallyBase;

public abstract class BlockTallyBase
extends ModBlockContainer
implements IRemoteComparatorOverride {
    protected IIcon iconReading;
    protected IIcon iconOutputOff;
    protected IIcon iconOutputOn;

    public BlockTallyBase(String name) {
        super(name, Material.field_151575_d);
        this.func_149711_c(2.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149766_f);
    }

    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a("Automagy:blockTally");
        this.iconOutputOff = ir.func_94245_a("Automagy:blockTallyRedOff");
        this.iconOutputOn = ir.func_94245_a("Automagy:blockTallyRedOn");
    }

    public IIcon func_149673_e(IBlockAccess blockaccess, int x, int y, int z, int side) {
        int orientation;
        int md = blockaccess.func_72805_g(x, y, z);
        int n = orientation = md > 5 ? md - 6 : md;
        if (side == orientation) {
            return md > 5 ? this.iconOutputOn : this.iconOutputOff;
        }
        if (ForgeDirection.OPPOSITES[side] == orientation) {
            return this.iconReading;
        }
        return this.field_149761_L;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == 1) {
            return this.iconReading;
        }
        if (side == 0) {
            return this.iconOutputOn;
        }
        return this.field_149761_L;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float p_149660_6_, float p_149660_7_, float p_149660_8_, int p_149660_9_) {
        return side;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            boolean rcAbove = false;
            TileEntity teRC = world.func_147438_o(x, y + 1, z);
            if (teRC != null && teRC instanceof TileEntityRemoteComparator) {
                ((TileEntityRemoteComparator)teRC).setOverride(true);
                if (world.func_72805_g(x, y, z) != 0) {
                    world.func_72921_c(x, y, z, 0, 2);
                }
                rcAbove = true;
            }
            TileEntityTallyBase te = null;
            try {
                te = (TileEntityTallyBase)world.func_147438_o(x, y, z);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (te != null) {
                te.findNewTarget(rcAbove);
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TileEntity teRC = world.func_147438_o(x, y + 1, z);
            if (teRC != null && teRC instanceof TileEntityRemoteComparator) {
                int md;
                if (block instanceof BlockRemoteComparator) {
                    ((TileEntityRemoteComparator)teRC).setOverride(true);
                }
                if ((md = world.func_72805_g(x, y, z)) != 0 && md != 6) {
                    world.func_72921_c(x, y, z, 0, 3);
                }
            }
            TileEntityTallyBase te = null;
            try {
                te = (TileEntityTallyBase)world.func_147438_o(x, y, z);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (te != null) {
                te.findNewTarget(true);
            }
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess blockaccess, int x, int y, int z, int side) {
        int orientation = BlockTallyBase.getOrientation(blockaccess, x, y, z);
        return side == orientation;
    }

    public int func_149748_c(IBlockAccess blockaccess, int x, int y, int z, int side) {
        return this.func_149709_b(blockaccess, x, y, z, side);
    }

    public int func_149709_b(IBlockAccess blockaccess, int x, int y, int z, int side) {
        int md = blockaccess.func_72805_g(x, y, z);
        if (md < 6 || ForgeDirection.OPPOSITES[side] != md - 6) {
            return 0;
        }
        return 15;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack held;
        if (!(world.field_72995_K || (held = player.func_71045_bC()) != null && held.func_77973_b() == ModItems.tallyLens)) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Automagy.instance, (int)10, (World)world, (int)x, (int)y, (int)z);
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntity teRC;
        TileEntityTallyBase te = null;
        try {
            te = (TileEntityTallyBase)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (te != null) {
            TjUtil.dropItemsIntoWorld((IInventory)te, world, x, y, z, null);
            if (metadata > 5) {
                NeighborNotifier.notifyBlocksOfExtendedNeighborChange(world, x, y, z, (Block)this);
            }
        }
        if (!world.field_72995_K && (teRC = world.func_147438_o(x, y + 1, z)) != null && teRC instanceof TileEntityRemoteComparator) {
            ((TileEntityRemoteComparator)teRC).setOverride(false);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    @Override
    public int getRemoteComparatorParticleColor(World world, int x, int y, int z, TileEntityRemoteComparator teRC) {
        TileEntityTallyBase te = null;
        try {
            te = (TileEntityTallyBase)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (te == null || !te.hasValidTarget()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean hasActiveRedstoneSignal(World world, int x, int y, int z, TileEntityRemoteComparator teRC) {
        int md = world.func_72805_g(x, y, z);
        return md > 5;
    }

    public static int getOrientation(IBlockAccess blockaccess, int x, int y, int z) {
        int md = blockaccess.func_72805_g(x, y, z);
        return md > 5 ? md - 6 : md;
    }
}

