/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import tuhljin.automagy.Automagy;
import tuhljin.automagy.blocks.BlockRedcrystal;
import tuhljin.automagy.blocks.ItemBlockEntitySignal;
import tuhljin.automagy.blocks.ModBlockContainer;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.lib.IAmplifiedRedstoneOutput;
import tuhljin.automagy.lib.NeighborNotifier;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.tiles.TileEntityEntitySignal;

public class BlockEntitySignal
extends ModBlockContainer
implements IAmplifiedRedstoneOutput {
    protected static int glassOreID = -1;
    protected static int glassPaneOreID;
    IIcon icon2;
    IIcon icondark;
    IIcon icondark2;

    public BlockEntitySignal(String name) {
        super(name, ModBlocks.materialNiceStone, ItemBlockEntitySignal.class);
        if (glassOreID == -1) {
            glassOreID = OreDictionary.getOreID((String)"blockGlass");
            glassPaneOreID = OreDictionary.getOreID((String)"paneGlass");
        }
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityEntitySignal();
    }

    public void func_149651_a(IIconRegister ir) {
        super.func_149651_a(ir);
        String t = this.func_149641_N();
        this.icon2 = ir.func_94245_a(t + "2");
        this.icondark = ir.func_94245_a(t + "-dark");
        this.icondark2 = ir.func_94245_a(t + "2-dark");
    }

    public IIcon func_149673_e(IBlockAccess blockaccess, int x, int y, int z, int side) {
        int md = blockaccess.func_72805_g(x, y, z);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (BlockEntitySignal.isScanBlockedBy(blockaccess, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir)) {
            return md > 0 ? this.icon2 : this.icondark2;
        }
        return md > 0 ? this.field_149761_L : this.icondark;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int md = world.func_72805_g(x, y, z);
        return md > 0 ? 9 : 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149748_c(IBlockAccess blockaccess, int x, int y, int z, int side) {
        return this.func_149709_b(blockaccess, x, y, z, side);
    }

    public int func_149709_b(IBlockAccess blockaccess, int x, int y, int z, int side) {
        return blockaccess.func_72805_g(x, y, z);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TileEntityEntitySignal te = null;
        try {
            te = (TileEntityEntitySignal)world.func_147438_o(x, y, z);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (te != null) {
            TjUtil.dropItemsIntoWorld((IInventory)te, world, x, y, z, null);
        }
        if (metadata > 0) {
            NeighborNotifier.notifyBlocksOfExtendedNeighborChange(world, x, y, z, (Block)this);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Automagy.instance, (int)9, (World)world, (int)x, (int)y, (int)z);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TileEntityEntitySignal te = null;
            try {
                te = (TileEntityEntitySignal)world.func_147438_o(x, y, z);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (te != null) {
                te.flagRangeForRecalculation();
            }
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return this.func_149709_b((IBlockAccess)world, x, y, z, 0);
    }

    public static boolean isScanBlockedBy(IBlockAccess blockaccess, int x, int y, int z, ForgeDirection dir) {
        Block block = blockaccess.func_147439_a(x, y, z);
        if (block == null || block.isAir(blockaccess, x, y, z)) {
            return false;
        }
        if (block.isReplaceable(blockaccess, x, y, z)) {
            return false;
        }
        if (block instanceof BlockRedstoneWire) {
            return dir == ForgeDirection.UP;
        }
        if (block instanceof BlockRedcrystal) {
            return ((BlockRedcrystal)block).getOrientation(blockaccess, x, y, z) == dir.ordinal();
        }
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            int[] oids;
            for (int oid : oids = OreDictionary.getOreIDs((ItemStack)new ItemStack(item))) {
                if (oid != glassOreID && oid != glassPaneOreID) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getRedstoneSignalStrength(IBlockAccess blockaccess, int x, int y, int z, int intoDirection, boolean allowAmplifiedPower) {
        int strength = this.func_149709_b(blockaccess, x, y, z, intoDirection);
        if (allowAmplifiedPower && strength == 15) {
            TileEntityEntitySignal te = (TileEntityEntitySignal)blockaccess.func_147438_o(x, y, z);
            strength += te.powerStability;
        }
        return strength;
    }

    @Override
    public boolean isRedstoneWire() {
        return false;
    }
}

