/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseDirections;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.ShapeKind;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class WindowShapeKinds {
    public static ShapeKind.Window PlainWindow = new PlainWindow();
    public static ShapeKind.Window MullionWindow = new MullionWindow();
    public static ShapeKind.Window CornerWindow = new CornerWindow();

    public static class CornerWindow
    extends ShapeKind.Window {
        public CornerWindow() {
            this.frameSides = new EnumFacing[]{BaseDirections.F_DOWN, BaseDirections.F_SOUTH, BaseDirections.F_UP, BaseDirections.F_WEST};
            this.frameAlways = new boolean[]{false, false, false, false};
            this.frameKinds = new ShapeKind.Window.FrameKind[]{ShapeKind.Window.FrameKind.Corner, ShapeKind.Window.FrameKind.Corner, ShapeKind.Window.FrameKind.None, ShapeKind.Window.FrameKind.Plain, ShapeKind.Window.FrameKind.Plain, ShapeKind.Window.FrameKind.None};
            this.frameOrientations = new EnumFacing[]{BaseDirections.F_EAST, BaseDirections.F_EAST, null, BaseDirections.F_UP, BaseDirections.F_UP, null};
            this.frameTrans = new Trans3[]{Trans3.ident, Trans3.ident.rotY(-90.0).rotZ(90.0), Trans3.ident.rotY(-90.0).rotZ(180.0), Trans3.ident.rotZ(270.0)};
        }

        @Override
        protected void addCentreBoxesToList(double r, double s, Trans3 t, List list) {
            t.addBox(-r, -0.5, -r, r, 0.5, r, list);
        }

        @Override
        protected void addFrameBoxesToList(int i, double r, double s, Trans3 ts, List list) {
            if ((i & 1) == 0) {
                ts.addBox(-0.5, -0.5, -s, s, -0.5 + r, s, list);
                ts.addBox(-s, -0.5, -s, s, -0.5 + r, 0.5, list);
            } else {
                super.addFrameBoxesToList(i, r, s, ts, list);
            }
        }

        @Override
        protected void addGlassBoxesToList(double r, double s, double w, double[] e, Trans3 t, List list) {
            t.addBox(-e[3], -e[0], -w, -s, e[2], w, list);
            t.addBox(-w, -e[0], s, w, e[2], e[1], list);
        }

        @Override
        public boolean orientOnPlacement(EntityPlayer player, ShapeTE te, ShapeTE nte, EnumFacing face, Vector3 hit) {
            if (nte != null && !player.func_70093_af() && nte.shape.kind instanceof ShapeKind.Window) {
                ShapeKind.Window nsk = (ShapeKind.Window)nte.shape.kind;
                EnumFacing nlf = nte.localFace(face);
                ShapeKind.Window.FrameKind nfk = nsk.frameKindForLocalSide(nlf);
                switch (nfk) {
                    case Corner: {
                        te.setSide(nte.side);
                        te.setTurn(nte.turn);
                        return true;
                    }
                    case Plain: {
                        EnumFacing nfo = nte.globalFace(nsk.frameOrientationForLocalSide(nlf));
                        return this.orientFromAdjacentCorner(te, nfo, hit) || this.orientFromAdjacentCorner(te, BaseUtils.oppositeFacing(nfo), hit);
                    }
                }
            }
            return super.orientOnPlacement(player, te, nte, face, hit);
        }

        protected boolean orientFromAdjacentCorner(ShapeTE te, EnumFacing face, Vector3 hit) {
            EnumFacing nlf;
            ShapeKind.Window nsk;
            ShapeKind.Window.FrameKind nfk;
            ShapeTE nte = ShapeTE.get((IBlockAccess)BaseBlockUtils.getTileEntityWorld(te), te.getPos().offset(BaseUtils.oppositeFacing(face)));
            if (nte != null && nte.shape.kind instanceof ShapeKind.Window && (nfk = (nsk = (ShapeKind.Window)nte.shape.kind).frameKindForLocalSide(nlf = nte.localFace(face))) == ShapeKind.Window.FrameKind.Corner) {
                te.setSide(nte.side);
                te.setTurn(nte.turn);
                return true;
            }
            return false;
        }
    }

    public static class MullionWindow
    extends PlainWindow {
        @Override
        protected void addCentreBoxesToList(double r, double s, Trans3 t, List list) {
            t.addBox(-r, -0.5, -s, r, 0.5, s, list);
        }

        @Override
        protected void addGlassBoxesToList(double r, double s, double w, double[] e, Trans3 t, List list) {
            t.addBox(-e[3], -e[0], -w, -r, e[2], w, list);
            t.addBox(r, -e[0], -w, e[1], e[2], w, list);
        }
    }

    public static class PlainWindow
    extends ShapeKind.Window {
        public PlainWindow() {
            this.frameSides = new EnumFacing[]{BaseDirections.F_DOWN, BaseDirections.F_EAST, BaseDirections.F_UP, BaseDirections.F_WEST};
            this.frameAlways = new boolean[]{false, false, false, false};
            this.frameKinds = new ShapeKind.Window.FrameKind[]{ShapeKind.Window.FrameKind.Plain, ShapeKind.Window.FrameKind.Plain, ShapeKind.Window.FrameKind.None, ShapeKind.Window.FrameKind.None, ShapeKind.Window.FrameKind.Plain, ShapeKind.Window.FrameKind.Plain};
            this.frameOrientations = new EnumFacing[]{BaseDirections.F_EAST, BaseDirections.F_EAST, null, null, BaseDirections.F_UP, BaseDirections.F_UP};
            this.frameTrans = new Trans3[]{Trans3.ident, Trans3.ident.rotZ(90.0), Trans3.ident.rotZ(180.0), Trans3.ident.rotZ(270.0)};
        }

        @Override
        public boolean orientOnPlacement(EntityPlayer player, ShapeTE te, ShapeTE nte, EnumFacing face, Vector3 hit) {
            if (nte != null && !player.func_70093_af()) {
                EnumFacing nlf;
                ShapeKind.Window.FrameKind nfk;
                if (nte.shape.kind instanceof PlainWindow) {
                    te.setSide(nte.side);
                    te.setTurn(nte.turn);
                    return true;
                }
                if (nte.shape.kind instanceof CornerWindow && (nfk = ((ShapeKind.Window)nte.shape.kind).frameKindForLocalSide(nlf = nte.localFace(face))) == ShapeKind.Window.FrameKind.Plain) {
                    EnumFacing lf = BaseUtils.oppositeFacing(face);
                    te.setSide(nte.side);
                    switch (nlf) {
                        case SOUTH: {
                            te.setTurn(BaseUtils.turnToFace(BaseDirections.F_WEST, lf));
                            return true;
                        }
                        case WEST: {
                            te.setTurn(BaseUtils.turnToFace(BaseDirections.F_EAST, lf));
                            return true;
                        }
                    }
                }
            }
            return super.orientOnPlacement(player, te, nte, face, hit);
        }
    }
}

