/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.BaseBlock;
import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseDirections;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseModel;
import gcewing.architecture.BaseTileEntity;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.IBlockState;
import gcewing.architecture.Profile;
import gcewing.architecture.RenderRoof;
import gcewing.architecture.RenderWindow;
import gcewing.architecture.Shape;
import gcewing.architecture.ShapeBlock;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import gcewing.architecture.Utils;
import gcewing.architecture.Vector3;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public abstract class ShapeKind {
    public Object[] profiles;
    public static Roof Roof = new Roof();
    public static Cladding Cladding = new Cladding();

    public Object profileForLocalFace(Shape shape, EnumFacing face) {
        if (this.profiles != null) {
            return this.profiles[face.ordinal()];
        }
        return null;
    }

    public double placementOffsetX() {
        return 0.0;
    }

    public abstract void renderShape(ShapeTE var1, BaseModClient.ITexture[] var2, BaseModClient.IRenderTarget var3, Trans3 var4, boolean var5, boolean var6);

    public ItemStack newStack(Shape shape, IBlockState materialState, int stackSize) {
        return this.newStack(shape, materialState.getBlock(), BaseBlockUtils.getMetaFromBlockState(materialState), stackSize);
    }

    public ItemStack newStack(Shape shape, Block materialBlock, int materialMeta, int stackSize) {
        ShapeTE te = new ShapeTE(shape, materialBlock, materialMeta);
        int light = materialBlock.func_149750_m();
        ItemStack result = BaseTileEntity.blockStackWithTileEntity((Block)ArchitectureCraft.blockShape, stackSize, light, te);
        return result;
    }

    public boolean orientOnPlacement(EntityPlayer player, ShapeTE te, BlockPos npos, IBlockState nstate, TileEntity nte, EnumFacing otherFace, Vector3 hit) {
        if (nte instanceof ShapeTE) {
            return this.orientOnPlacement(player, te, (ShapeTE)nte, otherFace, hit);
        }
        return this.orientOnPlacement(player, te, null, otherFace, hit);
    }

    public boolean orientOnPlacement(EntityPlayer player, ShapeTE te, ShapeTE nte, EnumFacing otherFace, Vector3 hit) {
        Object otherProfile;
        if (nte != null && !player.func_70093_af() && (otherProfile = Profile.getProfileGlobal(nte.shape, nte.side, nte.turn, otherFace)) != null) {
            EnumFacing thisFace = BaseUtils.oppositeFacing(otherFace);
            for (int i = 0; i < 4; ++i) {
                int turn = nte.turn + i & 3;
                Object thisProfile = Profile.getProfileGlobal(te.shape, nte.side, turn, thisFace);
                if (!Profile.matches(thisProfile, otherProfile)) continue;
                te.setSide(nte.side);
                te.setTurn(turn);
                te.setOffsetX(nte.getOffsetX());
                return true;
            }
        }
        return false;
    }

    public boolean canPlaceUpsideDown() {
        return true;
    }

    public double sideZoneSize() {
        return 0.25;
    }

    public boolean highlightZones() {
        return false;
    }

    public void onChiselUse(ShapeTE te, EntityPlayer player, EnumFacing face, Vector3 hit) {
        EnumFacing side = this.zoneHit(face, hit);
        if (side != null) {
            this.chiselUsedOnSide(te, player, side);
        } else {
            this.chiselUsedOnCentre(te, player);
        }
    }

    public void chiselUsedOnSide(ShapeTE te, EntityPlayer player, EnumFacing side) {
        te.toggleConnectionGlobal(side);
    }

    public void chiselUsedOnCentre(ShapeTE te, EntityPlayer player) {
        ItemStack stack;
        if (te.secondaryBlockState != null && (stack = this.newSecondaryMaterialStack(te.secondaryBlockState)) != null) {
            if (!Utils.playerIsInCreativeMode(player)) {
                BaseBlock block = (BaseBlock)te.func_145838_q();
                block.spawnAsEntity(BaseBlockUtils.getTileEntityWorld(te), BaseBlockUtils.getTileEntityPos(te), stack);
            }
            te.setSecondaryMaterial(null);
        }
    }

    protected ItemStack newSecondaryMaterialStack(IBlockState state) {
        if (this.acceptsCladding()) {
            return ArchitectureCraft.itemCladding.newStack(state, 1);
        }
        return null;
    }

    public void onHammerUse(ShapeTE te, EntityPlayer player, EnumFacing face, Vector3 hit) {
        if (player.func_70093_af()) {
            te.setSide((te.side + 1) % 6);
        } else {
            double dx = te.getOffsetX();
            if (dx != 0.0) {
                dx = -dx;
                te.setOffsetX(dx);
            }
            if (dx >= 0.0) {
                te.setTurn((te.turn + 1) % 4);
            }
        }
        te.markChanged();
    }

    public EnumFacing zoneHit(EnumFacing face, Vector3 hit) {
        double r = 0.5 - this.sideZoneSize();
        int dir = face.ordinal();
        if (hit.x <= -r && dir != 4) {
            return BaseDirections.F_WEST;
        }
        if (hit.x >= r && dir != 5) {
            return BaseDirections.F_EAST;
        }
        if (hit.y <= -r && dir != 0) {
            return BaseDirections.F_DOWN;
        }
        if (hit.y >= r && dir != 1) {
            return BaseDirections.F_UP;
        }
        if (hit.z <= -r && dir != 2) {
            return BaseDirections.F_NORTH;
        }
        if (hit.z >= r && dir != 3) {
            return BaseDirections.F_SOUTH;
        }
        return null;
    }

    public boolean acceptsCladding() {
        return false;
    }

    public boolean isValidSecondaryMaterial(IBlockState state) {
        return false;
    }

    public boolean secondaryDefaultsToBase() {
        return false;
    }

    public AxisAlignedBB getBounds(ShapeTE te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        this.addCollisionBoxesToList(te, world, pos, state, entity, t, list);
        return Utils.unionOfBoxes(list);
    }

    public void addCollisionBoxesToList(ShapeTE te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t, List list) {
        int mask = te.shape.occlusionMask;
        int param = mask & 0xFF;
        switch (mask & 0xFF00) {
            case 0: {
                for (int i = 0; i < 8; ++i) {
                    if ((mask & 1 << i) == 0) continue;
                    Vector3 p = new Vector3((i & 1) != 0 ? 0.5 : -0.5, (i & 4) != 0 ? 0.5 : -0.5, (i & 2) != 0 ? 0.5 : -0.5);
                    this.addBox(Vector3.zero, p, t, list);
                }
                break;
            }
            case 256: {
                double r = (double)param / 16.0;
                this.addBox(new Vector3(-r, -0.5, -r), new Vector3(r, 0.5, r), t, list);
                break;
            }
            case 512: {
                double r = (double)param / 32.0;
                this.addBox(new Vector3(-0.5, -0.5, -r), new Vector3(0.5, 0.5, r), t, list);
                break;
            }
            case 768: {
                double r = (double)((param & 0xF) + 1) / 16.0;
                double h = (double)((param >> 4) + 1) / 16.0;
                this.addBox(new Vector3(-0.5, -0.5, 0.5 - r), new Vector3(-0.5 + r, -0.5 + h, 0.5), t, list);
                break;
            }
            case 1024: 
            case 1280: {
                double r = (double)((param & 0xF) + 1) / 16.0;
                double h = (double)((param >> 4) + 1) / 16.0;
                this.addBox(new Vector3(-0.5, -0.5, 0.5 - r), new Vector3(0.5, -0.5 + h, 0.5), t, list);
                if ((mask & 0x100) == 0) break;
                this.addBox(new Vector3(-0.5, -0.5, -0.5), new Vector3(-0.5 + r, -0.5 + h, 0.5), t, list);
                break;
            }
            default: {
                this.addBox(new Vector3(-0.5, -0.5, -0.5), new Vector3(0.5, 0.5, 0.5), t, list);
            }
        }
    }

    protected void addBox(Vector3 p0, Vector3 p1, Trans3 t, List list) {
        t.addBox(p0, p1, list);
    }

    public static Model Model(String name) {
        return new Model(name, null);
    }

    public static Model Model(String name, Object[] profiles) {
        return new Model(name, profiles);
    }

    public static Model Banister(String name) {
        return new Banister(name);
    }

    public static class Banister
    extends Model {
        private static EnumFacing[] stairsFacingMap = new EnumFacing[]{BaseDirections.F_WEST, BaseDirections.F_EAST, BaseDirections.F_SOUTH, BaseDirections.F_NORTH};

        public Banister(String modelName) {
            super(modelName, (Object[])Profile.Generic.tbOffset);
        }

        @Override
        public boolean orientOnPlacement(EntityPlayer player, ShapeTE te, BlockPos npos, IBlockState nstate, TileEntity nte, EnumFacing otherFace, Vector3 hit) {
            if (!player.func_70093_af()) {
                int side;
                Block nblock = nstate.getBlock();
                boolean placedOnStair = false;
                int nside = -1;
                int nturn = -1;
                if (nblock instanceof BlockStairs && (otherFace == BaseDirections.F_UP || otherFace == BaseDirections.F_DOWN)) {
                    placedOnStair = true;
                    nside = Banister.stairsSide(nstate);
                    nturn = BaseUtils.turnToFace(BaseDirections.F_SOUTH, Banister.stairsFacing(nstate));
                    if (nside == 1 && (nturn & 1) == 0) {
                        nturn ^= 2;
                    }
                } else if (nblock instanceof ShapeBlock && nte instanceof ShapeTE) {
                    placedOnStair = true;
                    nside = ((ShapeTE)nte).side;
                    nturn = ((ShapeTE)nte).turn;
                }
                if (placedOnStair && (side = BaseUtils.oppositeFacing(otherFace).ordinal()) == nside) {
                    Vector3 h = Trans3.sideTurn(side, 0).ip(hit);
                    double offx = te.shape.offsetXForPlacementHit(side, nturn, hit);
                    te.setSide(side);
                    te.setTurn(nturn & 3);
                    te.setOffsetX(offx);
                    return true;
                }
            }
            return super.orientOnPlacement(player, te, npos, nstate, nte, otherFace, hit);
        }

        private static EnumFacing stairsFacing(IBlockState state) {
            int meta = BaseBlockUtils.getMetaFromBlockState(state);
            return stairsFacingMap[meta & 3];
        }

        private static int stairsSide(IBlockState state) {
            int meta = BaseBlockUtils.getMetaFromBlockState(state);
            return meta >> 2 & 1;
        }

        @Override
        public double placementOffsetX() {
            return 0.375;
        }
    }

    public static class Cladding
    extends ShapeKind {
        @Override
        public void renderShape(ShapeTE te, BaseModClient.ITexture[] textures, BaseModClient.IRenderTarget target, Trans3 t, boolean renderBase, boolean renderSecondary) {
        }

        @Override
        public ItemStack newStack(Shape shape, Block materialBlock, int materialMeta, int stackSize) {
            return ArchitectureCraft.itemCladding.newStack(materialBlock, materialMeta, stackSize);
        }
    }

    public static abstract class Window
    extends ShapeKind {
        public EnumFacing[] frameSides;
        public boolean[] frameAlways;
        public FrameKind[] frameKinds;
        public EnumFacing[] frameOrientations;
        public Trans3[] frameTrans;

        @Override
        public boolean orientOnPlacement(EntityPlayer player, ShapeTE te, ShapeTE nte, EnumFacing otherFace, Vector3 hit) {
            int turn = -1;
            if (!(player.func_70093_af() || nte != null && nte.shape.kind instanceof Window)) {
                switch (otherFace.ordinal()) {
                    case 4: 
                    case 5: {
                        turn = 0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        turn = 1;
                    }
                }
            }
            if (turn >= 0) {
                te.setSide(0);
                te.setTurn(turn);
                return true;
            }
            return false;
        }

        public FrameKind frameKindForLocalSide(EnumFacing side) {
            return this.frameKinds[side.ordinal()];
        }

        public EnumFacing frameOrientationForLocalSide(EnumFacing side) {
            return this.frameOrientations[side.ordinal()];
        }

        @Override
        public boolean canPlaceUpsideDown() {
            return false;
        }

        @Override
        public double sideZoneSize() {
            return 0.125;
        }

        @Override
        public boolean highlightZones() {
            return true;
        }

        @Override
        public void renderShape(ShapeTE te, BaseModClient.ITexture[] textures, BaseModClient.IRenderTarget target, Trans3 t, boolean renderBase, boolean renderSecondary) {
            new RenderWindow(te, textures, t, target, renderBase, renderSecondary).render();
        }

        @Override
        protected ItemStack newSecondaryMaterialStack(IBlockState state) {
            return BaseBlockUtils.blockStackWithState(state, 1);
        }

        @Override
        public boolean isValidSecondaryMaterial(IBlockState state) {
            Block block = state.getBlock();
            return block == Blocks.field_150410_aZ || block == Blocks.field_150397_co;
        }

        @Override
        public void addCollisionBoxesToList(ShapeTE te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t, List list) {
            double r = 0.125;
            double s = 0.09375;
            double[] e = new double[4];
            this.addCentreBoxesToList(0.125, 0.09375, t, list);
            for (int i = 0; i <= 3; ++i) {
                boolean frame;
                boolean bl = frame = this.frameAlways[i] || !this.isConnectedGlobal(te, t.t(this.frameSides[i]));
                if (entity == null || frame) {
                    Trans3 ts = t.t(this.frameTrans[i]);
                    this.addFrameBoxesToList(i, 0.125, 0.09375, ts, list);
                }
                e[i] = frame ? 0.375 : 0.5;
            }
            if (te.secondaryBlockState != null) {
                this.addGlassBoxesToList(0.125, 0.09375, 0.03125, e, t, list);
            }
        }

        protected void addCentreBoxesToList(double r, double s, Trans3 t, List list) {
        }

        protected void addFrameBoxesToList(int i, double r, double s, Trans3 ts, List list) {
            ts.addBox(-0.5, -0.5, -s, 0.5, -0.5 + r, s, list);
        }

        protected void addGlassBoxesToList(double r, double s, double w, double[] e, Trans3 t, List list) {
            t.addBox(-e[3], -e[0], -w, e[1], e[2], w, list);
        }

        protected boolean isConnectedGlobal(ShapeTE te, EnumFacing globalDir) {
            return this.getConnectedWindowGlobal(te, globalDir) != null;
        }

        public ShapeTE getConnectedWindowGlobal(ShapeTE te, EnumFacing globalDir) {
            EnumFacing thisLocalDir = te.localFace(globalDir);
            FrameKind thisFrameKind = this.frameKindForLocalSide(thisLocalDir);
            if (thisFrameKind != FrameKind.None) {
                EnumFacing otherLocalDir;
                Window otherKind;
                FrameKind otherFrameKind;
                EnumFacing thisOrient = this.frameOrientationForLocalSide(thisLocalDir);
                ShapeTE nte = te.getConnectedNeighbourGlobal(globalDir);
                if (nte != null && nte.shape.kind instanceof Window && (otherFrameKind = (otherKind = (Window)nte.shape.kind).frameKindForLocalSide(otherLocalDir = nte.localFace(BaseUtils.oppositeFacing(globalDir)))) != FrameKind.None) {
                    EnumFacing otherOrient = otherKind.frameOrientationForLocalSide(otherLocalDir);
                    if (this.framesMatch(thisFrameKind, otherFrameKind, te.globalFace(thisOrient), nte.globalFace(otherOrient))) {
                        return nte;
                    }
                }
            }
            return null;
        }

        protected boolean framesMatch(FrameKind kind1, FrameKind kind2, EnumFacing orient1, EnumFacing orient2) {
            if (kind1 == kind2) {
                switch (kind1) {
                    case Plain: {
                        return BaseUtils.facingAxesEqual(orient1, orient2);
                    }
                }
                return orient1 == orient2;
            }
            return false;
        }

        public static enum FrameKind {
            None,
            Plain,
            Corner;

        }
    }

    public static class Model
    extends ShapeKind {
        protected String modelName;
        private BaseModClient.IModel model;

        public Model(String name, Object[] profiles) {
            this.modelName = "shape/" + name + ".smeg";
            this.profiles = profiles;
        }

        @Override
        public boolean secondaryDefaultsToBase() {
            return true;
        }

        @Override
        public AxisAlignedBB getBounds(ShapeTE te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t) {
            return t.t(this.getModel().getBounds());
        }

        @Override
        public void renderShape(ShapeTE te, BaseModClient.ITexture[] textures, BaseModClient.IRenderTarget target, Trans3 t, boolean renderBase, boolean renderSecondary) {
            BaseModClient.IModel model = this.getModel();
            model.render(t, target, textures);
        }

        protected BaseModClient.IModel getModel() {
            if (this.model == null) {
                this.model = ArchitectureCraft.mod.getModel(this.modelName);
            }
            return this.model;
        }

        @Override
        public boolean acceptsCladding() {
            BaseModel model = (BaseModel)this.getModel();
            for (BaseModel.Face face : model.faces) {
                if (face.texture < 2) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addCollisionBoxesToList(ShapeTE te, IBlockAccess world, BlockPos pos, IBlockState state, Entity entity, Trans3 t, List list) {
            if (te.shape.occlusionMask == 0) {
                this.getModel().addBoxesToList(t, list);
            } else {
                super.addCollisionBoxesToList(te, world, pos, state, entity, t, list);
            }
        }

        @Override
        public double placementOffsetX() {
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            this.getModel().addBoxesToList(Trans3.ident, list);
            AxisAlignedBB bounds = Utils.unionOfBoxes(list);
            if (Shape.debugPlacement) {
                for (AxisAlignedBB box : list) {
                    System.out.printf("ShapeKind.Model.placementOffsetX: %s\n", box);
                }
                System.out.printf("ShapeKind.Model.placementOffsetX: bounds = %s\n", bounds);
            }
            return 0.5 * (1.0 - (bounds.field_72336_d - bounds.field_72340_a));
        }
    }

    public static class Roof
    extends ShapeKind {
        @Override
        public boolean acceptsCladding() {
            return true;
        }

        @Override
        public boolean secondaryDefaultsToBase() {
            return true;
        }

        @Override
        public void renderShape(ShapeTE te, BaseModClient.ITexture[] textures, BaseModClient.IRenderTarget target, Trans3 t, boolean renderBase, boolean renderSecondary) {
            new RenderRoof(te, textures, t, target, renderBase, renderSecondary).render();
        }

        @Override
        public Object profileForLocalFace(Shape shape, EnumFacing face) {
            int dir = face.ordinal();
            switch (shape) {
                case RoofTile: 
                case RoofOverhang: {
                    switch (dir) {
                        case 5: {
                            return RoofProfile.Left;
                        }
                        case 4: {
                            return RoofProfile.Right;
                        }
                    }
                    break;
                }
                case RoofOuterCorner: 
                case RoofOverhangOuterCorner: {
                    switch (dir) {
                        case 3: {
                            return RoofProfile.Left;
                        }
                        case 4: {
                            return RoofProfile.Right;
                        }
                    }
                    break;
                }
                case RoofInnerCorner: 
                case RoofOverhangInnerCorner: {
                    switch (dir) {
                        case 5: {
                            return RoofProfile.Left;
                        }
                        case 2: {
                            return RoofProfile.Right;
                        }
                    }
                    break;
                }
                case RoofRidge: 
                case RoofSmartRidge: 
                case RoofOverhangRidge: {
                    return RoofProfile.Ridge;
                }
                case RoofValley: 
                case RoofSmartValley: 
                case RoofOverhangValley: {
                    return RoofProfile.Valley;
                }
            }
            return RoofProfile.None;
        }

        static {
            Profile.declareOpposite((Object)RoofProfile.Left, (Object)RoofProfile.Right);
        }

        protected static enum RoofProfile {
            None,
            Left,
            Right,
            Ridge,
            Valley;

        }
    }
}

