/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.gui;

import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.gui.GuiCommon;
import bre.smoothfont.gui.GuiConfigScreen;
import bre.smoothfont.gui.GuiScreenEx;
import bre.smoothfont.gui.GuiSliderEx;
import bre.smoothfont.util.GLUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiConfigAdvanced
extends GuiScreenEx {
    private static final int dx = -160;
    private static final int btnGap = 4;
    private static final int bx = 158;
    private static final int by = 20;
    private static final int rowOfParts = 6;
    private static final int gridHeight = 24;
    private static final int sampleHeight = 70;
    private int baseY;
    private int sampleScaleFactor = 4;

    public GuiConfigAdvanced(GuiScreen parent) {
        super(parent);
    }

    public void func_73866_w_() {
        boolean featuresEnabled = CommonConfig.currentConfig.runMode == 0;
        this.field_146292_n.clear();
        this.baseY = this.field_146295_m / 2 - 107;
        Object btn = this.arrangeHalfButton(GuiPart.BTN_ENABLE_ALPHABLEND, I18n.func_135052_a((String)"smoothfont.config.menu.enableAlphaBlend", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.enableAlphaBlend));
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled;
        btn = this.arrangeHalfButton(GuiPart.BTN_ALLOW_NPOT_TEXTURE, I18n.func_135052_a((String)"smoothfont.config.menu.allowNPOTTexture", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.allowNPOTTexture));
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled;
        btn = this.arrangeHalfButton(GuiPart.BTN_ENABLE_MIPMAP, I18n.func_135052_a((String)"smoothfont.config.menu.enableMipmap", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.enableMipmap));
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled;
        btn = this.arrangeHalfButton(GuiPart.BTN_ENABLE_ANISOTROPIC, I18n.func_135052_a((String)"smoothfont.config.menu.enableAnisotropicFilter", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.enableAnisotropicFilter));
        this.field_146292_n.add(btn);
        btn.field_146124_l = GLUtils.anisotropicFilterSupported && !CommonConfig.currentConfig.performanceMode && featuresEnabled;
        btn = this.arrangeHalfSlider(GuiPart.SLD_MIPMAP_LOD_BIAS, I18n.func_135052_a((String)"smoothfont.config.menu.mipmapLodBias", (Object[])new Object[0]) + ": ", "", -10, 10, CommonConfig.currentConfig.mipmapLodBias, null, 0, false, false);
        this.field_146292_n.add(btn);
        btn.field_146124_l = !CommonConfig.currentConfig.performanceMode && featuresEnabled && CommonConfig.currentConfig.enableMipmap;
        btn = this.arrangeHalfSlider(GuiPart.SLD_OVERLAY_LOD_BIAS, I18n.func_135052_a((String)"smoothfont.config.menu.overlayLodBias", (Object[])new Object[0]) + ": ", "", -10, 10, CommonConfig.currentConfig.overlayLodBias, null, 0, false, false);
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled && CommonConfig.currentConfig.enableMipmap;
        btn = this.arrangeHalfButton(GuiPart.BTN_FORCE_UNICODE, I18n.func_135052_a((String)"smoothfont.config.menu.forceUnicode", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.forceUnicode));
        this.field_146292_n.add(btn);
        btn.field_146124_l = featuresEnabled;
        btn = this.arrangeHalfButton(GuiPart.BTN_REMOVE_SCALE_RESTRICTION, I18n.func_135052_a((String)"smoothfont.config.menu.removeScaleRestriction", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.globalConfig.tweakScaledResolution & CommonConfig.currentConfig.removeScaleRestriction));
        this.field_146292_n.add(btn);
        btn.field_146124_l = CommonConfig.globalConfig.tweakScaledResolution;
        btn = this.arrangeHalfButton(GuiPart.BTN_ALTERNATIVE_INTERPOLATION, I18n.func_135052_a((String)"smoothfont.config.menu.alternativeInterpolation", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.globalConfig.tweakLoadTexture & CommonConfig.currentConfig.alternativeInterpolation));
        this.field_146292_n.add(btn);
        btn.field_146124_l = CommonConfig.globalConfig.tweakLoadTexture;
        this.field_146292_n.add(this.arrangeHalfButton(GuiPart.BTN_DONE, I18n.func_135052_a((String)"smoothfont.config.menu.done", (Object[])new Object[0])));
        btn = this.customButton(GuiPart.BTN_CHANGE_CONFIG, I18n.func_135052_a((String)("smoothfont.config.menu." + (CommonConfig.isPlayerConfig() ? "playerConfig" : "globalConfig")), (Object[])new Object[0]), this.field_146294_l - 80, 0, 80, 20);
        this.field_146292_n.add(btn);
        btn.field_146124_l = false;
        btn = this.customButton(GuiPart.BTN_RUN_MODE, I18n.func_135052_a((String)("smoothfont.config.menu.runMode." + CommonConfig.currentConfig.runMode), (Object[])new Object[0]), 0, 0, 80, 20);
        this.field_146292_n.add(btn);
        btn.field_146124_l = false;
    }

    private GuiButton arrangeHalfButton(GuiPart guiPart, String buttonLabel) {
        int id = guiPart.ordinal();
        GuiButton button = new GuiButton(id, this.field_146294_l / 2 + ((id & 1) == 0 ? -160 : 2), this.baseY + 24 * ((id >>> 1) + 1), 158, 20, buttonLabel);
        this.hoverCheckerMap.put(guiPart, new HoverChecker(button, 500));
        return button;
    }

    private GuiButton customButton(GuiPart guiPart, String buttonLabel, int posX, int posY, int width, int height) {
        int id = guiPart.ordinal();
        GuiButton button = new GuiButton(id, posX, posY, width, height, buttonLabel);
        this.hoverCheckerMap.put(guiPart, new HoverChecker(button, 500));
        return button;
    }

    private GuiSliderEx arrangeHalfSlider(GuiPart guiPart, String sliderLabel, String suffix, int minVal, int maxVal, int curVal, String normalStr, int normalVal, boolean showDec, boolean showPercent) {
        int id = guiPart.ordinal();
        GuiSliderEx slider = new GuiSliderEx(id, this.field_146294_l / 2 + ((id & 1) == 0 ? -160 : 2), this.baseY + 24 * ((id >>> 1) + 1), 158, 20, sliderLabel, suffix, minVal, maxVal, curVal, showDec, showPercent, true, normalStr, normalVal){

            @Override
            protected void valueChanged() {
                try {
                    GuiConfigAdvanced.this.func_146284_a((GuiButton)this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.hoverCheckerMap.put(guiPart, new HoverChecker((GuiButton)slider, 500));
        return slider;
    }

    public void func_146284_a(GuiButton button) {
        GuiPart[] guiPartArray = GuiPart.values();
        GuiPart guiPart = guiPartArray[button.field_146127_k];
        switch (guiPart) {
            case BTN_ENABLE_ALPHABLEND: {
                CommonConfig.currentConfig.enableAlphaBlend = !CommonConfig.currentConfig.enableAlphaBlend;
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.enableAlphaBlend", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.enableAlphaBlend);
                CommonConfig.saveCurrentConfig();
                break;
            }
            case BTN_ALLOW_NPOT_TEXTURE: {
                CommonConfig.currentConfig.allowNPOTTexture = !CommonConfig.currentConfig.allowNPOTTexture;
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.allowNPOTTexture", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.allowNPOTTexture);
                CommonConfig.saveCurrentConfig();
                FontTextureManager.getInstance().func_110549_a(this.field_146297_k.func_110442_L());
                break;
            }
            case BTN_ENABLE_MIPMAP: {
                CommonConfig.currentConfig.enableMipmap = !CommonConfig.currentConfig.enableMipmap;
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.enableMipmap", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.enableMipmap);
                FontRendererHook.texFilterSettingId = FontUtils.getTexFilterSettingId();
                CommonConfig.saveCurrentConfig();
                this.func_73866_w_();
                FontTextureManager.getInstance().func_110549_a(this.field_146297_k.func_110442_L());
                break;
            }
            case BTN_ENABLE_ANISOTROPIC: {
                CommonConfig.currentConfig.enableAnisotropicFilter = !CommonConfig.currentConfig.enableAnisotropicFilter;
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.enableAnisotropicFilter", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.enableAnisotropicFilter);
                CommonConfig.saveCurrentConfig();
                break;
            }
            case SLD_MIPMAP_LOD_BIAS: {
                CommonConfig.currentConfig.mipmapLodBias = ((GuiSliderEx)button).getValueInt();
                CommonConfig.currentConfig.updateCalculatedValues();
                CommonConfig.saveCurrentConfig();
                break;
            }
            case SLD_OVERLAY_LOD_BIAS: {
                CommonConfig.currentConfig.overlayLodBias = ((GuiSliderEx)button).getValueInt();
                CommonConfig.currentConfig.updateCalculatedValues();
                CommonConfig.saveCurrentConfig();
                break;
            }
            case BTN_FORCE_UNICODE: {
                CommonConfig.currentConfig.forceUnicode = !CommonConfig.currentConfig.forceUnicode;
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.forceUnicode", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.forceUnicode);
                CommonConfig.saveCurrentConfig();
                if (!CommonConfig.currentConfig.forceUnicode) break;
                FontTextureManager.getInstance().setUnicodeFlagAll();
                break;
            }
            case BTN_REMOVE_SCALE_RESTRICTION: {
                CommonConfig.currentConfig.removeScaleRestriction = !CommonConfig.currentConfig.removeScaleRestriction;
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.removeScaleRestriction", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.removeScaleRestriction);
                CommonConfig.saveCurrentConfig();
                ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
                int x = scaledresolution.func_78326_a();
                int y = scaledresolution.func_78328_b();
                this.func_146280_a(this.field_146297_k, x, y);
                break;
            }
            case BTN_ALTERNATIVE_INTERPOLATION: {
                CommonConfig.currentConfig.alternativeInterpolation = !CommonConfig.currentConfig.alternativeInterpolation;
                button.field_146126_j = I18n.func_135052_a((String)"smoothfont.config.menu.alternativeInterpolation", (Object[])new Object[0]) + ": " + GuiCommon.getStringOnOff(CommonConfig.currentConfig.alternativeInterpolation);
                CommonConfig.saveCurrentConfig();
                this.field_146297_k.func_110436_a();
                break;
            }
            case BTN_DONE: {
                this.field_146297_k.func_147108_a(this.parentScreen);
                if (this.parentScreen != null) break;
                this.field_146297_k.func_71381_h();
                break;
            }
        }
    }

    public void func_146286_b(int mouseX, int mouseY, int which) {
        super.func_146286_b(mouseX, mouseY, which);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"smoothfont.config.menu.title.advanced", (Object[])new Object[0]), this.field_146294_l / 2, this.baseY + 8, 0xFFFFFF);
        int scaleFactor = this.getSampleScaleFactor();
        GuiCommon.drawSamples(this, this.field_146294_l / 2, this.baseY + 144, scaleFactor);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawTooltip(mouseX, mouseY);
    }

    public boolean func_73868_f() {
        return true;
    }

    private void drawTooltip(int mouseX, int mouseY) {
        block12: for (GuiPart gp : GuiPart.values()) {
            HoverChecker hoverChecker = (HoverChecker)this.hoverCheckerMap.get((Object)gp);
            if (hoverChecker == null || !hoverChecker.checkHover(mouseX, mouseY)) continue;
            switch (gp) {
                case BTN_ENABLE_ALPHABLEND: {
                    this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.enableAlphaBlend", (Object[])new Object[0])), mouseX, mouseY);
                    continue block12;
                }
                case BTN_ALLOW_NPOT_TEXTURE: {
                    this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.allowNPOTTexture", (Object[])new Object[0])), mouseX, mouseY);
                    continue block12;
                }
                case BTN_ENABLE_MIPMAP: {
                    this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.enableMipmap", (Object[])new Object[0])), mouseX, mouseY);
                    continue block12;
                }
                case BTN_ENABLE_ANISOTROPIC: {
                    this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.enableAnisotropicFilter", (Object[])new Object[0])), mouseX, mouseY);
                    continue block12;
                }
                case SLD_MIPMAP_LOD_BIAS: {
                    this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.mipmapLodBias", (Object[])new Object[0])), mouseX, mouseY);
                    continue block12;
                }
                case SLD_OVERLAY_LOD_BIAS: {
                    this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.overlayLodBias", (Object[])new Object[0])), mouseX, mouseY);
                    continue block12;
                }
                case BTN_FORCE_UNICODE: {
                    this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.forceUnicode", (Object[])new Object[0])), mouseX, mouseY);
                    continue block12;
                }
                case BTN_REMOVE_SCALE_RESTRICTION: {
                    this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.removeScaleRestriction", (Object[])new Object[0])), mouseX, mouseY);
                    continue block12;
                }
                case BTN_ALTERNATIVE_INTERPOLATION: {
                    this.func_146283_a(this.strToList(I18n.func_135052_a((String)"smoothfont.tooltip.alternativeInterpolation", (Object[])new Object[0])), mouseX, mouseY);
                    continue block12;
                }
                case BTN_DONE: {
                    continue block12;
                }
            }
        }
    }

    private List strToList(String str) {
        return GuiCommon.strToList(this.field_146289_q, Math.min(200, this.field_146294_l / 2 - 20), str);
    }

    @Override
    public void func_146274_d() throws IOException {
        int i;
        super.func_146274_d();
        if (this.getFocusedSlider() == null && (i = Mouse.getEventDWheel()) != 0) {
            int scaleFactor = this.getSampleScaleFactor();
            scaleFactor = i > 0 ? ++scaleFactor : --scaleFactor;
            if (scaleFactor < 1) {
                scaleFactor = 1;
            }
            if (scaleFactor > 16) {
                scaleFactor = 16;
            }
            this.setSampleScaleFactor(scaleFactor);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 2) {
            this.setSampleScaleFactor(4);
        }
    }

    private int getSampleScaleFactor() {
        if (this.parentScreen instanceof GuiConfigScreen) {
            return ((GuiConfigScreen)this.parentScreen).sampleScaleFactor;
        }
        return this.sampleScaleFactor;
    }

    private void setSampleScaleFactor(int factor) {
        if (this.parentScreen instanceof GuiConfigScreen) {
            ((GuiConfigScreen)this.parentScreen).sampleScaleFactor = factor;
        } else {
            this.sampleScaleFactor = factor;
        }
    }

    private static enum GuiPart {
        BTN_ENABLE_ALPHABLEND,
        BTN_ALLOW_NPOT_TEXTURE,
        BTN_ENABLE_MIPMAP,
        BTN_ENABLE_ANISOTROPIC,
        SLD_MIPMAP_LOD_BIAS,
        SLD_OVERLAY_LOD_BIAS,
        BTN_FORCE_UNICODE,
        BTN_REMOVE_SCALE_RESTRICTION,
        BTN_ALTERNATIVE_INTERPOLATION,
        BTN_DONE,
        BTN_CHANGE_CONFIG,
        BTN_RUN_MODE;

    }
}

