/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer;

import io.github.lxgaming.sledgehammer.configuration.Config;
import io.github.lxgaming.sledgehammer.configuration.Configuration;
import io.github.lxgaming.sledgehammer.configuration.category.GeneralCategory;
import io.github.lxgaming.sledgehammer.launch.SledgehammerLaunch;
import io.github.lxgaming.sledgehammer.manager.MappingManager;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Sledgehammer {
    public static final String ID = "sledgehammer";
    public static final String NAME = "Sledgehammer";
    public static final String VERSION = "1.12.2-2.0.8";
    public static final String DESCRIPTION = "Smashes the stupid out of the client & server.";
    public static final String AUTHORS = "LX_Gaming";
    public static final String SOURCE = "https://github.io/LXGaming/Sledgehammer";
    public static final String WEBSITE = "https://lxgaming.github.io/";
    public static final String ACCEPTED_VERSIONS = "[1.12.2]";
    public static final String ACCEPTABLE_REMOTE_VERSIONS = "*";
    public static final String CERTIFICATE_FINGERPRINT = "565fa4dbf20e7c3c4423950ca8e0bdabf7568796";
    private static Sledgehammer instance;
    private final Logger logger;
    private final Configuration configuration;

    private Sledgehammer() {
        instance = this;
        this.logger = LogManager.getLogger((String)NAME);
        this.configuration = new Configuration(Paths.get("config", new String[0]).resolve("sledgehammer.conf"));
    }

    public static boolean init() {
        if (Sledgehammer.getInstance() != null) {
            return false;
        }
        SledgehammerLaunch.configureEnvironment();
        Sledgehammer sledgehammer = new Sledgehammer();
        if (!sledgehammer.reload()) {
            return false;
        }
        MappingManager.prepare();
        return true;
    }

    public boolean reload() {
        this.getConfiguration().loadConfiguration();
        if (!this.getConfig().isPresent()) {
            return false;
        }
        this.getConfiguration().saveConfiguration();
        return true;
    }

    public void debug(String format, Object ... arguments) {
        if (this.getConfig().map(Config::getGeneralCategory).map(GeneralCategory::isDebug).orElse(false).booleanValue()) {
            this.getLogger().info(format, arguments);
        }
    }

    public static Sledgehammer getInstance() {
        return instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Optional<Config> getConfig() {
        return Optional.ofNullable(this.getConfiguration().getConfig());
    }
}

