/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.ftbq;

import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.reward.Reward;
import com.feed_the_beast.ftbquests.quest.task.Task;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import java.util.List;
import java.util.stream.Collectors;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import youyihj.zenutils.api.ftbq.CTChapter;
import youyihj.zenutils.api.ftbq.CTQuestObjectBase;
import youyihj.zenutils.api.ftbq.CTReward;
import youyihj.zenutils.api.ftbq.CTTask;

@ZenRegister
@ZenClass(value="mods.zenutils.ftbq.Quest")
@ModOnly(value="ftbquests")
public class CTQuest
extends CTQuestObjectBase {
    private final Quest quest;

    public CTQuest(Quest quest) {
        super((QuestObjectBase)quest);
        this.quest = quest;
    }

    @ZenGetter(value="chapter")
    public CTChapter getChapter() {
        return new CTChapter(this.quest.getChapter());
    }

    @ZenGetter(value="x")
    public double getX() {
        return this.quest.getX();
    }

    @ZenGetter(value="y")
    public double getY() {
        return this.quest.getY();
    }

    @ZenGetter(value="width")
    public double getWidth() {
        return this.quest.getWidth();
    }

    @ZenGetter(value="height")
    public double getHeight() {
        return this.quest.getHeight();
    }

    @ZenGetter(value="tasks")
    public List<CTTask> getTasks() {
        return this.quest.tasks.stream().map(CTTask::new).collect(Collectors.toList());
    }

    @ZenGetter(value="rewards")
    public List<CTReward> getRewards() {
        return this.quest.rewards.stream().map(CTReward::new).collect(Collectors.toList());
    }

    @ZenGetter(value="dependencies")
    public List<CTQuestObjectBase> getDependencies() {
        return this.quest.dependencies.stream().map(CTQuest::getQuestObject).collect(Collectors.toList());
    }

    @ZenGetter(value="subtitle")
    public String getSubtitle() {
        return this.quest.getSubtitle();
    }

    @ZenGetter(value="description")
    public String[] getDescription() {
        return this.quest.getDescription();
    }

    @ZenGetter(value="shape")
    public String getShape() {
        return this.quest.getShape();
    }

    @ZenGetter
    public boolean canRepeat() {
        return this.quest.canRepeat;
    }

    @ZenGetter
    public String disableJEI() {
        return this.quest.disableJEI.func_176610_l();
    }

    private static CTQuestObjectBase getQuestObject(QuestObjectBase obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Task) {
            return new CTTask((Task)obj);
        }
        if (obj instanceof Quest) {
            return new CTQuest((Quest)obj);
        }
        if (obj instanceof Chapter) {
            return new CTChapter((Chapter)obj);
        }
        if (obj instanceof Reward) {
            return new CTReward((Reward)obj);
        }
        return new CTQuestObjectBase(obj);
    }
}

