/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.command;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.server.IServer;
import crafttweaker.mc1120.server.MCServer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;
import youyihj.zenutils.api.command.ICommandExecute;
import youyihj.zenutils.api.command.IGetCommandUsage;
import youyihj.zenutils.api.command.IGetTabCompletion;
import youyihj.zenutils.api.command.IZenCommand;
import youyihj.zenutils.api.command.TabCompletion;
import youyihj.zenutils.api.command.TabCompletionCase;
import youyihj.zenutils.api.command.ZenUtilsCommandSender;

@ZenRegister
@ZenClass(value="mods.zenutils.command.ZenCommand")
public class ZenCommand
extends CommandBase
implements IZenCommand {
    private final String name;
    @ZenProperty
    public ICommandExecute execute = (command, server, sender, args) -> {};
    @ZenProperty
    public IGetCommandUsage getCommandUsage = IGetCommandUsage.UNDEFINED;
    @ZenProperty
    public IGetTabCompletion[] tabCompletionGetters = new IGetTabCompletion[0];
    @ZenProperty
    @Deprecated
    public TabCompletion tabCompletion = null;
    @ZenProperty
    public int requiredPermissionLevel = 4;

    private ZenCommand(@Nonnull String name) {
        this.name = name;
    }

    @ZenMethod
    public static ZenCommand create(@Nonnull String name) {
        return new ZenCommand(name);
    }

    @ZenGetter(value="name")
    @Nonnull
    public String func_71517_b() {
        return this.name;
    }

    @ZenMethod
    @Nonnull
    public String func_71518_a(ICommandSender sender) {
        return this.getCommandUsage.getCommandUsage(new ZenUtilsCommandSender(sender));
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        this.execute.execute(this, (IServer)new MCServer(server), new ZenUtilsCommandSender(sender), args);
    }

    public int func_82362_a() {
        return this.requiredPermissionLevel;
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (this.tabCompletionGetters.length == 0 && this.tabCompletion != null) {
            return this.getTabCompletionsDeprecated(server, sender, args, targetPos);
        }
        int index = args.length - 1;
        if (index >= this.tabCompletionGetters.length || index < 0) {
            return Collections.emptyList();
        }
        try {
            return ZenCommand.func_175762_a((String[])args, this.tabCompletionGetters[index].get((IServer)new MCServer(server), new ZenUtilsCommandSender(sender), CraftTweakerMC.getIBlockPos((BlockPos)targetPos)).getInner());
        }
        catch (CommandException e) {
            return Collections.emptyList();
        }
    }

    @Nonnull
    private List<String> getTabCompletionsDeprecated(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        Objects.requireNonNull(this.tabCompletion);
        int index = args.length - 1;
        List<String> emptyList = Collections.emptyList();
        if (index >= this.tabCompletion.getInfo().length || index < 0) {
            return emptyList;
        }
        switch (this.tabCompletion.getInfo()[index]) {
            case "empty": {
                return emptyList;
            }
            case "item": {
                return ZenCommand.func_175762_a((String[])args, (Collection)Item.field_150901_e.func_148742_b());
            }
            case "block": {
                return ZenCommand.func_175762_a((String[])args, (Collection)Block.field_149771_c.func_148742_b());
            }
            case "player": {
                return ZenCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            case "potion": {
                return ZenCommand.func_175762_a((String[])args, (Collection)Potion.field_188414_b.func_148742_b());
            }
            case "x": {
                return targetPos == null ? emptyList : Collections.singletonList(String.valueOf(targetPos.func_177958_n()));
            }
            case "y": {
                return targetPos == null ? emptyList : Collections.singletonList(String.valueOf(targetPos.func_177956_o()));
            }
            case "z": {
                return targetPos == null ? emptyList : Collections.singletonList(String.valueOf(targetPos.func_177952_p()));
            }
        }
        return ZenCommand.func_175762_a((String[])args, (Collection)TabCompletionCase.cases.getOrDefault(this.tabCompletion.getInfo()[index], emptyList));
    }

    @Override
    public void register() {
        IZenCommand.super.register();
        if (this.tabCompletion != null) {
            CraftTweakerAPI.logWarning((String)"Found deprecated member tabCompletion is still used! You are supposed to use `IGetTabCompletion[] tabCompletionGetters`.");
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (this.func_82362_a() == 0) {
            return true;
        }
        return super.func_184882_a(server, sender);
    }
}

