/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.tile;

import appeng.api.AEApi;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import thaumicenergistics.api.IThELangKey;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.integration.appeng.grid.GridUtil;
import thaumicenergistics.integration.appeng.grid.IThEGridHost;
import thaumicenergistics.integration.appeng.grid.ThEGridBlock;
import thaumicenergistics.integration.appeng.util.ThEActionSource;
import thaumicenergistics.tile.TileBase;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.IThEGridNodeBlock;
import thaumicenergistics.util.IThEOwnable;

public abstract class TileNetwork
extends TileBase
implements IThEGridHost,
IActionHost,
IPowerChannelState,
IThEOwnable,
IThEGridNodeBlock {
    protected ThEGridBlock gridBlock = new ThEGridBlock((IThEGridHost)this, this, true);
    protected IGridNode gridNode;
    protected ThEActionSource src = new ThEActionSource(this);
    protected EntityPlayer owner;
    protected boolean isPowered = false;
    protected boolean isActive = false;

    @Override
    public ThEGridBlock getGridBlock() {
        return this.gridBlock;
    }

    @Override
    public IGridNode getGridNode() {
        return this.gridNode;
    }

    public void func_145843_s() {
        if (this.gridNode != null) {
            this.gridNode.destroy();
            this.gridNode = null;
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.func_145843_s();
    }

    @Nullable
    public IGridNode getGridNode(@Nonnull AEPartLocation aePartLocation) {
        return this.getActionableNode();
    }

    @Nonnull
    public AECableType getCableConnectionType(@Nonnull AEPartLocation aePartLocation) {
        return AECableType.SMART;
    }

    @Nonnull
    public IGridNode getActionableNode() {
        if (this.gridNode == null && ForgeUtil.isServer()) {
            this.gridNode = AEApi.instance().grid().createGridNode((IGridBlock)this.getGridBlock());
            this.initGridNodeOwner();
            this.gridNode.updateState();
        }
        return this.gridNode;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    protected IEssentiaStorageChannel getChannel() {
        return (IEssentiaStorageChannel)AEApi.instance().storage().getStorageChannel(IEssentiaStorageChannel.class);
    }

    @Override
    public void gridChanged() {
    }

    @Override
    public void setOwner(EntityPlayer player) {
        this.owner = player;
    }

    @Override
    public EntityPlayer getOwner() {
        return this.owner;
    }

    public void securityBreak() {
        this.func_145831_w().func_175655_b(this.func_174877_v(), true);
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        if (ForgeUtil.isServer()) {
            return this.gridNode != null && this.gridNode.isActive();
        }
        return this.isActive;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b == null) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 2);
    }

    @MENetworkEventSubscribe
    public final void updateBootStatus(MENetworkBootingStatusChange event) {
        this.func_70296_d();
    }

    @MENetworkEventSubscribe
    public void updatePowerStatus(MENetworkPowerStatusChange event) {
        try {
            this.isPowered = GridUtil.getEnergyGrid(this).isNetworkPowered();
            this.func_70296_d();
        }
        catch (GridAccessException e) {
            this.isPowered = false;
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTagCompound = super.func_189517_E_();
        nbtTagCompound.func_74757_a("powered", this.isPowered());
        nbtTagCompound.func_74757_a("active", this.isActive());
        return nbtTagCompound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.isPowered = tag.func_74767_n("powered");
        this.isActive = tag.func_74767_n("active");
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
    }

    public void withPowerStateText(Consumer<String> consumer, Function<IThELangKey, String> localizationMapper) {
        if (this.isPowered()) {
            if (this.isActive()) {
                consumer.accept(localizationMapper.apply(ThEApi.instance().lang().deviceOnline()));
            } else {
                consumer.accept(localizationMapper.apply(ThEApi.instance().lang().deviceMissingChannel()));
            }
        } else {
            consumer.accept(localizationMapper.apply(ThEApi.instance().lang().deviceOffline()));
        }
    }
}

