/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.appeng.grid;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;
import thaumicenergistics.api.storage.IAEEssentiaStack;
import thaumicenergistics.api.storage.IEssentiaStorageChannel;
import thaumicenergistics.util.AEUtil;
import thaumicenergistics.util.EssentiaFilter;

public class EssentiaContainerAdapter
implements IMEInventoryHandler<IAEEssentiaStack> {
    private IAspectContainer container;
    private EssentiaFilter config;
    private IncludeExclude whitelistMode;
    private AccessRestriction cachedAccessRestriction;
    private boolean hasReadAccess;
    private boolean hasWriteAccess;
    private boolean reportInaccessible;
    private int priority;

    public EssentiaContainerAdapter(IAspectContainer container, EssentiaFilter config, boolean whitelist, AccessRestriction access, StorageFilter filter, int priority) {
        this.container = container;
        this.config = config;
        this.setWhitelist(whitelist);
        this.setBaseAccess(access);
        this.setReportInaccessible(filter);
        this.priority = priority;
    }

    public boolean isWhitelist() {
        return this.whitelistMode == IncludeExclude.WHITELIST;
    }

    public void setWhitelist(boolean whitelist) {
        this.whitelistMode = whitelist ? IncludeExclude.WHITELIST : IncludeExclude.BLACKLIST;
    }

    public void setReportInaccessible(StorageFilter reportInaccessible) {
        this.reportInaccessible = reportInaccessible != StorageFilter.EXTRACTABLE_ONLY;
    }

    public IAEEssentiaStack injectItems(IAEEssentiaStack input, Actionable type, IActionSource src) {
        if (input == null || !input.isMeaningful() || !this.canAccept(input)) {
            return input;
        }
        int notAdded = this.container.addToContainer(input.getAspect(), (int)input.getStackSize());
        if (type == Actionable.SIMULATE) {
            this.container.takeFromContainer(input.getAspect(), (int)input.getStackSize() - notAdded);
        }
        if (notAdded > 0) {
            return (IAEEssentiaStack)input.setStackSize(notAdded);
        }
        return null;
    }

    public IAEEssentiaStack extractItems(IAEEssentiaStack request, Actionable mode, IActionSource src) {
        if (request == null || !request.isMeaningful()) {
            return null;
        }
        if (!this.hasReadAccess) {
            return null;
        }
        if (this.container.containerContains(request.getAspect()) <= 0) {
            return null;
        }
        Aspect aspect = request.getAspect();
        int max = (int)Math.min((long)this.container.containerContains(aspect), request.getStackSize());
        if (mode == Actionable.SIMULATE) {
            return AEUtil.getAEStackFromAspect(aspect, max);
        }
        boolean worked = this.container.takeFromContainer(aspect, max);
        if (!worked) {
            return null;
        }
        return (IAEEssentiaStack)request.setStackSize(max);
    }

    public IItemList<IAEEssentiaStack> getAvailableItems(IItemList<IAEEssentiaStack> out) {
        if (this.container == null || !this.hasReadAccess && !this.reportInaccessible) {
            return out;
        }
        for (Aspect aspect : this.container.getAspects().getAspects()) {
            out.add((IAEStack)AEUtil.getAEStackFromAspect(aspect, this.container.containerContains(aspect)));
        }
        return out;
    }

    public void setBaseAccess(AccessRestriction access) {
        this.cachedAccessRestriction = access;
        this.hasReadAccess = access.hasPermission(AccessRestriction.READ);
        this.hasWriteAccess = access.hasPermission(AccessRestriction.WRITE);
    }

    public AccessRestriction getAccess() {
        return this.cachedAccessRestriction;
    }

    public boolean isPrioritized(IAEEssentiaStack input) {
        return false;
    }

    public boolean canAccept(IAEEssentiaStack input) {
        if (this.container == null || !this.hasWriteAccess) {
            return false;
        }
        boolean inFilter = this.config.isInFilter(input.getAspect());
        boolean containerCanAccept = this.container.doesContainerAccept(input.getAspect());
        if (this.whitelistMode == IncludeExclude.BLACKLIST) {
            if (inFilter) {
                return false;
            }
            return containerCanAccept;
        }
        if (!this.config.hasAspects()) {
            return containerCanAccept;
        }
        return inFilter && containerCanAccept;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getSlot() {
        return 0;
    }

    public boolean validForPass(int i) {
        return true;
    }

    public IStorageChannel<IAEEssentiaStack> getChannel() {
        return AEApi.instance().storage().getStorageChannel(IEssentiaStorageChannel.class);
    }
}

